<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/MenuBtnVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/MenuBtnVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="MenuBtnVBT.i3">MenuBtnVBT</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="ButtonVBT.i3">ButtonVBT</A>, <A HREF="BtnVBTClass.i3">BtnVBTClass</A>, <A HREF="TextVBT.i3">TextVBT</A>;

FROM <A HREF="../vbt/VBT.i3">VBT</A> IMPORT ClickType;

REVEAL
  <A NAME="T">T</A> = ButtonVBT.T BRANDED OBJECT
  OVERRIDES
    mouse := Mouse;
    init := Be
  END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(v: T; ch: VBT.T; p: ButtonVBT.Proc;
  ref: REFANY := NIL): ButtonVBT.T =
  BEGIN
    EVAL ButtonVBT.T.init(v, ch, p, ref);
    v.armed := TRUE;
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(
    ch: VBT.T;
    action: ButtonVBT.Proc;
    ref: REFANY := NIL): T RAISES {} =
  BEGIN
    RETURN Be(NEW(T), ch, action, ref)
  END New;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(v: T; READONLY cd: VBT.MouseRec) RAISES {} =
  BEGIN
    Filter.T.mouse(v, cd);
    IF cd.clickType # ClickType.FirstDown THEN
      IF (cd.clickType = ClickType.LastUp) AND NOT cd.cp.gone
      THEN
        IF NOT v.ready THEN v.pre() END;
        v.action(v, cd);
        v.post()
      ELSIF v.ready THEN
        v.cancel()
      END;
      v.ready := FALSE
    END
  END Mouse;

PROCEDURE <A NAME="TextItem"><procedure>TextItem</procedure></A>(name: TEXT;
  action: ButtonVBT.Proc;
  ref: REFANY := NIL): T RAISES {} =
  BEGIN
    RETURN
    New(TextVBT.New(name, 0.0, 0.5, 3.0, 0.5),
        action := action,
        ref := ref)
  END TextItem;

BEGIN
END MenuBtnVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
