<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/OverlayVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/OverlayVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="OverlayVBT.i3">OverlayVBT</A></implements></module>;

IMPORT <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../vbt/Batch.i3">Batch</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="Filter.i3">Filter</A>,
       <A HREF="../vbt/BatchRep.i3">BatchRep</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        active := FALSE;
        rgn    := Region.Empty;
      OVERRIDES
        init       := Init;
        set        := Set;
        paint      := Paint;
        repaint    := Repaint;
        reshape    := Reshape;
        capture    := Capture;
        paintbatch := PaintBatch;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; ch: VBT.T): T =
  BEGIN
    EVAL Filter.T.init(v, ch);
    RETURN v;
  END Init;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (v: T; READONLY rgn: Region.T) =
  VAR diff := Region.SymmetricDifference(rgn, v.rgn);
  BEGIN
    LOCK v DO v.active := NOT Region.IsEmpty(rgn); v.rgn := rgn END;
    Repaint(v, diff);
  END Set;

PROCEDURE <A NAME="Paint"><procedure>Paint</procedure></A>(&lt;* UNUSED *&gt; v: T; &lt;* UNUSED *&gt; READONLY rgn: Region.T) =
  BEGIN
    (* The default paint procedure is a no-op *)
  END Paint;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (v: T; READONLY rgn: Region.T) =
  BEGIN
    IF v.active THEN v.paint(Region.Meet(rgn, v.rgn)) END;
    Filter.T.repaint(v, rgn);
  END Repaint;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(v: T; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    IF v.active THEN v.paint(v.rgn) END;
    Filter.T.reshape(v, cd);
  END Reshape;

PROCEDURE <A NAME="Capture"><procedure>Capture</procedure></A> (               v : T;
                   &lt;* UNUSED *&gt; ch  : VBT.T;
                       READONLY rect: Rect.T;
                       VAR      br  : Region.T): ScrnPixmap.T =
  VAR res := VBT.Capture(v, rect, br);
  BEGIN
    IF v.active THEN br := Region.Join(br, v.rgn) END;
    RETURN res
  END Capture;

PROCEDURE <A NAME="PaintBatch"><procedure>PaintBatch</procedure></A> (v: T; ch: VBT.T; ba: Batch.T) =
  VAR rect: Rect.T;
  BEGIN
    IF NOT v.active THEN
      VBTClass.PaintBatch(v, ba)
    ELSE
      BatchUtil.Tighten(ba);
      IF Rect.IsEmpty(ba.scrollSource) THEN
        rect := ba.clip;
        VBTClass.PaintBatch(v, ba);
        v.paint(Region.FromRect(rect))
      ELSE
        VBTClass.ForceRepaint(ch, Region.FromRect(ba.clip));
        Batch.Free(ba);
      END
    END
  END PaintBatch;

BEGIN
END OverlayVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
