<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/PackSplit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/PackSplit.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> PackSplit.i3 by cgn &amp; msm, coded Sat Nov  1 18:19:34 1986 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>PackSplit.T</CODE> is a parent window whose children are packed into
   multiple rows or columns, depending on the {\it axis} of the split.
<P>
   If the axis is horizontal, the children are packed into rows from west
   to east, moving south to a new row when the current row fills up.  This
   is the normal style used in placing words in a paragraph.
<P>
   If the axis is vertical, the children are packed into columns from north
   to south, moving east to a new column when the current column fills up.
   This is the normal style used in placing paragraphs in a newspaper
   article.
<P>
   A <CODE>PackSplit</CODE> always gives its children their preferred height and
   width, even if this makes them extend outside the parent domain (in
   which case they will be clipped).
<P>
   If the axis is horizontal, the children in any given row have their
   north edges aligned, and all children that are first in their row have
   their west edges aligned with the west edge of the parent.  A child will
   be horizontally clipped if its requested horizontal size exceeds the
   parent's horizontal size; in this case the child will be alone in its
   row.
<P>
   If the axis is vertical, the children in any given column have their
   west edges aligned, and all children that are first in their column have
   their north edge aligned with the north edge of the parent.  A child
   will be vertically clipped if its requested vertical size exceeds the
   parent's vertical size; in this case the child will be alone in its
   column.
<P>
   The {\it size} of a window is the extent of its domain in the axis of
   the <CODE>PackSplit</CODE>; its {\it cross-size} is its extent in the other axis.
<P>
   The minimum desirable size for a <CODE>PackSplit</CODE> is the maximum of the prefs
   of its children; the preferred size is the current size, unless this is
   0, in which case the preferred size is same as the minimum size.  The
   maximum size is the default for a <CODE>VBT</CODE>.  The shape method uses the size
   to determine the cross-size that is just large enough to pack in all the
   children at their preferred sizes, and returns as its range of desirable
   cross-sizes a singleton interval containing only this cross-size. 

<P><PRE>INTERFACE <interface><A HREF="PackSplit.m3">PackSplit</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>;

TYPE
  <A HREF="PackSplit.m3#T">T</A> &lt;: Public;
  <A HREF="PackSplit.m3#Private">Private</A> &lt;: VBT.Split;
  Public = Private OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(hv := Axis.T.Hor;
      hgap, vgap := 1.5;
      txt: Pixmap.T := Pixmap.Solid;
      op: PaintOp.T := PaintOp.Bg;
      nwAlign := FALSE;
      saveBits := FALSE): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as an empty packsplit with 
   axis <CODE>hv</CODE>. 

<P> For a horizontal <CODE>PackSplit</CODE>, <CODE>hgap</CODE> is the gap to leave between
   children in each row; <CODE>vgap</CODE> is the gap to leave between rows.  For
   a vertical <CODE>PackSplit</CODE>, <CODE>vgap</CODE> is the gap to leave between children
   in each column; <CODE>hgap</CODE> is the gap to leave between columns.  The gaps
   are specified in millimeters.
<P>
   The area not covered by children is painted using the painting
   operation <CODE>op</CODE> and the texture <CODE>txt+delta</CODE>, where <CODE>delta</CODE> is the
   origin unless <CODE>nwAlign</CODE> is set to <CODE>TRUE</CODE>, in which case <CODE>delta</CODE> will
   be set to the northwest corner of <CODE>v</CODE>.
<P>
   If <CODE>saveBits</CODE> is <CODE>TRUE</CODE>, the implementation will try to save the
   children's old bits when reshaping; if the children don't use the
   old bits, it is more efficient to let <CODE>saveBits</CODE> default to <CODE>FALSE</CODE>. 

<P>
<P><PRE>PROCEDURE <A HREF="PackSplit.m3#New">New</A>(
  hv := Axis.T.Hor;
  hgap, vgap := 1.5;
  txt: Pixmap.T := Pixmap.Solid;
  op: PaintOp.T := PaintOp.Bg;
  nwAlign := FALSE;
  saveBits := FALSE): T; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PackSplit.m3#Set">Set</A>(
  v: T;
  txt: Pixmap.T;
  op: PaintOp.T := PaintOp.BgFg;
  nwAlign := FALSE); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the texture displayed by <CODE>v</CODE> and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PackSplit.m3#Get">Get</A>(
  v: T;
  VAR txt: Pixmap.T;
  VAR op: PaintOp.T;
  VAR nwAlign: BOOLEAN
  ); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Fetch the texture displayed by <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PackSplit.m3#AxisOf">AxisOf</A>(v: T): Axis.T; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the axis of <CODE>v</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PackSplit.m3#HGap">HGap</A>(v: T): REAL; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the <CODE>hgap</CODE> of <CODE>v</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PackSplit.m3#VGap">VGap</A>(v: T): REAL; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the <CODE>vgap</CODE> of <CODE>v</CODE>.  </EM></BLOCKQUOTE><PRE>

END PackSplit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
