<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/ProperSplit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/ProperSplit.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           

<P><PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>ProperSplit.T</CODE> is a type of <CODE>VBT.Split</CODE> that contains a
   circularly-linked list of its children.  All of Trestle's built-in
   splits that are not filters are subclasses of <CODE>ProperSplit</CODE>.  
   
<P><PRE>INTERFACE <interface><A HREF="ProperSplit.m3">ProperSplit</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Split.i3">Split</A>;

TYPE
  <A HREF="ProperSplit.m3#T">T</A> &lt;: Public;
  Public = VBT.Split OBJECT
    &lt;* LL &gt;= {SELF, VBT.mu} *&gt;
    lastChild: Child := NIL
  END;
  Child = OBJECT
    &lt;* LL &gt;= {SELF.ch.parent, VBT.mu} *&gt;
    pred, succ: Child := NIL;
    ch: VBT.T
  END;
</PRE> If <CODE>ch</CODE> is a child of a <CODE>ProperSplit.T</CODE>, then <CODE>ch.upRef</CODE> must be of
   type <CODE>ProperSplit.Child</CODE>, and <CODE>ch.upRef.ch</CODE> must equal <CODE>ch</CODE>.  The
   <CODE>succ</CODE> and <CODE>pred</CODE> links represent a doubly-linked list of the
   children.  The <CODE>succ</CODE> links are circular; the <CODE>pred</CODE> links are
   linear.  The parent's <CODE>lastChild</CODE> field is is <CODE>NIL</CODE> if there are
   no children; otherwise it points to the last child in <CODE>succ</CODE> order.
   <P>
   The locking level comments imply that to write any of the links,
   a thread must have both <CODE>VBT.mu</CODE> and the parent locked.
   <P>
   If <CODE>v</CODE> is a <CODE>T</CODE>, the call <CODE>v.beChild(ch)</CODE> sets <CODE>ch.upref</CODE>
   to <CODE>NEW(Child)</CODE> if it is <CODE>NIL</CODE>.  In any case it sets
   <CODE>ch.upref.ch := ch</CODE> and calls <CODE>VBT.Split.beChild(v, ch)</CODE>. 
   
<P> The following procedures are useful for implementing subtypes
   of <CODE>ProperSplit.T</CODE>: 

<P><PRE>PROCEDURE <A HREF="ProperSplit.m3#Insert">Insert</A>(v: T; pred: Child; newch: VBT.T);
&lt;* LL &gt;= {VBT.mu, v, newch} *&gt;
</PRE><BLOCKQUOTE><EM> Insert <CODE>newch</CODE> as a new child after <CODE>pred</CODE>, and mark <CODE>v</CODE> for
   redisplay. </EM></BLOCKQUOTE><PRE>
</PRE> The child <CODE>newch</CODE> must be detached and of the appropriate
   screentype.  It can be <CODE>NIL</CODE> to indicate insertion at the head of
   the list.  <CODE>Insert</CODE> calls the <CODE>beChild</CODE> method of <CODE>newCh</CODE>.  

<P><PRE>PROCEDURE <A HREF="ProperSplit.m3#PreInsert">PreInsert</A>(v: T; pred, ch: VBT.T): Child
  RAISES {Split.NotAChild}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Rescreen <CODE>ch</CODE> to have <CODE>v</CODE>'s screentype (if necessary), cause a checked
   runtime error if <CODE>ch</CODE> is attached, raise <CODE>Split.NotAChild</CODE> if <CODE>pred</CODE>
   is non-nil and not a child of <CODE>v</CODE>, and finally return <CODE>pred.upRef</CODE>, or
   <CODE>NIL</CODE> if <CODE>pred</CODE> is <CODE>NIL</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ProperSplit.m3#Move">Move</A>(v: T; pred, ch: Child);
&lt;* LL &gt;= {VBT.mu, v} *&gt;
</PRE><BLOCKQUOTE><EM> Move <CODE>ch</CODE> in the list of children so that it follows <CODE>pred</CODE> and
   mark <CODE>v</CODE> for redisplay.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ProperSplit.m3#Delete">Delete</A>(v: T; ch: Child);
&lt;* LL &gt;= {VBT.mu} AND LL.sup &lt; v  *&gt;
</PRE><BLOCKQUOTE><EM> Remove <CODE>ch</CODE> from the list of children, detach <CODE>ch.ch</CODE>, and
   mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

END ProperSplit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
