<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/ProperSplit.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/ProperSplit.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ProperSplit.i3">ProperSplit</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="Split.i3">Split</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>;

REVEAL <A NAME="T">T</A> = Public BRANDED OBJECT
  OVERRIDES
    succ := Succ;
    pred := Pred;
    nth := Nth;
    index := Index;
    beChild := BeChild
  END;

PROCEDURE <A NAME="PreInsert"><procedure>PreInsert</procedure></A>(v: T; pred, ch: VBT.T): Child
  RAISES {Split.NotAChild} =
  VAR predCh: Child;
  BEGIN
    IF ch.parent # NIL THEN Crash() END;
    IF pred # NIL THEN
      IF pred.parent # v THEN RAISE Split.NotAChild END;
      predCh := pred.upRef
    ELSE
      predCh := NIL
    END;
    IF v.st # ch.st THEN VBTClass.Rescreen(ch, v.st) END;
    RETURN predCh
  END PreInsert;

PROCEDURE <A NAME="BeChild"><procedure>BeChild</procedure></A>(v: VBT.Split; ch: VBT.T) RAISES {} =
  BEGIN
    IF ch.upRef = NIL THEN ch.upRef := NEW(Child) END;
    NARROW(ch.upRef, Child).ch := ch;
    VBT.Split.beChild(v, ch)
  END BeChild;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A>(v: T; ch: VBT.T): VBT.T RAISES {} =
  BEGIN
    IF ch = NIL THEN
      IF v.lastChild = NIL THEN
        RETURN NIL
      ELSE
        RETURN v.lastChild.succ.ch
      END
    ELSE
      WITH ur = NARROW(ch.upRef, Child) DO
        IF ur = v.lastChild THEN
          RETURN NIL
        ELSE
          RETURN ur.succ.ch
        END
      END
    END
  END Succ;

PROCEDURE <A NAME="Pred"><procedure>Pred</procedure></A>(v: T; ch: VBT.T): VBT.T RAISES {} =
  BEGIN
    IF ch = NIL THEN
      IF v.lastChild = NIL THEN
        RETURN NIL
      ELSE
        RETURN v.lastChild.ch
      END
    ELSE
      WITH ur = NARROW(ch.upRef, Child) DO
        IF ur.pred = NIL THEN RETURN NIL ELSE RETURN ur.pred.ch END
      END
    END
  END Pred;

PROCEDURE <A NAME="Nth"><procedure>Nth</procedure></A>(v: T; n: CARDINAL): VBT.T RAISES {} =
  VAR ur, lc := v.lastChild;
  BEGIN
    IF ur = NIL THEN RETURN NIL END;
    ur := ur.succ;
    WHILE (ur # lc) AND (n # 0) DO
      DEC(n); ur := ur.succ
    END;
    IF n = 0 THEN RETURN ur.ch ELSE RETURN NIL END
  END Nth;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(v: T; ch: VBT.T): CARDINAL RAISES {} =
  VAR res := 0; ur := v.lastChild;
  BEGIN
    IF ch = NIL THEN
      WHILE ur # NIL DO INC(res); ur := ur.pred END
    ELSE
      ur := ur.succ;
      WHILE ur.ch # ch DO INC(res); ur := ur.succ END
    END;
    RETURN res
  END Index;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A>(v: T; pred: Child; newch: VBT.T) RAISES {} =
  BEGIN
    v.beChild(newch);
    InsertInternal(v, pred, newch.upRef)
  END Insert;

PROCEDURE <A NAME="InsertInternal"><procedure>InsertInternal</procedure></A>(v: T; pred, ur: Child) RAISES {} =
  VAR insertLast := (pred = v.lastChild);
  BEGIN
    ur.pred := pred;
    IF pred = NIL THEN pred := v.lastChild END;
    IF pred = NIL THEN
      ur.succ := ur
    ELSE
      ur.succ := pred.succ;
      pred.succ := ur
    END;
    IF insertLast THEN v.lastChild := ur ELSE ur.succ.pred := ur END
  END InsertInternal;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A>(v: T; pred, ch: Child) RAISES {} =
  BEGIN
    IF pred = ch THEN Crash() END;
    IF ch.pred # pred THEN
      VBTRep.Mark(v);
      DeleteInternal(v, ch);
      InsertInternal(v, pred, ch)
    END
  END Move;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A>(v: T; ch: Child) RAISES {} =
  BEGIN
    VBT.Mark(v);
    LOCK v DO
      DeleteInternal(v, ch);
      ch.pred := NIL;
      ch.succ := NIL
    END;
    VBTClass.Detach(ch.ch)
  END Delete;

PROCEDURE <A NAME="DeleteInternal"><procedure>DeleteInternal</procedure></A>(v: T; ch: Child) RAISES {} =
  BEGIN
    IF ch.pred = NIL THEN
      v.lastChild.succ := ch.succ
    ELSE
      ch.pred.succ := ch.succ
    END;
    IF v.lastChild = ch THEN
      v.lastChild := ch.pred
    ELSE
      ch.succ.pred := ch.pred
    END;
  END DeleteInternal;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A> () =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Crash;

BEGIN END ProperSplit.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
