<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/RigidVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/RigidVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="RigidVBT.i3">RigidVBT</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>;

REVEAL <A NAME="T">T</A> = Public BRANDED OBJECT
    sh: Shape
  OVERRIDES
    shape := ShapeDefault;
    newShape := NewShape;
    init := Be
  END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(v: T; ch: VBT.T; sh: Shape): T RAISES {} =
  BEGIN
    EVAL Filter.T.init(v, ch);
    v.sh := sh;
    FOR i := FIRST(Axis.T) TO LAST(Axis.T) DO
      WITH s = sh[i] DO
        IF s.pref &lt; s.lo OR s.pref &gt; s.hi THEN Crash() END
      END
    END;
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(ch: VBT.T; sh: Shape): T =
  BEGIN RETURN Be(NEW(T), ch, sh) END New;

PROCEDURE <A NAME="FromHV"><procedure>FromHV</procedure></A>(
  ch: VBT.T;
  h, v: REAL;
  hMax, vMax, hPref, vPref: REAL := -1.0)
  : T RAISES {} =
  BEGIN
    IF hMax = -1.0 THEN hMax := h END;
    IF vMax = -1.0 THEN vMax := v END;
    IF hPref = -1.0 THEN hPref := h END;
    IF vPref = -1.0 THEN vPref := v END;
    RETURN New(ch, Shape{SizeRange{lo := h, pref := hPref, hi := hMax},
      SizeRange{lo := v, pref := vPref, hi := vMax}})
  END FromHV;

PROCEDURE <A NAME="NewShape"><procedure>NewShape</procedure></A>(&lt;*UNUSED*&gt;v: T; &lt;*UNUSED*&gt;ch: VBT.T) RAISES {} =
  BEGIN END NewShape;

PROCEDURE <A NAME="ShapeDefault"><procedure>ShapeDefault</procedure></A>(v: T; ax: Axis.T; &lt;*UNUSED*&gt; n: CARDINAL): VBT.SizeRange =
  VAR
    s := v.sh[ax];
    lo := ROUND(VBT.MMToPixels(v, s.lo, ax));
    hi := ROUND(VBT.MMToPixels(v, s.hi, ax)) + 1;
    pref := ROUND(VBT.MMToPixels(v, s.pref, ax));
  BEGIN
    RETURN VBT.SizeRange{lo := lo, pref := pref, hi := hi}
  END ShapeDefault;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;*FATAL FatalError*&gt;
  BEGIN
    RAISE FatalError
  END Crash;

BEGIN END RigidVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
