<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/Split.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/Split.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

&lt;*PRAGMA LL*&gt;
</PRE> The Split interface provides the functionality that is common 
   to all splits; for example, enumerating and deleting children.  
   <P>
   This interface is for clients of splits; see the <CODE>VBTClass</CODE> and
   <CODE>ProperSplit</CODE> interfaces for information about implementing your own 
   split classes.  

<P><PRE>INTERFACE <interface><A HREF="Split.m3">Split</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>;

TYPE T = VBT.Split;

EXCEPTION NotAChild;
</PRE> A <CODE>Split.T</CODE> is a <CODE>VBT</CODE> that divides its screen up between one or more 
   child <CODE>VBTs</CODE>.  
   The children of a split are ordered; they can be enumerated
   with the <CODE>Succ</CODE> and <CODE>Pred</CODE> procedures: 

<P><PRE>PROCEDURE <A HREF="Split.m3#Succ">Succ</A>(v: T; ch: VBT.T): VBT.T
RAISES {NotAChild}; &lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE> that follows the child <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The successor of <CODE>NIL</CODE> is the first child; the successor of the last
   child is <CODE>NIL</CODE>; the successor of <CODE>NIL</CODE> is <CODE>NIL</CODE> if there are no
   children.  The exception <CODE>NotAChild</CODE> is raised if <CODE>ch</CODE> is not a child
   of <CODE>v</CODE>.  

<P>
<P><PRE>PROCEDURE <A HREF="Split.m3#Pred">Pred</A>(v: T; ch: VBT.T): VBT.T
RAISES {NotAChild}; &lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE> that precedes the child <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> More precisely, <CODE>Pred(v,ch) = x</CODE> iff <CODE>Succ(v,x) = ch</CODE>.  All of
  Trestle's standard splits implement <CODE>Succ</CODE> and <CODE>Pred</CODE> in constant
  time.  

<P><PRE>PROCEDURE <A HREF="Split.m3#NumChildren">NumChildren</A>(v: T): CARDINAL;
&lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the number of children of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Split.m3#Nth">Nth</A>(v: T; n: CARDINAL): VBT.T;
&lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE> with index <CODE>n</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> More precisely, <CODE>Nth(v, n)</CODE> is the child of <CODE>v</CODE> with <CODE>n</CODE>
   predecessors, or <CODE>NIL</CODE> if <CODE>v</CODE> has at most <CODE>n</CODE> children.  Warning:
   for Trestle's standard splits, <CODE>Nth</CODE> requires time proportional to
   <CODE>n</CODE>, so it would be wasteful to enumerate the children by calling
   it repeatedly; use <CODE>Succ</CODE> instead.  

<P>
<P><PRE>PROCEDURE <A HREF="Split.m3#Index">Index</A>(v: T; ch: VBT.T): CARDINAL
RAISES {NotAChild}; &lt;* LL &gt;= {VBT.mu} *&gt;
</PRE><BLOCKQUOTE><EM> Return the index of <CODE>v</CODE>'s child <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Index(v, ch)</CODE> is the value <CODE>n</CODE> such that <CODE>Nth(v, n) = ch</CODE>.  
   <CODE>Index(v, NIL)</CODE> equals <CODE>NumChildren(v)</CODE>.  

<P>
<P><PRE>PROCEDURE <A HREF="Split.m3#Locate">Locate</A>(v: T; READONLY pt: Point.T): VBT.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE> that controls the point <CODE>pt</CODE>, 
   or <CODE>NIL</CODE> if there is no such child. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Split.m3#Delete">Delete</A>(v: T; ch: VBT.T) RAISES {NotAChild};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Delete the child <CODE>ch</CODE> of the split <CODE>v</CODE>, detach <CODE>ch</CODE>, and mark <CODE>v</CODE>
   for redisplay.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Split.m3#Replace">Replace</A>(v: T; ch, new: VBT.T)
RAISES {NotAChild}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Replace child <CODE>ch</CODE> of <CODE>v</CODE> with <CODE>new</CODE>, detach <CODE>ch</CODE> (which must not be <CODE>NIL</CODE>),
   and mark <CODE>v</CODE> for redisplay.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Split.m3#Insert">Insert</A>(v: T; pred, new: VBT.T)
RAISES {NotAChild}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Add <CODE>new</CODE> as a child of <CODE>v</CODE> following <CODE>pred</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> Some split classes can accomodate only a bounded number of children
  (for example, filters).  If <CODE>Insert(v, pred, new)</CODE> is applied to
  a split <CODE>v</CODE> that cannot accomodate an additional child, then <CODE>pred</CODE>
  (or the original first child, if <CODE>pred = NIL</CODE>) is deleted from the
  split and discarded.  The precise semantics are defined by the
  individual splits.  <CODE>Insert</CODE> raises <CODE>NotAChild</CODE> if <CODE>pred</CODE> isn't a
  child of <CODE>v</CODE>, and is a checked run-time error if <CODE>new</CODE> isn't detached.
  

<P><PRE>PROCEDURE <A HREF="Split.m3#Move">Move</A>(v: T; pred, ch: VBT.T)
RAISES {NotAChild}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Move child <CODE>ch</CODE> of <CODE>v</CODE> to follow <CODE>pred</CODE>.  Both <CODE>ch</CODE> and (if non-<CODE>NIL</CODE>) 
   <CODE>pred</CODE> must be children of <CODE>v</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Split.m3#AddChildArray">AddChildArray</A>(v: T;
  READONLY new: ARRAY OF VBT.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Insert the non-<CODE>NIL</CODE> elements of <CODE>new</CODE> at the end of the <CODE>v</CODE>'s 
   list of children.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>AddChildArray</CODE> is equivalent to
   <P>
<PRE>
       pred := Pred(v, NIL);
       FOR i := 0 TO LAST(new) DO
         IF new[i] # NIL THEN
           InsertAfter(v, pred, new[i]);
           pred := new[i]
         END
       END
 

<P><PRE>PROCEDURE <A HREF="Split.m3#AddChild">AddChild</A>(v: T;
  v0, v1, v2, v3, v4, v5, v6, v7, v8, v9: VBT.T := NIL);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Add the given children to <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>AddChild</CODE> is equivalent to 
<PRE>
       AddChildArray(v, 
         ARRAY OF VBT.T{v0, v1, ..., v9})


<P><PRE>END Split.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
