<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/Split.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/Split.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="Split.i3">Split</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A>(v: T; ch: VBT.T) RAISES {NotAChild} =
  BEGIN
    Replace(v, ch, NIL)
  END Delete;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A>(v: T; ch, new: VBT.T) RAISES {NotAChild} =
  BEGIN
    IF ch = NIL OR ch.parent # v THEN RAISE NotAChild END;
    IF new # NIL AND new.parent # NIL THEN Crash() END;
    IF new # NIL AND new.st # v.st THEN VBTClass.Rescreen(new, v.st) END;
    v.replace(ch, new);
    VBT.Mark(v)
  END Replace;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A>(v: T; pred, new: VBT.T) RAISES {NotAChild} =
  BEGIN
    IF pred # NIL AND pred.parent # v THEN RAISE NotAChild END;
    IF new = NIL OR new.parent # NIL THEN Crash() END;
    IF new.st # v.st THEN VBTClass.Rescreen(new, v.st) END;
    v.insert(pred, new);
    VBT.NewShape(v);
    VBT.Mark(v)
  END Insert;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A>(v: T; pred, ch: VBT.T) RAISES {NotAChild} =
  BEGIN
    IF ch = NIL OR ch.parent # v THEN RAISE NotAChild END;
    IF pred # NIL AND pred.parent # v THEN RAISE NotAChild END;
    IF pred = ch OR v.succ(pred) = ch THEN RETURN END;
    v.move(pred, ch);
    VBT.Mark(v)
  END Move;

PROCEDURE <A NAME="AddChildArray"><procedure>AddChildArray</procedure></A>(v: T; READONLY new: ARRAY OF VBT.T) =
  &lt;*FATAL NotAChild*&gt;
  VAR pred := Pred(v, NIL); BEGIN
    FOR i := 0 TO LAST(new) DO
      IF new[i] # NIL THEN
        Insert(v, pred, new[i]);
        pred := new[i]
      END
    END
  END AddChildArray;

PROCEDURE <A NAME="AddChild"><procedure>AddChild</procedure></A>(v: T;
  new0, new1, new2, new3, new4, new5, new6, new7, new8, new9: VBT.T := NIL) =
  BEGIN
    AddChildArray(v, ARRAY OF VBT.T{new0, new1, new2, new3, new4,
      new5, new6, new7, new8, new9})
  END AddChild;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A>(v: T; ch: VBT.T): VBT.T RAISES {NotAChild} =
  BEGIN
    IF ch # NIL AND ch.parent # v THEN RAISE NotAChild END;
    RETURN v.succ(ch)
  END Succ;

PROCEDURE <A NAME="Pred"><procedure>Pred</procedure></A>(v: T; ch: VBT.T): VBT.T RAISES {NotAChild} =
  BEGIN
    IF ch # NIL AND ch.parent # v THEN RAISE NotAChild END;
    RETURN v.pred(ch)
  END Pred;

PROCEDURE <A NAME="Nth"><procedure>Nth</procedure></A>(v: T; n: CARDINAL): VBT.T RAISES {} =
  BEGIN
    RETURN v.nth(n)
  END Nth;

PROCEDURE <A NAME="NumChildren"><procedure>NumChildren</procedure></A>(v: T): CARDINAL RAISES {} =
  BEGIN
    RETURN v.index(NIL)
  END NumChildren;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(v: T; ch: VBT.T): CARDINAL RAISES {NotAChild} =
  BEGIN
    IF ch # NIL AND ch.parent # v THEN RAISE NotAChild END;
    RETURN v.index(ch)
  END Index;

PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A>(v: T; READONLY pt: Point.T): VBT.T RAISES {} =
  VAR r: Rect.T;
  BEGIN
    RETURN v.locate(pt, r)
  END Locate;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;*FATAL FatalError*&gt;
  BEGIN
    RAISE FatalError
  END Crash;

BEGIN END Split.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
