<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/StableVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/StableVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>StableVBT.T</CODE> is a filter whose size range is determined
   as follows:
<P>
   its max and min size are its child's max and min size.
<P>
   its preferred size is determined as follows: if its own size
   satisfies its max and min size, then its preferred size is its own
   size, otherwise its preferred size is its child's preference,
   unless the filter is projecting, in which case the preferred size
   is the projection of the VBTs own size into the child's size range.  Its 
   <CODE>own size</CODE> is its current size if this is non-empty, or its last non-empty
   size otherwise, unless. SetShape has been called the next calls to the
   shape procedures use the values set.
<P>
   Thus when the child changes its preferred shape, the parent generally
   does not.  To allow a new preferred shape of a child to get through
   the filter, the filter can be temporarily disabled.
   <P>
   

<P><PRE>INTERFACE <interface><A HREF="StableVBT.m3">StableVBT</A></interface>;

IMPORT <A HREF="Filter.i3">Filter</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="StableVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(ch: VBT.T; project := TRUE): T
  END;
</PRE> The call <CODE>v.init(ch, b)</CODE> initializes <CODE>v</CODE> as a <CODE>StableVBT</CODE> with
   child <CODE>ch</CODE>.  v is projecting if b is TRUE. 

<P><PRE>PROCEDURE <A HREF="StableVBT.m3#New">New</A>(ch: VBT.T; project := TRUE): T;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableVBT.m3#Disable">Disable</A>(v: VBT.T); &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Temporarily disable the lowest (possibly improper) ancestor of <CODE>v</CODE>
   that is a <CODE>StableVBT.T</CODE>, if any.  </EM></BLOCKQUOTE><PRE>
</PRE> While disabled, the filter reports its preferred size as the 
   child's preferred size.  The filter will be reenabled as soon
   as it is reshaped to a non-empty domain. 

<P><PRE>PROCEDURE <A HREF="StableVBT.m3#SetShape">SetShape</A>(v: VBT.T; hPref, vPref: CARDINAL); &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Set the own shape of the lowest <CODE>StableVBT.T</CODE> ancestor of <CODE>v</CODE>.  A value
   of <CODE>0</CODE> leaves the current value unchanged. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableVBT.m3#GetProjecting">GetProjecting</A>(v: VBT.T): BOOLEAN; &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Return TRUE if the lowest <CODE>StableVBT.T</CODE> ancestor of <CODE>v</CODE> is projecting </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableVBT.m3#SetProjecting">SetProjecting</A>(v: VBT.T; project: BOOLEAN); &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Set the lowest <CODE>StableVBT.T</CODE> ancestor of <CODE>v</CODE> to be projecting </EM></BLOCKQUOTE><PRE>

END StableVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
