<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/StableVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/StableVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="StableVBT.i3">StableVBT</A></implements></module>;

IMPORT <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>;

CONST
  NoPref = ARRAY Axis.T OF INTEGER {-1, ..};
  BigPref = ARRAY Axis.T OF INTEGER{VBT.DefaultShape.hi, ..};

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        &lt;* LL &gt;= {SELF} *&gt;
        pref     := NoPref;
        scrShape := BigPref;
        proj     := TRUE
      OVERRIDES
        shape    := Shape;
        reshape  := Reshape;
        rescreen := Rescreen;
        init     := Init;
      END;

PROCEDURE <A NAME="Disable"><procedure>Disable</procedure></A>(v: VBT.T) = BEGIN
  LOOP
    TYPECASE v OF
      NULL =&gt; RETURN
    | T (w) =&gt; LOCK w DO w.pref := NoPref END; RETURN
    ELSE v := VBT.Parent(v)
    END
  END
END Disable;

PROCEDURE <A NAME="GetProjecting"><procedure>GetProjecting</procedure></A>(v: VBT.T): BOOLEAN = BEGIN
  LOOP
    TYPECASE v OF
      NULL =&gt; RETURN FALSE
    | T (w) =&gt; LOCK w DO RETURN w.proj END
    ELSE v := VBT.Parent(v)
    END
  END
END GetProjecting;

PROCEDURE <A NAME="SetProjecting"><procedure>SetProjecting</procedure></A> (v: VBT.T; proj: BOOLEAN) =
  BEGIN
    LOOP
      TYPECASE v OF
        NULL =&gt; RETURN
      | T (w) =&gt; LOCK w DO w.proj := proj END; RETURN
      ELSE
        v := VBT.Parent(v)
      END
    END
  END SetProjecting;

PROCEDURE <A NAME="SetShape"><procedure>SetShape</procedure></A> (v: VBT.T; hPref, vPref: CARDINAL) =
  BEGIN
    LOOP
      TYPECASE v OF
        NULL =&gt; RETURN
      | T (w) =&gt;
          LOCK w DO
            IF hPref # 0 THEN w.pref[Axis.T.Hor] := hPref END;
            IF vPref # 0 THEN w.pref[Axis.T.Ver] := vPref END
          END;
          VBT.NewShape(v);
          RETURN
      ELSE
        v := VBT.Parent(v)
      END
    END
  END SetShape;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (w: T; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  VAR res: VBT.SizeRange;
  BEGIN
    IF n = 0 THEN n := Rect.Size(ax, VBT.Domain(w)) END;
    res := Filter.T.shape(w, ax, n);
    LOCK w DO
      IF res.lo &lt;= w.pref[ax] AND w.pref[ax] &lt; res.hi THEN
        res.pref := w.pref[ax]
      ELSIF w.pref[ax] &lt; 0 THEN
        res.pref := MAX(res.lo, MIN(res.pref, w.scrShape[ax]))
      ELSIF w.proj THEN
        res.pref := MAX(res.lo, MIN(res.hi - 1, w.pref[ax]))
      END
    END;
    RETURN res
  END Shape;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(w: T; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    IF NOT Rect.IsEmpty(cd.new) THEN
      LOCK w DO
        FOR ax := FIRST(Axis.T) TO LAST(Axis.T) DO
          w.pref[ax] := Rect.Size(ax, cd.new)
        END
      END
    END;
    Filter.T.reshape(w, cd)
  END Reshape;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (w: T; READONLY cd: VBT.RescreenRec) =
  VAR dom := Trestle.ScreenOf(w, Point.Origin).dom;
  BEGIN
    FOR ax := FIRST(Axis.T) TO LAST(Axis.T) DO
      w.scrShape[ax] := Rect.Size(ax, dom)
    END;
    Public.rescreen(w, cd)
  END Rescreen;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(v: T; ch: VBT.T; proj: BOOLEAN): T =
  BEGIN
    LOCK v DO v.proj := proj END;
    EVAL Filter.T.init(v, ch);
    RETURN v
  END Init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(ch: VBT.T; project := TRUE): T = BEGIN
    RETURN NEW(T).init(ch, project)
  END New;

BEGIN END StableVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
