<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TSplit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TSplit.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> PackSplit.i3 by cgn &amp; msm, coded Sat Nov  1 18:19:34 1986 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>TSplit.T</CODE> is a parent window that giving its entire screen to
   one child at a time.  The child being displayed is called the {\it
   current child}.  The current child can be <CODE>NIL</CODE>, in which case the
   <CODE>TSplit</CODE> ignores all events.  

<P><PRE>INTERFACE <interface><A HREF="TSplit.m3">TSplit</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Split.i3">Split</A>;

TYPE
  <A HREF="TSplit.m3#T">T</A> &lt;: Public;
  <A HREF="TSplit.m3#Private">Private</A> &lt;: Split.T;
  Public = Private OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(fickle := TRUE): T
  END;
</PRE> The call <CODE>v.init(fickle)</CODE> initialize <CODE>v</CODE> as an empty <CODE>TSplit</CODE>.
<P>
   If <CODE>fickle</CODE> is <CODE>TRUE</CODE>, then the shape of <CODE>v</CODE> will be the shape of
   its current child, or a <CODE>VBT</CODE>'s default shape if the current child
   is <CODE>NIL</CODE>.  If <CODE>fickle</CODE> is <CODE>FALSE</CODE>, then in each axis the size range
   of <CODE>v</CODE> will be the intersection of the size ranges of its children (if
   this intersection is empty, the children's maxsizes are increased
   until the intersection is non-empty). The preferred size of <CODE>v</CODE> is
   the the maximum of the preferred sizes of its children, projected
   into <CODE>v</CODE>'s size range.  If <CODE>v</CODE> has no children, its shape is a 
   <CODE>VBT</CODE>'s default shape.  

<P>
<P><PRE>PROCEDURE <A HREF="TSplit.m3#SetCurrent">SetCurrent</A>(v: T; ch: VBT.T)
RAISES {Split.NotAChild}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set the current child of <CODE>v</CODE> to be <CODE>ch</CODE> and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TSplit.m3#GetCurrent">GetCurrent</A>(v: T): VBT.T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the current child of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TSplit.m3#Cons">Cons</A>(ch0, ch1, ch2, ch3, ch4: VBT.T := NIL;
  fickle := TRUE): T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Create a <CODE>TSplit</CODE> with children <CODE>ch0</CODE>, <CODE>ch1</CODE>, .... </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Cons</CODE> is equivalent to
<P>
<PRE>
      v := NEW(T).init(fickle);
      Split.AddChild(v, ch0, ch1, ch2, ch3, ch4);  
      IF ch0 # NIL THEN SetCurrent(v, ch0) END;
      RETURN v
</PRE>


<P><PRE>END TSplit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
