<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TSplit.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TSplit.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="TSplit.i3">TSplit</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Split.i3">Split</A>, <A HREF="ProperSplit.i3">ProperSplit</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>,
  <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>;

REVEAL
  <A NAME="Private">Private</A> = ProperSplit.T BRANDED OBJECT END;
  <A NAME="T">T</A> = Public BRANDED OBJECT
    current: VBT.T := NIL;
    fickle: BOOLEAN;
  OVERRIDES
    reshape := Reshape;
    repaint := Repaint;
    redisplay := Redisplay;
    shape := Shape;
    replace := Replace;
    insert := Insert;
    move := Move;
    locate := Locate;
    newShape := NewShape;
    axisOrder := AxisOrder;
    init := Be
  END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(v: T; fickle: BOOLEAN): T =
  BEGIN v.fickle := fickle; RETURN v END Be;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A>(v: T; ax: Axis.T; n: CARDINAL): VBT.SizeRange RAISES {} =
  BEGIN
    IF (v.fickle AND v.current = NIL) OR v.succ(NIL) = NIL THEN
      RETURN VBT.DefaultShape
    ELSIF v.fickle THEN
      RETURN VBTClass.GetShape(v.current, ax, n)
    ELSE
      VAR
        ch := v.succ(NIL);
        sh := VBT.SizeRange{lo := 0, pref := 0, hi := LAST(INTEGER)};
      BEGIN
        WHILE ch # NIL DO
          VAR shP := VBTClass.GetShape(ch, ax, n); BEGIN
            sh.lo := MAX(sh.lo, shP.lo);
            sh.hi := MIN(sh.hi, shP.hi);
            sh.pref := MAX(sh.pref, shP.pref);
            ch := v.succ(ch)
          END
        END;
        sh.hi := MAX(sh.hi, sh.lo + 1);
        sh.pref := MIN(sh.pref, sh.hi - 1);
        RETURN sh
      END
    END
  END Shape;

PROCEDURE <A NAME="Cons"><procedure>Cons</procedure></A>(ch0, ch1, ch2, ch3, ch4: VBT.T := NIL; fickle := TRUE): T =
  &lt;*FATAL Split.NotAChild*&gt;
  VAR v := NEW(T);
  BEGIN
    EVAL Be(v, fickle);
    Split.AddChild(v, ch0, ch1, ch2, ch3, ch4);
    IF ch0 # NIL THEN SetCurrent(v, ch0) END;
    RETURN v
  END Cons;

PROCEDURE <A NAME="Redisplay"><procedure>Redisplay</procedure></A>(v: T) RAISES {} =
  BEGIN
    IF (v.current # NIL) AND NOT Rect.Equal(v.current.domain, v.domain) THEN
      VBTClass.Reshape(v.current, v.domain, v.domain);
    END
  END Redisplay;

PROCEDURE <A NAME="SetCurrent"><procedure>SetCurrent</procedure></A>(v: T; ch: VBT.T) RAISES {Split.NotAChild} =
  BEGIN
    IF ch = v.current THEN RETURN END;
    IF (ch # NIL) AND (ch.parent # v) THEN RAISE Split.NotAChild END;
    IF v.fickle THEN
      IF ch = NIL OR v.current = NIL OR
       VBTClass.GetShapes(ch) # VBTClass.GetShapes(v.current, FALSE)
      OR ch.axisOrder() # v.current.axisOrder()
      THEN
        VBT.NewShape(v)
      END
    ELSIF ch # NIL AND AxisOrder(v) # ch.axisOrder()
       OR ch = NIL AND AxisOrder(v) # ProperSplit.T.axisOrder(v) THEN
      VBT.NewShape(v)
    END;
    IF v.current # NIL THEN
      VBTClass.Reshape(v.current, Rect.Empty, Rect.Empty)
    END;
    v.current := ch;
    VBT.Mark(v);
    VBTClass.LocateChanged(v)
  END SetCurrent;

PROCEDURE <A NAME="GetCurrent"><procedure>GetCurrent</procedure></A>(v: T): VBT.T =
  BEGIN
    RETURN v.current;
  END GetCurrent;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A>(v: T; pred, ch: VBT.T) =
  &lt;*FATAL Split.NotAChild*&gt;
  VAR predCh := ProperSplit.PreInsert(v, pred, ch);
  BEGIN
    LOCK ch DO
      LOCK v DO ProperSplit.Insert(v, predCh, ch) END;
      VBTClass.SetShortCircuit(ch)
    END;
    IF NOT v.fickle THEN VBT.NewShape(v) END
  END Insert;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A>(v:  T; pred, ch:  VBT.T) =
  VAR predCh: ProperSplit.Child;
  BEGIN
    IF pred # NIL THEN
      predCh := pred.upRef
    ELSE
      predCh := NIL
    END;
    LOCK v DO ProperSplit.Move(v, predCh, ch.upRef) END
  END Move;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A>(v: T; ch, new: VBT.T) RAISES {} =
  BEGIN
    IF v.current = ch THEN v.current := new END;
    IF new # NIL THEN Insert(v, ch, new) END;
    IF NOT v.fickle OR v.current = new
    AND (new = NIL OR
         VBTClass.GetShapes(new, FALSE) #
         VBTClass.GetShapes(ch, FALSE))
    THEN
      VBT.NewShape(v)
    END;
    ProperSplit.Delete(v, ch.upRef)
  END Replace;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(v: T; READONLY cd: VBT.ReshapeRec) RAISES {} =
  BEGIN
    IF v.current # NIL THEN
      VBTClass.Reshape(v.current, cd.new, cd.saved)
    END
  END Reshape;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A>(v: T; READONLY badR: Region.T) RAISES {} =
  BEGIN
    IF v.current # NIL THEN
      VBTClass.Repaint(v.current, badR)
    END
  END Repaint;

PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A>(
    v: T;
    &lt;*UNUSED*&gt; READONLY pt: Point.T;
    VAR rect: Rect.T): VBT.T RAISES {} =
  BEGIN
    IF v.current # NIL THEN
      rect := v.current.domain;
      RETURN v.current
    ELSE
      rect := Rect.Empty;
      RETURN NIL
    END
  END Locate;

PROCEDURE <A NAME="NewShape"><procedure>NewShape</procedure></A>(v: T; ch: VBT.T) RAISES {} =
  BEGIN
    IF NOT v.fickle OR v.current = ch THEN VBT.NewShape(v) END
  END NewShape;

PROCEDURE <A NAME="AxisOrder"><procedure>AxisOrder</procedure></A>(v: T): Axis.T =
  BEGIN
    IF v.current = NIL THEN
      RETURN ProperSplit.T.axisOrder(v)
    ELSE
      RETURN v.current.axisOrder()
    END
  END AxisOrder;

BEGIN
END TSplit.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
