<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TextVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TextVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> File: TextVBT.i3, coded by cgn Sun Jun 28 16:13:38 1987 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>TextVBT.T</CODE> is a <CODE>VBT</CODE> that displays a text string.
<P>
   The minimum size of a <CODE>TextVBT</CODE> is just large enough to display its
   text (surrounded by any margins that were supplied when the <CODE>TextVBT</CODE>
   was created), except that if its text is empty its minimum size is
   just large enough to display the text ``<CODE>X</CODE>''.  Its preferred size
   is the same as its minimum size, and its maximum size is very large.
   

<P><PRE>INTERFACE <interface><A HREF="TextVBT.m3">TextVBT</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/Font.i3">Font</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>;

TYPE
  <A HREF="TextVBT.m3#T">T</A> &lt;: Public;
  Public = VBT.Leaf OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(txt: TEXT;
      halign, valign: REAL := 0.5;
      hmargin: REAL := 0.5;
      vmargin: REAL := 0.0;
      fnt: Font.T := Font.BuiltIn;
      bgFg: PaintOp.ColorQuad := NIL): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>TextVBT</CODE> that displays the 
   text <CODE>txt</CODE> in the font <CODE>fnt</CODE>, and returns <CODE>v</CODE>.
<P>
   The text will be painted with <CODE>bgFg</CODE>'s foreground; the background
   will be painted with <CODE>bgFg</CODE>'s background.  If <CODE>bgFg</CODE> is <CODE>NIL</CODE> these
   default to <CODE>PaintOp.Fg</CODE> and <CODE>PaintOp.Bg</CODE>.  The text should not
   contain any newline characters: it will be treated as a single line.
   If <CODE>halign = 0.0</CODE>, the west boundary of the text will be indented
   by the given <CODE>hmargin</CODE> (in millimeters) from the west boundary of
   the <CODE>VBT</CODE>; if <CODE>halign = 1.0</CODE>, the east boundary of the text will
   be inside the east boundary of the <CODE>VBT</CODE> by the given <CODE>hmargin</CODE>;
   for other values of <CODE>halign</CODE>, the horizontal position of the text
   is computed by linear interpolation.  In particular, <CODE>halign = 0.5</CODE>
   centers the text horizontally.  The vertical position is determined
   by <CODE>vmargin</CODE> and <CODE>valign</CODE> in a similar way.  
   <P>
   Control-left-click in the text sets the source selection to be a
   readonly version of the text.  Thus you can copy the text out of
   any <CODE>TextVBT</CODE>.  

<P><PRE>PROCEDURE <A HREF="TextVBT.m3#New">New</A>(
    txt: TEXT;
    halign, valign: REAL := 0.5;
    hmargin: REAL := 0.5;
    vmargin: REAL := 0.0;
    fnt: Font.T := Font.BuiltIn;
    bgFg: PaintOp.ColorQuad := NIL) : T;
    &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextVBT.m3#Put">Put</A>(v: T; txt: TEXT); &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Change the text displayed by <CODE>v</CODE> to be <CODE>txt</CODE> and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextVBT.m3#Get">Get</A>(v: T): TEXT; &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Return the text displayed by v. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextVBT.m3#SetFont">SetFont</A>(
  v: T;
  fnt: Font.T;
  bgFg : PaintOp.ColorQuad := NIL);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set <CODE>v</CODE>'s <CODE>font</CODE> and <CODE>bgFg</CODE> to the given values and mark <CODE>v</CODE> 
   for redisplay. If <CODE>bgFg</CODE> is defaulted, <CODE>PaintOp.bgFg</CODE> is used. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextVBT.m3#GetFont">GetFont</A>(v: T): Font.T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>v</CODE>'s font. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextVBT.m3#GetQuad">GetQuad</A>(v: T): PaintOp.ColorQuad;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>v</CODE>'s color quad. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextVBT.m3#GetTextRect">GetTextRect</A>(v: T): Rect.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the current bounding rectangle of <CODE>v</CODE>'s text. </EM></BLOCKQUOTE><PRE>

END TextVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
