<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TextureVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TextureVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> File: TextureVBT.i3, coded by cgn Thu Apr 30 14:28:28 1987 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>TextureVBT.T</CODE> is a <CODE>VBT</CODE> that displays a texture, possibly
   colored.  Its preferred and minimum sizes are zero and its maximum 
   size is very large, in each axis.  

<P><PRE>INTERFACE <interface><A HREF="TextureVBT.m3">TextureVBT</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>;

TYPE
  <A HREF="TextureVBT.m3#T">T</A> &lt;: Public;
  Public = VBT.Leaf OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(op: PaintOp.T := PaintOp.BgFg;
      txt: Pixmap.T := Pixmap.Solid;
      nwAlign: BOOLEAN := FALSE): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>TextureVBT</CODE> 
   displaying <CODE>txt</CODE> with the painting operation <CODE>op</CODE>.
<P>
   The domain of <CODE>v</CODE> will be painted using the painting operation <CODE>op</CODE>
   and the texture <CODE>txt+delta</CODE>, where <CODE>delta</CODE> is the origin unless
   <CODE>nwAlign</CODE> is set to <CODE>TRUE</CODE>, in which case <CODE>delta</CODE> will be set to
   the northwest corner of <CODE>v</CODE>.  

<P><PRE>PROCEDURE <A HREF="TextureVBT.m3#New">New</A>(
  op: PaintOp.T := PaintOp.BgFg;
  txt: Pixmap.T := Pixmap.Solid;
  nwAlign: BOOLEAN := FALSE): T;  &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextureVBT.m3#Set">Set</A>(
  v: T;
  op: PaintOp.T := PaintOp.BgFg;
  txt: Pixmap.T := Pixmap.Solid;
  nwAlign: BOOLEAN := FALSE);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change <CODE>v</CODE>'s texture and mark it for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextureVBT.m3#Get">Get</A>(
  v: T;
  VAR op: PaintOp.T;
  VAR txt: Pixmap.T;
  VAR nwAlign: BOOLEAN); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Fetch <CODE>v</CODE>'s texture. </EM></BLOCKQUOTE><PRE>

END TextureVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
