<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TextureVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TextureVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="TextureVBT.i3">TextureVBT</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>;

REVEAL <A NAME="T">T</A> = Public BRANDED OBJECT
    op: PaintOp.T;
    txt: Pixmap.T;
    nwAlign: BOOLEAN
  OVERRIDES
    repaint := Repaint;
    reshape := Reshape;
    redisplay := Redisplay;
    init := Be
  END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(
  v: T;
  op: PaintOp.T := PaintOp.BgFg;
  txt: Pixmap.T := Pixmap.Solid;
  nwAlign: BOOLEAN := FALSE): T =
  BEGIN
    v.op := op;
    v.txt := txt;
    v.nwAlign := nwAlign;
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(
  op: PaintOp.T  := PaintOp.BgFg;
  txt: Pixmap.T := Pixmap.Solid;
  nwAlign: BOOLEAN := FALSE): T RAISES {} =
  BEGIN
    RETURN Be(NEW(T), op, txt, nwAlign);
  END New;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(
  v: T;
  op: PaintOp.T := PaintOp.BgFg;
  txt: Pixmap.T := Pixmap.Solid;
  nwAlign: BOOLEAN := FALSE)
  RAISES {} =
  BEGIN v.op := op; v.txt := txt; v.nwAlign := nwAlign; VBT.Mark(v) END Set;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(
  v: T;
  VAR op: PaintOp.T;
  VAR txt: Pixmap.T;
  VAR nwAlign: BOOLEAN) =
  BEGIN op := v.op; txt := v.txt; nwAlign := v.nwAlign END Get;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A>(v: T; READONLY rgn: Region.T) =
  BEGIN
    IF v.nwAlign THEN
      VBT.PaintTexture(v, rgn.r, v.op, v.txt, Rect.NorthWest(VBT.Domain(v)))
    ELSE
      VBT.PaintTexture(v, rgn.r, v.op, v.txt, Point.Origin)
    END
  END Repaint;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(v: T; &lt;*UNUSED*&gt; READONLY cd: VBT.ReshapeRec) =
  BEGIN Repaint(v, Region.Full) END Reshape;

PROCEDURE <A NAME="Redisplay"><procedure>Redisplay</procedure></A>(v: T) =
  BEGIN Repaint(v, Region.Full) END Redisplay;

BEGIN END TextureVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
