<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TranslateVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TranslateVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="TranslateVBT.i3">TranslateVBT</A></implements></module>;

IMPORT <A HREF="Filter.i3">Filter</A>, <A HREF="FilterClass.i3">FilterClass</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>,
  <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../vbt/Batch.i3">Batch</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../vbt/MouseSplit.i3">MouseSplit</A>;

REVEAL
  <A NAME="T">T</A> = Filter.T BRANDED OBJECT
    delta: Point.T;
    (* child coord + delta = parent coord. *)
    (* v.delta is protected both by v and by VBT.mu.
       (If v is disconnected, these locks are not necessary). *)
    screen: VBT.ScreenID := -1
  OVERRIDES
    (* VBT down methods *)
    reshape := Reshape;
    repaint := Repaint;
    rescreen := Rescreen;
    mouse := Mouse;
    position := Position;

    (* VBT up methods *)
    setcage := SetCage;
    setcursor := SetCursor;
    paintbatch := PaintBatch;
    capture := Capture;
    screenOf := ScreenOf;

    (* split methods *)
    beChild := BeChild;
    init := Be
  END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(v: T; ch: VBT.T): Filter.T =
  BEGIN
    LOCK v DO
      v.delta := Rect.NorthWest(v.domain)
    END;
    EVAL Filter.Replace(v, ch);
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(ch: VBT.T): T =
  BEGIN RETURN Be(NEW(T), ch) END New;

PROCEDURE <A NAME="BeChild"><procedure>BeChild</procedure></A>(v: T; ch: VBT.T) RAISES {} =
  BEGIN
    Filter.T.beChild(v, ch);
    VBTClass.ClearShortCircuit(ch)
  END BeChild;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(prnt: T; READONLY cd: VBT.MouseRec) RAISES {} =
  VAR cdP: VBT.MouseRec; child := prnt.ch;
  BEGIN (* LL = VBT.mu *)
    IF child # NIL THEN
      cdP := cd;
      IF NOT cdP.cp.gone THEN
        cdP.cp.pt := Point.Sub(cdP.cp.pt, prnt.delta)
      END;
      VBTClass.Mouse(child, cdP)
    END
  END Mouse;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(prnt: T; READONLY cd: VBT.PositionRec) RAISES {} =
  VAR cdP: VBT.PositionRec; child := prnt.ch;
  BEGIN (* LL = VBT.mu *)
    IF child # NIL THEN
      cdP := cd;
      IF NOT cdP.cp.offScreen THEN
        cdP.cp.pt := Point.Sub(cd.cp.pt, prnt.delta)
      END;
      VBTClass.Position(child, cdP)
    END
  END Position;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A>(prnt: T; READONLY rgn: Region.T) RAISES {} =
  BEGIN (* LL = VBT.mu *)
    IF prnt.ch # NIL THEN
      VBTClass.Repaint(prnt.ch, Region.Sub(rgn, prnt.delta))
    END
  END Repaint;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A>(prnt: T; READONLY cd: VBT.RescreenRec) =
  VAR screen := Trestle.ScreenOf(prnt, Point.Origin).id; BEGIN
    LOCK prnt DO prnt.screen := screen END;
    Filter.T.rescreen(prnt, cd)
  END Rescreen;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(prnt: T; READONLY cd: VBT.ReshapeRec) RAISES {} =
  VAR
    deltaP: Point.T;
    saved, newchdom, chsaved: Rect.T;
    chbad: Region.T;
    child := prnt.ch;
  BEGIN (* LL = VBT.mu *)
    IF child # NIL THEN
      deltaP :=
        Point.Sub(Rect.NorthWest(cd.new), Rect.NorthWest(cd.prev));
      saved := Rect.Meet(Rect.Move(cd.saved, deltaP), cd.new);
      LOCK child DO
        VBT.Scroll(prnt, saved, deltaP);
        prnt.delta := Rect.NorthWest(cd.new)
      END;
      newchdom := Rect.Sub(cd.new, prnt.delta);
      chsaved := Rect.Sub(saved, prnt.delta);
      (* preserved region, in child's coordinates *)
      IF Rect.Equal(newchdom, VBT.Domain(child)) THEN
        (* Child's domain is unchanged; only need to repaint it *)
        chbad := Region.Difference(Region.FromRect(newchdom),
           Region.FromRect(chsaved));
        VBTClass.Repaint(child, chbad)
      ELSE
        VBTClass.Reshape(child, newchdom, chsaved)
      END
    END
  END Reshape;

PROCEDURE <A NAME="ScreenOf"><procedure>ScreenOf</procedure></A>(
    prnt: T;
    &lt;*UNUSED*&gt; ch: VBT.T;
    READONLY pt: Point.T):
    Trestle.ScreenOfRec
    RAISES {} =
  BEGIN (* LL=ch *)
    RETURN Trestle.ScreenOf(prnt, Point.Add(pt, prnt.delta));
  END ScreenOf;

PROCEDURE <A NAME="SetCage"><procedure>SetCage</procedure></A>(prnt: T; ch: VBT.T) RAISES {} =
  VAR cg := VBTClass.Cage(ch);
  BEGIN (* LL=ch *)
    LOCK prnt DO
      IF cg.rect # Rect.Full AND prnt.screen = cg.screen THEN
        cg.rect := Rect.Move(cg.rect, prnt.delta)
      END;
      VBTClass.SetCage(prnt, cg)
    END
  END SetCage;

PROCEDURE <A NAME="SetCursor"><procedure>SetCursor</procedure></A>(prnt: T; ch: VBT.T) RAISES {} =
  VAR cs := ch.getcursor();
  BEGIN (* LL=ch *)
    LOCK prnt DO
      IF cs # prnt.effectiveCursor THEN
        prnt.effectiveCursor := cs;
        IF prnt.parent # NIL THEN prnt.parent.setcursor(prnt) END
      END
    END
  END SetCursor;

PROCEDURE <A NAME="Capture"><procedure>Capture</procedure></A>(
    prnt: T;
    &lt;*UNUSED*&gt; ch: VBT.T;
    READONLY rect: Rect.T;
    VAR (*out*) br: Region.T)
    : ScrnPixmap.T RAISES {} =
  VAR res: ScrnPixmap.T;
  BEGIN (* LL = ch *)
    res := VBT.Capture(prnt, Rect.Add(rect, prnt.delta), br);
    br := Region.Sub(br, prnt.delta);
    RETURN res
  END Capture;

PROCEDURE <A NAME="PaintBatch"><procedure>PaintBatch</procedure></A>(prnt: T; &lt;*UNUSED*&gt; ch: VBT.T; ba: Batch.T) RAISES {} =
  BEGIN
    BatchUtil.Clip(ba);
    BatchUtil.Translate(ba, prnt.delta);
    VBTClass.PaintBatch(prnt, ba)
  END PaintBatch;

BEGIN
END TranslateVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
