<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TwoTone.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TwoTone.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="TwoTone.i3">TwoTone</A></implements></module>;
IMPORT <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>,
       <A HREF="../vbt/ScreenType.i3">ScreenType</A>, <A HREF="../vbt/ScrnPaintOp.i3">ScrnPaintOp</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

TYPE
  PMClosure = Palette.PixmapClosure OBJECT
    pm: Pixmap.T
  METHODS OVERRIDES
    apply := PMApply
  END;

PROCEDURE <A NAME="PMApply"><procedure>PMApply</procedure></A>(cl: PMClosure; st: ScreenType.T): ScrnPixmap.T =
  BEGIN
    IF st.color OR st.depth &gt; 1 THEN
      RETURN Palette.ResolvePixmap(st, Pixmap.Solid)
    ELSE
      RETURN Palette.ResolvePixmap(st, cl.pm)
    END
  END PMApply;

TYPE
  OpClosure = Palette.OpClosure OBJECT
    op: PaintOp.T;
  METHODS OVERRIDES
    apply := OpApply;
  END;

PROCEDURE <A NAME="OpApply"><procedure>OpApply</procedure></A>(cl: OpClosure; st: ScreenType.T): ScrnPaintOp.T =
  BEGIN
    IF st.color OR st.depth &gt; 1 THEN
      RETURN Palette.ResolveOp(st, cl.op)
    ELSE
      RETURN Palette.ResolveOp(st, PaintOp.BgFg)
    END
  END OpApply;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(colorop: PaintOp.T; monotxt: Pixmap.T):T =
  BEGIN
    RETURN T { Palette.FromOpClosure(NEW(OpClosure, op := colorop)),
               Palette.FromPixmapClosure(NEW(PMClosure, pm := monotxt)) }
  END New;

PROCEDURE <A NAME="Paint"><procedure>Paint</procedure></A> (         v    : VBT.Leaf;
                 READONLY clip : Rect.T;
                 READONLY tone : T;
                 READONLY delta             := Point.Origin) = &lt;* LL.sup &lt; v *&gt;
  BEGIN VBT.PaintTexture(v, clip, tone.op, tone.txt, delta); END Paint;

BEGIN END TwoTone.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
