<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TypeInVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TypeInVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> File TypeInVBT.def 
<PRE>&lt;*PRAGMA LL*&gt;

INTERFACE <interface><A HREF="TypeInVBT.m3">TypeInVBT</A></interface>;
</PRE> A <CODE>TypeInVBT.T</CODE> is a <CODE>VBT</CODE> into which the user can type a one-line
   text string using ISO-Latin 1 keycodes.   
<P>
   A <CODE>TypeInVBT</CODE> acquires the keyboard focus when the user clicks on it
   with the mouse, or whenever the program directs it to by
   calling TakeFocus.  Whenever it acquires the keyboard focus, it also
   acquires the primary selection, and primary-selects the text string in
   the <CODE>VBT</CODE>.
<P>
   When it has the keyboard focus, the user can append to the text by 
   typing graphic characters, and can backspace by typing the key
   labelled <CODE>&lt;X]</CODE>.  Associated with every TypeInVBT is an action 
   procedure that is called whenever the user types
   a non-graphic character (such as <CODE>RETURN</CODE>).
<P>
   When a <CODE>TypeInVBT</CODE> it has the keyboard focus, it responds to 
   the following editing commands:
     control-q deletes the entire text (primary selection);
     control-w copies the secondary selection to the end of the text;
     control-e moves the secondary selection to the end of the text;
     control-r swaps the text (primary selection) with the secondary selection.
<P>
   You can make the entire text string be the secondary selection by
   control-clicking with the mouse.
<P>
   The TypeInVBT filters keystrokes through a ComposeKey.T.
<P>


<P>
<P><PRE>IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="TextVBT.i3">TextVBT</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Font.i3">Font</A>, <A HREF="ComposeKey.i3">ComposeKey</A>;

TYPE <A HREF="TypeInVBT.m3#T">T</A> &lt;: Public; Public = TextVBT.T OBJECT
  METHODS (* OVERRIDES *)
    init(
      txt: TEXT := &quot;&quot;;
      halign, valign: REAL := 0.5;
      hmargin: REAL := 0.5;
      vmargin: REAL := 0.5;
      fnt: Font.T := Font.BuiltIn;
      op: PaintOp.ColorQuad := NIL;
      action: Proc := NIL;
      ref: REFANY := NIL;
      composer: ComposeKey.T := NIL): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>TypeInVBT</CODE>.  This
   includes initializing <CODE>v</CODE> as a <CODE>TextVBT</CODE>, using the first seven
   arguments.  The <CODE>action</CODE> argument specifies <CODE>v</CODE>'s action procedure;
   if it is non-NIL, it is called for any non-printing characters that
   the user types, except for &lt;X] and control characters.  If <CODE>ref</CODE>
   is non-<CODE>NIL</CODE>, it is added to <CODE>v</CODE> property set.  The composer's filter
   method is invoked on every keystroke; if composer is NIL, TypeInVBT
   will allocate (and initialize) a new Composer.  If you pass a non-NIL
   value, you must take care to initialize the composer yourself. 

<P><PRE>TYPE
  <A HREF="TypeInVBT.m3#Composer">Composer</A> &lt;: CPublic;
  CPublic = ComposeKey.T OBJECT METHODS init (v: VBT.T) END;
</PRE><BLOCKQUOTE><EM> A Composer overrides the feedback method to change the cursor
   during composing. </EM></BLOCKQUOTE><PRE>

TYPE Proc = PROCEDURE(v: T; READONLY cd: VBT.KeyRec);

PROCEDURE <A HREF="TypeInVBT.m3#SetAction">SetAction</A>(v: T; action: Proc); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the action for non-printing, non-control characters. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TypeInVBT.m3#New">New</A>(
  txt: TEXT := &quot;&quot;;
  halign, valign: REAL := 0.5;
  hmargin: REAL := 0.5;
  vmargin: REAL := 0.5;
  fnt: Font.T := Font.BuiltIn;
  op: PaintOp.ColorQuad := NIL;
  action: Proc := NIL;
  ref: REFANY := NIL;
  composer: ComposeKey.T := NIL): T;
</PRE><BLOCKQUOTE><EM> <CODE>New(args)</CODE> is short for <CODE>NEW(T).init(args)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TypeInVBT.m3#TakeFocus">TakeFocus</A>(v: T; t: VBT.TimeStamp): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TakeFocus(v, t) causes <CODE>v</CODE> to acquire the keyboard focus and
   ownership of the primary selection and returns <CODE>TRUE</CODE>, or returns
   <CODE>FALSE</CODE> if one or both of these acquisitions failed.
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TypeInVBT.m3#HasFocus">HasFocus</A>(v: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Does v have the keyboard focus? LL = VBT.mu </EM></BLOCKQUOTE><PRE>

END TypeInVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
