<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/TypeInVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/TypeInVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="TypeInVBT.i3">TypeInVBT</A></implements></module>;

IMPORT <A HREF="TextVBT.i3">TextVBT</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/Font.i3">Font</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Latin1Key.i3">Latin1Key</A>, <A HREF="../vbt/KeyboardKey.i3">KeyboardKey</A>,
  <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="TextVBTClass.i3">TextVBTClass</A>, <A HREF="ComposeKey.i3">ComposeKey</A>, <A HREF="../vbt/Cursor.i3">Cursor</A>;

TYPE Selection = {KBFocus, Target, Source};

VAR
  map := ARRAY Selection OF VBT.Selection
    {VBT.KBFocus, VBT.Target, VBT.Source};

PROCEDURE <A NAME="Unmap"><procedure>Unmap</procedure></A>(sel: VBT.Selection): Selection =
  BEGIN
    FOR i := FIRST(map) TO LAST(map) DO
      IF map[i] = sel THEN RETURN i END
    END;
    Crash(); &lt;*ASSERT FALSE*&gt;
  END Unmap;

REVEAL <A NAME="T">T</A> = Public BRANDED OBJECT
    &lt;* LL &gt;= {VBT.mu} *&gt;
    composer: ComposeKey.T;
    action: Proc;
    has := ARRAY Selection OF BOOLEAN{FALSE, ..};
  OVERRIDES
    init := Init;
    mouse := Mouse;
    key := KeyCode;
    misc := MiscCode;
    read := Read;
    write := Write
  END;

VAR
  mu := NEW(MUTEX);
  inited := FALSE;
  composingCursor: Cursor.T := Cursor.TextPointer;

REVEAL
  <A NAME="Composer">Composer</A> = CPublic BRANDED OBJECT
               v: VBT.T := NIL
             OVERRIDES
               init := CompInit;
               feedback := Feedback
             END;

PROCEDURE <A NAME="Feedback"><procedure>Feedback</procedure></A> (c: Composer; composing: BOOLEAN) =
  BEGIN
    IF c.v # NIL THEN
      IF composing THEN
        VBT.SetCursor(c.v, composingCursor)
      ELSE
        VBT.SetCursor(c.v, Cursor.TextPointer)
      END
    END
  END Feedback;

PROCEDURE <A NAME="CompInit"><procedure>CompInit</procedure></A> (c: Composer; v: VBT.T) =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN
        inited := TRUE;
        composingCursor := Cursor.FromName(ARRAY OF TEXT{&quot;XC_exchange&quot;})
      END
    END;
    c.v := v
  END CompInit;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v             : T;
                txt           : TEXT              := &quot;&quot;;
                halign, valign: REAL              := 0.5;
                hmargin       : REAL              := 0.5;
                vmargin       : REAL              := 0.5;
                fnt           : Font.T            := Font.BuiltIn;
                op            : PaintOp.ColorQuad := NIL;
                action        : Proc              := NIL;
                ref           : REFANY            := NIL;
                composer      : ComposeKey.T                       ): T =
  VAR mycomp: Composer;
  BEGIN
    EVAL TextVBT.T.init(v, txt, halign, valign, hmargin, vmargin, fnt, op);
    IF composer = NIL THEN
      mycomp := NEW(Composer);
      mycomp.init(v);
      composer := mycomp
    END;
    v.composer := composer;
    v.action := action;
    IF ref # NIL THEN VBT.PutProp(v, ref) END;
    VBT.SetCursor(v, Cursor.TextPointer);
    RETURN v
  END Init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(
  txt: TEXT := &quot;&quot;;
  halign, valign: REAL := 0.5;
  hmargin: REAL := 0.5;
  vmargin: REAL := 0.5;
  fnt: Font.T := Font.BuiltIn;
  op: PaintOp.ColorQuad := NIL;
  action: Proc := NIL;
  ref: REFANY := NIL;
  composer: ComposeKey.T): T =
  BEGIN
    RETURN NEW(T).init(txt, halign, valign, hmargin, vmargin, fnt, op,
      action, ref, composer)
  END New;

PROCEDURE <A NAME="HasFocus"><procedure>HasFocus</procedure></A>(v: T): BOOLEAN =
  BEGIN RETURN v.has[Selection.KBFocus] END HasFocus;

PROCEDURE <A NAME="TakeSelection"><procedure>TakeSelection</procedure></A>(v: T; t: VBT.TimeStamp; s: Selection): BOOLEAN =
  BEGIN
    IF NOT v.has[s] THEN
      TRY
        VBT.Acquire(v, map[s], t);
        v.has[s] := TRUE
      EXCEPT
        VBT.Error =&gt; RETURN FALSE
      END
    END;
    RETURN TRUE
  END TakeSelection;

PROCEDURE <A NAME="TakeFocus"><procedure>TakeFocus</procedure></A>(v: T; t: VBT.TimeStamp): BOOLEAN =
  BEGIN
    RETURN TakeSelection(v, t, Selection.KBFocus)
       AND TakeSelection(v, t, Selection.Target)
  END TakeFocus;

PROCEDURE <A NAME="MiscCode"><procedure>MiscCode</procedure></A>(v: T; READONLY cd: VBT.MiscRec) =
  BEGIN
    IF cd.type = VBT.TakeSelection THEN
      IF cd.selection = VBT.KBFocus THEN
        EVAL TakeFocus(v, cd.time)
      ELSIF cd.selection = VBT.Target OR cd.selection = VBT.Source THEN
        EVAL TakeSelection(v, cd.time, Unmap(cd.selection))
      END
    ELSIF cd.type = VBT.Lost THEN
      FOR i := FIRST(map) TO LAST(map) DO
        IF map[i] = cd.selection THEN
          v.has[i] := FALSE
        END
      END
    END
  END MiscCode;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(v: T; READONLY cd: VBT.MouseRec) =
  BEGIN
    IF cd.clickType = VBT.ClickType.FirstDown THEN
      IF VBT.Modifier.Control IN cd.modifiers THEN
        EVAL TakeSelection(v, cd.time, Selection.Source)
      ELSE
        EVAL TakeFocus(v, cd.time)
      END
    END
  END Mouse;

PROCEDURE <A NAME="KeyCode"><procedure>KeyCode</procedure></A> (v: T; READONLY inputCd: VBT.KeyRec) =
  VAR cd := inputCd;
  BEGIN
    IF inputCd.wentDown AND cd.whatChanged # VBT.NoKey THEN
      LOOP
        IF v.composer # NIL THEN cd := v.composer.filter(cd) END;
        IF cd.whatChanged = VBT.NoKey THEN EXIT END;
        DoKeyCode(v, cd);
        cd.whatChanged := VBT.NoKey
      END
    END
  END KeyCode;

PROCEDURE <A NAME="DoKeyCode"><procedure>DoKeyCode</procedure></A> (v: T; READONLY cd: VBT.KeyRec) =
  CONST
    NoCtrlOpt = VBT.Modifiers{FIRST(VBT.Modifier).. LAST(VBT.Modifier)}
                  - VBT.Modifiers{
                      VBT.Modifier.Control, VBT.Modifier.Option};
  VAR
    handled := FALSE;
    wc      := cd.whatChanged;
  BEGIN
    IF NOT cd.wentDown OR Rect.IsEmpty(VBT.Domain(v)) THEN RETURN END;
    IF wc &gt; 0 AND wc &lt;= Latin1Key.ydiaeresis THEN
      IF cd.modifiers &lt;= NoCtrlOpt THEN
        LOCK v DO
          v.text := v.text &amp; Text.FromChar(VAL(cd.whatChanged, CHAR));
        END;
        VBT.Mark(v);
        handled := TRUE
      ELSIF wc = Latin1Key.Q OR wc = Latin1Key.q THEN
        TextVBT.Put(v, &quot;&quot;);
        handled := TRUE
      ELSIF wc = Latin1Key.W OR wc = Latin1Key.w THEN
        TRY
          TYPECASE VBT.Read(v, VBT.Source, cd.time).toRef() OF
            TEXT (t) =&gt; LOCK v DO v.text := v.text &amp; t; END; VBT.Mark(v)
          ELSE                   (* skip *)
          END
        EXCEPT
          VBT.Error =&gt;           (* skip *)
        END;
        handled := TRUE
      ELSIF wc = Latin1Key.E OR wc = Latin1Key.e THEN
        TRY
          TYPECASE VBT.Read(v, VBT.Source, cd.time).toRef() OF
            TEXT (t) =&gt;
              LOCK v DO v.text := v.text &amp; t END;
              VBT.Mark(v);
              IF NOT v.has[Selection.Source] THEN
                VBT.Write(v, VBT.Source, cd.time, VBT.FromRef(&quot;&quot;))
              END
          ELSE                   (* skip *)
          END
        EXCEPT
          VBT.Error =&gt;           (* skip *)
        END;
        handled := TRUE
      ELSIF wc = Latin1Key.R OR wc = Latin1Key.r THEN
        VAR o := TextVBT.Get(v);
        BEGIN
          TRY
            TYPECASE VBT.Read(v, VBT.Source, cd.time).toRef() OF
              TEXT (t) =&gt;
                TextVBT.Put(v, t);
                VBT.Write(v, VBT.Source, cd.time, VBT.FromRef(o))
            ELSE                 (* skip *)
            END
          EXCEPT
            VBT.Error =&gt;         (* skip *)
          END
        END;
        handled := TRUE
      END
    ELSIF wc = KeyboardKey.BackSpace OR wc = KeyboardKey.Delete THEN
      LOCK v DO
        v.text := Text.Sub(v.text, 0, MAX(0, Text.Length(v.text) - 1));
      END;
      VBT.Mark(v);
      handled := TRUE
    END;
    IF v.action # NIL AND NOT handled THEN v.action(v, cd) END
  END DoKeyCode;

PROCEDURE <A NAME="SetAction"><procedure>SetAction</procedure></A>(v: T; action: Proc) =
  BEGIN
    v.action := action
  END SetAction;

PROCEDURE <A NAME="Read"><procedure>Read</procedure></A>(v: T; &lt;*UNUSED*&gt;s: VBT.Selection; tc: CARDINAL): VBT.Value
  RAISES {VBT.Error} =
  BEGIN
    IF tc = TYPECODE(TEXT) THEN
      LOCK v DO RETURN VBT.FromRef(v.text) END;
    ELSE
      RAISE VBT.Error(VBT.ErrorCode.WrongType)
    END
  END Read;

PROCEDURE <A NAME="Write"><procedure>Write</procedure></A>(v: T; s: VBT.Selection; val: VBT.Value; tc: CARDINAL)
  RAISES {VBT.Error} =
  BEGIN
    IF tc = TYPECODE(TEXT) THEN
      TYPECASE val.toRef() OF
        TEXT (t) =&gt;
          IF s = VBT.Target THEN
            LOCK v DO v.text := v.text &amp; t END
          ELSE
            LOCK v DO v.text := t END
          END;
          VBT.Mark(v);
          RETURN
      ELSE (* skip *)
      END
    END;
    RAISE VBT.Error(VBT.ErrorCode.WrongType)
  END Write;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;*FATAL FatalError*&gt;
  BEGIN
    RAISE FatalError
  END Crash;

BEGIN END TypeInVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
