<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/ZSplit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/ZSplit.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> ZSplit.i3, coded Fri Oct 31 11:24:53 1986 by cgn 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>ZSplit.T</CODE> is a parent window with overlapping child windows. 
   <P>
   Each child has a stacking order given (conceptually) by a <CODE>z</CODE>
   coordinate.  A pixel of the parent's screen that is in the domain
   of more than one child is controlled by whichever of these children
   is highest in the <CODE>z</CODE> coordinate.  The portions of the domains of
   the children that extend outside the parent domain will be clipped.
   <P>
   <CODE>Split.Succ</CODE> enumerates the children from top to bottom.
<P>
   The bottom child is called the {\it background}.  An initial
   background can be specified when the <CODE>ZSplit</CODE> is created; usually
   it remains the background throughout the life of the <CODE>ZSplit</CODE>.
   Usually the background has the same domain as the parent, and
   therefore controls all pixels that are not controlled by any other
   child.  In the unusual case that the background child has a domain
   different from the parent domain, there may be some parent pixels
   that are not controlled by any child.  The <CODE>ZSplit</CODE> will ignore these
   pixels when asked to repaint.
   <P>
   The shape of a <CODE>ZSplit</CODE> is the shape of its background child (if
   it has no children its shape is the default shape for a <CODE>VBT</CODE>).  When
   the preferred shape of a non-background child changes, the <CODE>ZSplit</CODE>
   reshapes the child to its new preferred shape, preserving its 
   {\it offset}, which is the vector between the northwest corners 
   of the parent and child.  
   
<P><PRE>INTERFACE <interface><A HREF="ZSplit.m3">ZSplit</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="Split.i3">Split</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>;

TYPE
  <A HREF="ZSplit.m3#T">T</A> &lt;: Public;
  <A HREF="ZSplit.m3#Private">Private</A> &lt;: Split.T;
  Public = Private OBJECT METHODS
    &lt;* LL &lt;= VBT.mu *&gt;
    init(bg: VBT.T := NIL;
      saveBits := FALSE;
      parlim: INTEGER := -1): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>ZSplit</CODE>. 

<P> It is only legal to call the <CODE>init</CODE> method for a newly-allocated
   <CODE>ZSplit</CODE> (as in the definition of the procedure <CODE>New</CODE> below) or from
   the <CODE>init</CODE> method of a subclass.  This restriction applies to all
   the <CODE>init</CODE> methods in Trestle, although it will not be repeated for
   each one. \index{init method, rules for calling}
<P>
  The <CODE>ZSplit</CODE> will be given the initial background child <CODE>bg</CODE> if
   <CODE>bg#NIL</CODE>; it will be given no children if <CODE>bg=NIL</CODE>.  If <CODE>bg</CODE> is
   non-<CODE>NIL</CODE> it will be mapped initially.  If <CODE>saveBits</CODE> is <CODE>TRUE</CODE>,
   the split will try to save the children's old bits when reformatting;
   if the children don't use them anyway, it is faster to let <CODE>saveBits</CODE>
   default to <CODE>FALSE</CODE>.  The value of <CODE>parlim</CODE> is the minimum area of
   a child for which a separate thread will be forked to reshape or
   repaint it; if it is <CODE>-1</CODE>, it is set to an appropriate default (see
   the <CODE>VBTTuning</CODE> interface).  

<P>
<P><PRE>PROCEDURE <A HREF="ZSplit.m3#New">New</A>(
    bg: VBT.T := NIL;
    saveBits := FALSE;
    parlim: INTEGER := -1)
    : T; &lt;* LL &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Inserting children} 

<P> The default <CODE>Split.Insert</CODE> call is rarely useful for a <CODE>ZSplit</CODE>: it
   inserts the new child at the parent's northwest corner, unmapped.
   <CODE>Split.AddChild</CODE> is even less useful, since it adds children as the
   background, which is almost certainly not what you want.  The 
   following procedures are more useful for inserting children into a 
   <CODE>ZSplit</CODE>: 

<P><PRE>PROCEDURE <A HREF="ZSplit.m3#InsertAfter">InsertAfter</A>(
    v: T;
    pred, ch: VBT.T;
    READONLY dom: Rect.T;
    alsoMap: BOOLEAN := TRUE) RAISES {Split.NotAChild};
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Insert <CODE>ch</CODE> as a new child of <CODE>v</CODE> with domain <CODE>dom</CODE>, and mark <CODE>v</CODE>
   for redisplay.  </EM></BLOCKQUOTE><PRE>
</PRE> The new child is inserted immediately after (that is, below) <CODE>pred</CODE>;
   if <CODE>pred=NIL</CODE> the new child is inserted first (that is, on top).
   If the height or width of <CODE>dom</CODE> does not satisfy <CODE>ch</CODE>'s size
   contraints, then the height and width of the child are projected
   into range; its offset is preserved.  This is a checked runtime error
   if <CODE>ch</CODE> is not detached.  If <CODE>alsoMap</CODE> is <CODE>TRUE</CODE>, <CODE>ch</CODE> is mapped,
   otherwise it is unmapped. 
   <P>
   It is occasionally useful to insert a new child below all existing 
   children except the background, in which case the following 
   procedure is handy:  

<P><PRE>TYPE Altitude = {Top, Bot};

PROCEDURE <A HREF="ZSplit.m3#Insert">Insert</A>(
    v: T;
    ch: VBT.T;
    READONLY dom: Rect.T;
    alt := Altitude.Top;
    alsoMap: BOOLEAN := TRUE); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Insert <CODE>ch</CODE> at the top if <CODE>alt = Altitude.Top</CODE>; insert <CODE>ch</CODE> just
   above the background if <CODE>alt = Altitude.Bot</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> That is, <CODE>Insert</CODE> is equivalent to
<P>
    <PRE>
      IF alt = Altitude.Top THEN
            pred := NIL
          ELSE
            pred := Split.Pred(v, Split.Pred(v, NIL))
          END;
          InsertAfter(v, pred, ch, dom, alsoMap)
</PRE>
<P>
   Finally, instead of providing the new child's domain it can be useful
   to provide only the northwest corner and let the child's domain be
   determined by its shape constraints: 

<P>
<P><PRE>PROCEDURE <A HREF="ZSplit.m3#InsertAt">InsertAt</A>(
    v: T;
    ch: VBT.T;
    nw: Point.T;
    alt := Altitude.Top;
    alsoMap: BOOLEAN := TRUE); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM>  Insert <CODE>ch</CODE> with its preferred shape and its northwest corner 
    at <CODE>nw</CODE>.  The <CODE>alt</CODE> and <CODE>alsoMap</CODE> parameters are interpreted as 
    in <CODE>Insert</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Moving, lifting, and lowering children} 

<P><PRE>PROCEDURE <A HREF="ZSplit.m3#Move">Move</A>(ch: VBT.T; READONLY dom: Rect.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the domain of <CODE>ch</CODE> to be <CODE>dom</CODE> and mark <CODE>ch</CODE>'s parent for
   redisplay.  </EM></BLOCKQUOTE><PRE>
</PRE> If the height or width of <CODE>dom</CODE> do not satisfy <CODE>ch</CODE>'s size
   constraints, then they are projected into range, preserving the
   northwest corner of <CODE>dom</CODE>.  The stacking order of <CODE>ch</CODE> is not
   changed.  <CODE>Move</CODE> is a checked runtime error if <CODE>ch</CODE>'s parent is not
   a <CODE>ZSplit</CODE>.  Note that this has nothing to do with <CODE>Split.Move</CODE>, 
   unlike the next procedure. 

<P>
<P><PRE>PROCEDURE <A HREF="ZSplit.m3#Lift">Lift</A>(ch: VBT.T; alt := Altitude.Top);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Lift <CODE>ch</CODE> to the top or lower it to be just above the background,
   depending on <CODE>alt</CODE>.  <CODE>Lift</CODE> is equivalent to:
<P>
<PRE>
      v := VBT.Parent(ch);
      IF alt = Altitude.Top THEN
        pred := NIL
      ELSE
        pred := Split.Pred(v, Split.Pred(v, NIL))
      END;
      Split.Move(v, pred, ch)
</PRE>
</EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Mapping and unmapping children} 

<P> You can {\it unmap} a child of a <CODE>ZSplit</CODE>, which reshapes the child
   to be empty after recording the child's shape and offset.  When you
   later {\it map} the child, the recorded shape and offset are
   restored.  An unmapped child is rescreened when the parent is
   rescreened, and its recorded shape and offset are updated when the
   parent is reshaped, just like the domains of the mapped children.


<P><PRE>PROCEDURE <A HREF="ZSplit.m3#Unmap">Unmap</A>(ch: VBT.T); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> If <CODE>ch</CODE> is mapped, unmap it and mark its parent for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZSplit.m3#Map">Map</A>(ch: VBT.T); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> If <CODE>ch</CODE> is unmapped, map it and mark its parent for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZSplit.m3#IsMapped">IsMapped</A>(ch: VBT.T): BOOLEAN;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> if ch is <CODE>mapped</CODE> and <CODE>FALSE</CODE> if <CODE>ch</CODE> is unmapped. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Map</CODE>, <CODE>Unmap</CODE>, and <CODE>IsMapped</CODE> are checked runtime errors if <CODE>ch</CODE>'s
   parent is not a <CODE>ZSplit</CODE>.  

<P>
<P> \subsubsection{Getting domains} 

<P>
<P><PRE>PROCEDURE <A HREF="ZSplit.m3#GetDomain">GetDomain</A>(ch: VBT.T): Rect.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the effective domain of <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The effective domain is the same as the normal domain, except (1)
   if the parent has been marked for redisplay, <CODE>GetDomain</CODE> returns
   the domain that <CODE>ch</CODE> will receive when the redisplay happens, or
   (2) if the domain of the parent is <CODE>Rect.Empty</CODE>, <CODE>GetDomain</CODE> returns
   the domain <CODE>ch</CODE> would receive if the parent were reshaped to its
   last non-empty domain, or (3) if the child is unmapped, <CODE>GetDomain</CODE> 
   returns the domain the child would have if it were mapped.
   <P>
   <CODE>GetDomain</CODE> is a checked runtime error if the parent of <CODE>ch</CODE> is not
   a <CODE>ZSplit</CODE>.  

<P>
<P><PRE>PROCEDURE <A HREF="ZSplit.m3#GetParentDomain">GetParentDomain</A>(v: T): Rect.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the last non-empty value of <CODE>v.domain</CODE>, or <CODE>Rect.Empty</CODE> if
   <CODE>v.domain</CODE> has always been empty.  </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Moving children when the parent is reshaped} 

<P> You can supply procedures to control what happens to the children
   when a <CODE>ZSplit</CODE> is reshaped.  If you don't supply a procedure, the
   default behavior is as follows: the initial background child is
   always reshaped to have the same domain as the parent.  The other
   children are reshaped so as to preserve their shape and their offsets
   (even if this makes them extend outside the parent domain).  The rule
   is different if the parent is reshaped to <CODE>Rect.Empty</CODE>: in this case
   the <CODE>ZSplit</CODE> records its children's shapes and offsets and reshapes
   them all to <CODE>Rect.Empty</CODE>.  When the <CODE>ZSplit</CODE> is later reshaped to
   a non-empty domain, it reshapes the initial background child to have
   the same domain as the parent, and restores the saved dimensions
   and offsets of the other children.
<P>
   In the unusual case that the initial background child is deleted,
   subsequent background children do not automatically inherit the 
   special reshaping behavior of the initial background child.  
   <P>
   To override the default behavior, use <CODE>SetReshapeControl</CODE>:  
   
<P>
<P><PRE>PROCEDURE <A HREF="ZSplit.m3#SetReshapeControl">SetReshapeControl</A>(
    ch: VBT.T;
    rc: ReshapeControl); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set the reshape control object for the child <CODE>ch</CODE> to be <CODE>rc</CODE>.  </EM></BLOCKQUOTE><PRE>

TYPE ReshapeControl = OBJECT METHODS
  apply(ch:VBT.T; READONLY old, new, prev: Rect.T)
  : Rect.T &lt;* LL.sup = VBT.mu.ch *&gt;
END;
</PRE> <CODE>SetReshapeControl</CODE> arranges that whenever the <CODE>ZSplit</CODE> parent <CODE>v</CODE>
   of <CODE>ch</CODE> is reshaped from domain <CODE>old</CODE> to domain <CODE>new</CODE>, then if the
   previous domain of <CODE>ch</CODE> is <CODE>prev</CODE>, the new domain of <CODE>ch</CODE> will become
   <CODE>rc.apply(ch, old, new, prev)</CODE> (if this rectangle doesn't satisfy
   <CODE>ch</CODE>'s size constraints, its height and width will be projected into
   range, preserving its offset).
   <P>
   These methods of the <CODE>ReshapeControl</CODE> objects may be called concurrently
   for different children.  (This is why the apply method has only a 
   share of <CODE>VBT.mu</CODE>.) The stacking order is not changed by
   reshaping.
<P>
   When a <CODE>ZSplit</CODE> child is replaced by <CODE>Split.Replace</CODE>, the new child
   inherits the old child's reshape control object.  
<P>
   <CODE>SetReshapeControl</CODE> is a checked runtime error if the parent of <CODE>ch</CODE>
   is not a <CODE>ZSplit</CODE>.
<P>
   If the <CODE>ZSplit</CODE> is reshaped to <CODE>Rect.Empty</CODE>, it will reshape its
   children to <CODE>Rect.Empty</CODE> without calling their reshape control
   methods.  Similarly, if the parent is subsequently reshaped to its
   original rectangle, it will restore the children's previous domains
   without calling the methods.  
<P>
   By default, the background is chained absolutely to the parent
   domain, using <CODE>Background</CODE>: 

<P><PRE>VAR (*CONST*)
  Background: ReshapeControl;

   (* One useful reshape control method provided by this interface is
   &quot;ChainReshape&quot;, in which some set of the child's west, east, north,
   and south edges are ``chained'' to the corresponding edges of the
   parent.  Chaining an edge means that the distance between the child
   edge and the corresponding parent edge will be preserved.  For
   example, if both the west and east edges are chained, then the child's
   horizontal extent will be inset into the parent's horizontal extent
   by fixed amounts on both sides.  For another example, suppose that
   the the east edge is chained and the west edge is not.  In this case
   the distance between the east edges of the child and parent will
   be preserved, but the west edge of the child will move so as to
   preserve the width of the child.  The north and south edges control
   the vertical extent in a similar manner.  *)

TYPE
  Ch = {W, E, N, S};
  ChainSet = SET OF Ch;
  ChainReshapeControl = ReshapeControl OBJECT
    chains: ChainSet
  OVERRIDES
    apply := ChainedReshape
  END;

VAR (*CONST*)
  NoChains, WChains, EChains, WEChains, NChains,
  WNChains, ENChains, WENChains, SChains,
  WSChains, ESChains, WESChains, NSChains,
  WNSChains, ENSChains, WENSChains: ChainReshapeControl;
</PRE> The ``variables'' above are constants for the following reshape 
   control objects: 
<P>
    <PRE>
      NEW(ChainReshapeControl, chains := ChainSet{}), 
          NEW(ChainReshapeControl, chains := ChainSet{Ch.W}),
          
          ...
          
          NEW(ChainReshapeControl, 
              chains := ChainSet{Ch.W,Ch.E,Ch.N,Ch.S})
</PRE>
 

<P>
<P><PRE>PROCEDURE <A HREF="ZSplit.m3#ChainedReshape">ChainedReshape</A>(
  self: ChainReshapeControl;
  ch: VBT.T;
  READONLY oldParentDomain, newParentDomain,
    oldChildDomain: Rect.T): Rect.T;
</PRE><BLOCKQUOTE><EM> Return the rectangle that results from chaining each edge in
   <CODE>self.chains</CODE> to the corresponding edge of the parent domain, and
   leaving the other edges unconstrained.  </EM></BLOCKQUOTE><PRE>
</PRE> If both edges in a dimension are chained, the offset and extent of
   the child will both vary to satisfy the chain constraints; if one edge
   is chained, the offset will vary and the extent will be fixed; if
   both edges are unchained, the offset and the extent will both be
   fixed.  

<P> The default behavior for the initial background child
   is <CODE>Background</CODE>, and the default behavior for all other children
   is <CODE>WNChains</CODE>. 
<P>
   One final reshape control method is sometimes useful: 

<P>
<P><PRE>PROCEDURE <A HREF="ZSplit.m3#ScaledReshape">ScaledReshape</A>(
  self: ReshapeControl;
  ch: VBT.T;
  READONLY oldParentDomain, newParentDomain,
    oldChildDomain: Rect.T) : Rect.T;
</PRE><BLOCKQUOTE><EM> Return the integer approximation to the rectangle that results from
   scaling the old child domain to occupy the same relative position
   of the changing parent domain.  </EM></BLOCKQUOTE><PRE>

VAR (*CONST*) Scaled: ReshapeControl;
</PRE> This ``variable'' is really a constant for the following reshape 
   control object:
<P>
<PRE>
      NEW(ReshapeControl, apply := ScaledReshape)
</PRE>


<P><PRE>END ZSplit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
