<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/trestle/DpyFilter.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/trestle/DpyFilter.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> Every installed VBT has a DpyFilter above it to catch messages telling the
   window to move to a new display, or to add new cloned copies. 

<P><PRE>INTERFACE <interface><A HREF="DpyFilter.m3">DpyFilter</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../split/JoinParent.i3">JoinParent</A>, <A HREF="../split/JoinedVBT.i3">JoinedVBT</A>;

TYPE
  <A HREF="DpyFilter.m3#T">T</A> &lt;: Public;
  Public = JoinParent.T OBJECT
           METHODS
             init (ch: JoinedVBT.T; enabled := TRUE): T
           END;

VAR ChangeDisplay, AddDisplay: VBT.MiscCodeType;

TYPE
  Message = REF RECORD
                  oldAuth, newAuth           : TEXT;
                  x, y, width, height, screen: INTEGER;
                  iconic, status             : BOOLEAN;
                  newDisplay                 : REF ARRAY OF TEXT
                END;
</PRE> In a MiscCode of type ChangeDisplay or AddDisplay, the first detail
   should be a MiscDetail.FromRef of a Message.  The status field of the
   message should be set to FALSE before returning if the message is
   unacceptable. 

<P><PRE>PROCEDURE <A HREF="DpyFilter.m3#New">New</A> (ch: JoinedVBT.T; enabled := TRUE): T;

PROCEDURE <A HREF="DpyFilter.m3#SetEnabled">SetEnabled</A> (ch: VBT.T; enabled := TRUE);
</PRE><BLOCKQUOTE><EM> Find the lowest T ancestor of ch, and set whether or not it
   automatically handles ChangeDisplay messages.  When disabled,
   ChangeDisplay and AddDisplay misc codes are simply relayed to the
   child. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DpyFilter.m3#GetEnabled">GetEnabled</A> (ch: VBT.T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return the enabled state of the lowest T ancestor of ch, or TRUE if
   there is no such ancestor. </EM></BLOCKQUOTE><PRE>

END DpyFilter.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
