<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/trestle/DpyFilter.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/trestle/DpyFilter.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> Every installed VBT has a DpyFilter above it to catch messages telling
   the window to move to a new display. 

<P><PRE>MODULE <module><implements><A HREF="DpyFilter.i3">DpyFilter</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="InstalledVBT.i3">InstalledVBT</A>, <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>,
       <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../vbt/MiscDetail.i3">MiscDetail</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../split/Split.i3">Split</A>, <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../rw/src/Common/FileRd.i3">FileRd</A>,
       <A HREF="../../../params/src/Env.i3">Env</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../split/JoinParent.i3">JoinParent</A>, <A HREF="../split/JoinedVBT.i3">JoinedVBT</A>, <A HREF="TrestleImpl.i3">TrestleImpl</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        enabled         := TRUE;
        pass   : TEXT := NIL;
      OVERRIDES
        misc := Misc;
        init := Init
      END;

VAR
  mu     := NEW(Thread.Mutex);
  inited := FALSE;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; ch: JoinedVBT.T; enabled: BOOLEAN): T =
  VAR fn: TEXT;
  CONST DefaultFile = &quot;~/.pa_new_display&quot;;
  BEGIN
    LOCK mu DO
      IF NOT inited THEN
        ChangeDisplay := VBT.GetMiscCodeType(&quot;ChangeDisplay&quot;);
        AddDisplay := VBT.GetMiscCodeType(&quot;AddDisplay&quot;);
        inited := TRUE;
        fn := Env.Get(&quot;PA_NEW_DISPLAY&quot;);
	IF fn = NIL THEN fn := DefaultFile END;
        TRY
          (* !!! fn := Filename.ExpandTilde(fn); *)
          VAR rd := FileRd.Open(fn);
          BEGIN
            DefaultPassword := Rd.GetLine(rd);
            Rd.Close(rd)
          END
        EXCEPT
          (* Filename.Error, *) OSError.E, Rd.Failure, Rd.EndOfFile, Thread.Alerted =&gt;
        END
      END
    END;
    v.pass := DefaultPassword;
    v.enabled := enabled;
    EVAL JoinParent.T.init(v, ch);
    RETURN v
  END Init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (ch: JoinedVBT.T; enabled := TRUE): T =
  VAR res := NEW(T);
  BEGIN
    EVAL res.init(ch, enabled);
    RETURN res
  END New;

VAR trsls := NEW(TextRefTbl.Default).init();

PROCEDURE <A NAME="Connect"><procedure>Connect</procedure></A> (servers: REF ARRAY OF TEXT): Trestle.T =
  VAR
    res: Trestle.T;
    ra : REFANY;
  BEGIN
    IF servers = NIL THEN RETURN NIL END;
    FOR i := FIRST(servers^) TO LAST(servers^) DO
      IF trsls.get(servers[i], ra) THEN RETURN ra END
    END;
    FOR i := FIRST(servers^) TO LAST(servers^) DO
      TRY
        res := Trestle.Connect(servers[i]);
        IF res # NIL THEN EVAL trsls.put(servers[i], res); RETURN res END
      EXCEPT
        TrestleComm.Failure =&gt;  (* skip *)
      END
    END;
    RETURN NIL
  END Connect;

VAR
  DefaultPassword: TEXT := NIL;

PROCEDURE <A NAME="Misc"><procedure>Misc</procedure></A> (v: T; READONLY cd: VBT.MiscRec) =
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    IF v.enabled AND (cd.type = ChangeDisplay OR cd.type = AddDisplay) THEN
      VAR
        m   : Message := MiscDetail.ToRef(cd.detail[0]);
        d             := MiscDetail.ToRef(cd.detail[1]);
        trsl          := Connect(m.newDisplay);
      BEGIN
        IF trsl # NIL AND v.pass = NIL
             OR m.oldAuth # NIL AND Text.Equal(m.oldAuth, v.pass) THEN
          VAR
            decor := TrestleImpl.GetDecor(v);
            w := InstalledVBT.NewParent(v);
          BEGIN
            IF w = NIL THEN m.status := FALSE; RETURN END;
            w.pass := m.newAuth;
            IF w.pass # NIL AND Text.Equal(w.pass, &quot;&quot;) THEN
              w.pass := NIL
            END;
            IF d # NIL THEN VBT.PutProp(w, d) END;
            TRY
              trsl.attach(w);
              IF decor # NIL THEN
                TrestleImpl.InnerDecorate(trsl, w, decor)
              END;
              IF m.iconic THEN
                trsl.iconize(w)
              ELSE
                trsl.overlap(w, m.screen, Point.T{m.x, m.y})
              END;
              m.status := TRUE;
              IF cd.type = ChangeDisplay AND v.parent # NIL THEN
                Split.Delete(v.parent, v)
              END
            EXCEPT
              TrestleComm.Failure =&gt; m.status := FALSE; JoinParent.Rem(w)
            END
          END
        ELSE
          m.status := FALSE
        END
      END
    ELSE
      Public.misc(v, cd)
    END
  END Misc;

PROCEDURE <A NAME="Parent"><procedure>Parent</procedure></A> (v: VBT.T): T =
  BEGIN
    LOOP TYPECASE v OF T (p) =&gt; RETURN p ELSE v := v.parent END END
  END Parent;

PROCEDURE <A NAME="SetEnabled"><procedure>SetEnabled</procedure></A> (ch: VBT.T; enabled := TRUE) =
  VAR v := Parent(ch);
  BEGIN
    IF v # NIL THEN v.enabled := enabled END
  END SetEnabled;

PROCEDURE <A NAME="GetEnabled"><procedure>GetEnabled</procedure></A> (ch: VBT.T): BOOLEAN =
  VAR v := Parent(ch);
  BEGIN
    IF v # NIL THEN RETURN v.enabled ELSE RETURN TRUE END
  END GetEnabled;

BEGIN
END DpyFilter.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
