<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/trestle/InstalledVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/trestle/InstalledVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="InstalledVBT.i3">InstalledVBT</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../split/Filter.i3">Filter</A>, <A HREF="../split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="DpyFilter.i3">DpyFilter</A>, <A HREF="../split/StableVBT.i3">StableVBT</A>, <A HREF="../split/JoinedVBT.i3">JoinedVBT</A>,
  <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>, <A HREF="../split/JoinParent.i3">JoinParent</A>, <A HREF="../split/FilterClass.i3">FilterClass</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="TrestleGoo.i3">TrestleGoo</A>;

TYPE
  GrandChild = HighlightVBT.T OBJECT
    proc: DeleteProc
  OVERRIDES
    rescreen := Rescreen;
    misc := GCMisc;
  END;

REVEAL <A NAME="Join">Join</A> = JoinedVBT.T BRANDED OBJECT trueChild: VBT.T END;

REVEAL <A NAME="T">T</A> = DpyFilter.T BRANDED OBJECT trueChild: VBT.T END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (ch: VBT.T; p: DeleteProc): T =
  VAR j := NEW(Join);
  BEGIN
    InitChild(j, ch, p);
    RETURN AllocT(j)
  END New;

PROCEDURE <A NAME="InitChild"><procedure>InitChild</procedure></A> (j: Join; ch: VBT.T; p: DeleteProc)=
  VAR
    grandChild := NEW(GrandChild, proc := p);
    child      := StableVBT.New(grandChild);
  BEGIN
    EVAL grandChild.init(ch);
    j.trueChild := ch;
    EVAL j.init(child)
  END InitChild;

PROCEDURE <A NAME="InitParent"><procedure>InitParent</procedure></A>(res:T; ch: Join) =
  BEGIN
    res.trueChild := ch.trueChild;
    EVAL res.init(ch);
    LOCK res DO
      res.props := res.props + VBTRep.Props{VBTRep.Prop.Combiner}
    END;
    TrestleGoo.Alias(res, ch.trueChild)
  END InitParent;

PROCEDURE <A NAME="AllocT"><procedure>AllocT</procedure></A> (ch: Join): T =
  VAR res := NEW(T);
  BEGIN
    InitParent(res, ch);
    RETURN res
  END AllocT;

PROCEDURE <A NAME="NewParent"><procedure>NewParent</procedure></A> (ch: VBT.T): T =
  BEGIN
    LOOP
      TYPECASE ch OF
        T (iv) =&gt; RETURN AllocT(JoinParent.Child(iv))
      ELSE
        IF ch.parent = NIL THEN RETURN NIL ELSE ch := ch.parent END
      END
    END
  END NewParent;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A>(v: GrandChild; READONLY cd: VBT.RescreenRec) =
  BEGIN
    Palette.Init(cd.st);
    HighlightVBT.T.rescreen(v, cd)
  END Rescreen;

PROCEDURE <A NAME="Child"><procedure>Child</procedure></A> (v: VBT.T): VBT.T =
  BEGIN
    LOOP
      TYPECASE v OF
        T (iv) =&gt; RETURN iv.trueChild
      ELSE
        IF v.parent = NIL THEN RETURN v ELSE v := v.parent END
      END
    END
  END Child;

PROCEDURE <A NAME="GCMisc"><procedure>GCMisc</procedure></A>(v: GrandChild; READONLY cd: VBT.MiscRec) =
  VAR ch := v.ch; button: VBT.Button := LAST(VBT.Button);
  CONST gone = VBT.CursorPosition{Point.Origin, Trestle.NoScreen, TRUE, TRUE};
  BEGIN
    IF ch = NIL THEN RETURN END;
    IF cd.type = VBT.Deleted OR cd.type = VBT.Disconnected THEN
      VBTClass.Position(v, VBT.PositionRec{gone, 0, VBT.Modifiers{}});
      VBTClass.Mouse(v,
        VBT.MouseRec{button, 0, gone, VBT.Modifiers{},
          VBT.ClickType.LastUp, 0});
      IF v.proc # NIL THEN v.proc(ch) END;
      EVAL Filter.Replace(v, NIL)
    END;
    VBTClass.Misc(ch, cd);
  END GCMisc;

BEGIN END InstalledVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
