<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/trestle/TrestleConf.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/trestle/TrestleConf.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

INTERFACE <interface><A HREF="#x1">TrestleConf</A></interface>;
</PRE> The export implementation of TrestleConf is a noop.  The SRC
   implementation imports the Argo conference control machinery, if
   available.  You must have set your ARGOSERVER environment variable for
   this to do anything.  if you set ARGOCONFERENCE the application will
   join the named conference, if it exists; otherwise, the application will
   join whatever conference is currently active for USER 

<P><PRE>TYPE
  <A HREF="#x2">User</A> &lt;: UserPublic;

  UserPublic = OBJECT
    name: TEXT;
    displayName: TEXT
  METHODS &lt;* LL = VBT.mu *&gt;
    register()
  END;
</PRE> User instantiates the register method; all Users must be registered 
   before use. 

<P><PRE>TYPE &lt;* LL = VBT.mu *&gt;
  UserProc = PROCEDURE (user, displayName: TEXT): User;
</PRE> return NIL if the user's display can't be opened; the created User's
   register method will be called before this procedure returns 

<P><PRE>&lt;* LL arbitrary; call must return before any other calls on
   this interface are made. *&gt;
PROCEDURE <A HREF="#x3">Init</A>(createUser: UserProc);

TYPE
  <A HREF="#x4">App</A> &lt;: AppPublic;

  AppPublic = OBJECT METHODS
    &lt;* LL = VBT.mu *&gt;
    (* client-supplied methods *)
    add(user: User);
    delete(user: User);
    suspend(user: User);
    activate(user: User);
    (* system supplied methods *)
    init(user: User);
    destroy()
  END;

  (* App implements the init method; clients should create Apps, and init
     them.  The application is added to the current conference for the user.
     The destroy method is invoked when the application wants to destroy
     itself.
     The remaining calls are to be implemented by the client of this interface;
     conference control will call add and delete to attach or delete the
     application from the given user's session, and activate and suspend to say
     whether the app should be visible or not.  The application should
     be destroyed when it has no active users; invoking destroy
     causes all users to be deleted from the app.  The initial state of
     an app added to a user is suspended. *)

END TrestleConf.
</PRE>
</inInterface>
<HR>
<A NAME="x1">TrestleConf's implementation  is in:
</A><UL>
<LI><A HREF="../confctl-export/TrestleConf.m3#0TOP0">ui/src/confctl-export/TrestleConf.m3</A>
<LI><A HREF="../confctl/TrestleConf.m3#0TOP0">ui/src/confctl/TrestleConf.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">opaque type TrestleConf.User is in:
</A><UL>
<LI><A HREF="../confctl-export/TrestleConf.m3#User">ui/src/confctl-export/TrestleConf.m3</A>
<LI><A HREF="../confctl/TrestleConf.m3#User">ui/src/confctl/TrestleConf.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure TrestleConf.Init is in:
</A><UL>
<LI><A HREF="../confctl-export/TrestleConf.m3#Init">ui/src/confctl-export/TrestleConf.m3</A>
<LI><A HREF="../confctl/TrestleConf.m3#Init">ui/src/confctl/TrestleConf.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">opaque type TrestleConf.App is in:
</A><UL>
<LI><A HREF="../confctl-export/TrestleConf.m3#App">ui/src/confctl-export/TrestleConf.m3</A>
<LI><A HREF="../confctl/TrestleConf.m3#App">ui/src/confctl/TrestleConf.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
