<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/trestle/TrestleGoo.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/trestle/TrestleGoo.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A mechanism for attaching arbitrary sets of properties to an installed
   window that can be set and retrieved by a TrestleClass.  The interface
   is like VBT's property set, but supports enumeration. 

<P><PRE>MODULE <module><implements><A HREF="TrestleGoo.i3">TrestleGoo</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>;

VAR mu := NEW(MUTEX);

TYPE AliasRef = BRANDED REF RECORD alias: VBT.T END;

PROCEDURE <A NAME="Alias"><procedure>Alias</procedure></A>(v, ch: VBT.T) =
  VAR al := NEW(AliasRef, alias := ch); BEGIN
    VBT.PutProp(v, al)
  END Alias;

PROCEDURE <A NAME="TrueChild"><procedure>TrueChild</procedure></A> (v: VBT.T): VBT.T =
  BEGIN
    LOOP
      VAR al: AliasRef := VBT.GetProp(v, TYPECODE(AliasRef));
      BEGIN
        IF al = NIL THEN RETURN v END;
        v := al.alias
      END
    END
  END TrueChild;

PROCEDURE <A NAME="PutProp"><procedure>PutProp</procedure></A> (vv: VBT.T; ref: REFANY) = &lt;* LL.sup &lt; v *&gt;
  BEGIN
    LOCK mu DO
      VAR
        v        := TrueChild(vv);
        tc       := TYPECODE(ref);
        p : Enum := VBT.GetProp(v, TYPECODE(Enum));
        e        := NEW(Enum, prop := ref, next := p);
      BEGIN
        VBT.PutProp(v, e);
        WHILE e.next # NIL DO
          IF TYPECODE(e.next.prop) = tc THEN
            e.next := e.next.next
          ELSE
            e := e.next
          END
        END
      END
    END
  END PutProp;

PROCEDURE <A NAME="GetProp"><procedure>GetProp</procedure></A> (vv: VBT.T; tc: INTEGER): REFANY =
  BEGIN
    LOCK mu DO
      VAR
        v       := TrueChild(vv);
        e: Enum := VBT.GetProp(v, TYPECODE(Enum));
      BEGIN
        WHILE e # NIL DO
          IF TYPECODE(e.prop) = tc THEN RETURN e.prop ELSE e := e.next END
        END;
        RETURN NIL
      END
    END
  END GetProp;

PROCEDURE <A NAME="RemProp"><procedure>RemProp</procedure></A> (vv: VBT.T; tc: INTEGER) = &lt;* LL.sup &lt; v *&gt;
  BEGIN
    LOCK mu DO
      VAR
        v       := TrueChild(vv);
        e: Enum := VBT.GetProp(v, TYPECODE(Enum));
      BEGIN
        IF e = NIL THEN RETURN END;
        IF TYPECODE(e.prop) = tc THEN
          IF e.next = NIL THEN
            VBT.RemProp(v, TYPECODE(Enum))
          ELSE
            VBT.PutProp(v, e.next)
          END
        ELSE
          LOOP
            IF e.next = NIL THEN EXIT END;
            IF TYPECODE(e.next.prop) = tc THEN
              e.next := e.next.next;
              EXIT
            END;
            e := e.next
          END
        END
      END
    END
  END RemProp;

REVEAL <A NAME="Enum">Enum</A> = BRANDED REF RECORD next: Enum; prop: REFANY END;

PROCEDURE <A NAME="Next"><procedure>Next</procedure></A> (v: VBT.T; VAR enum: Enum): REFANY =
  BEGIN
    LOCK mu DO
      IF enum = NIL THEN
        enum := VBT.GetProp(TrueChild(v), TYPECODE(Enum))
      ELSE
        enum := enum.next
      END;
      IF enum = NIL THEN RETURN NIL ELSE RETURN enum.prop END
    END
  END Next;

BEGIN
END TrestleGoo.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
