<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/BatchRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/BatchRep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> BatchRep.def, Fri May 11 9:34:18 PDT 1990 by steveg 
<PRE>&lt;*PRAGMA LL*&gt;

INTERFACE <interface><A HREF="BatchUtil.m3">BatchRep</A></interface>;
</PRE> Unsafe representation of batches of Trestle painting commands.
<P>
   Index: VBT 

<P><PRE>IMPORT <A HREF="Batch.i3">Batch</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="BatchUtil.i3">BatchUtil</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>;

REVEAL Batch.<A NAME="T">T</A> = UNTRACED BRANDED REF Rec;

TYPE
  T = Batch.T;
  Array = UNTRACED REF ARRAY OF Word.T;

  Rec =
    RECORD
      b   : Array;               (* never nil *)
      next: ADDRESS;
      (* Address of next free word in b; never nil.  The batch is empty iff
         next = ADDR(b^[0]).  The total length of the painting commands in
         the batch, in words, is (next - ADR(b^[0])) DIV
         BYTESIZE(Word.T). *)
      clip: Rect.T;
      (* All of the paint commands in b will have their clipping rectangles
         intersected with clip before painting.  (But see firstSingle
         below.) *)
      clipped: BatchUtil.ClipState;
      (* (clipped # Unclipped) =&gt; The clip of every paint command in b is a
         subset of clip; therefore the intersection refered to in the last
         comment is unnecessary.  (clipped = Tight) =&gt; The clipping
         rectangle cannot be made smaller without changing the meaning of
         the batch. *)
      scrollSource: Rect.T;
      (* This rectangle equals the join of the source of the scrolling
         commands in the batch. *)
      link: T;
      (* used for the free list of batches and by PipelineSplit. *)
      excessBegins: INTEGER;
      (* used while the batch is initially being created by individual
         paint commands; represents the excess of BeginGroup's over
         EndGroup's in the batch. *)
      firstSingle: ADDRESS;
      (* used while the batch is initially being created by individual
         paint commands; ADDR(b^[0]) &lt;= firstSingle &lt;= next.  The first
         interval contains painting operations to which clip and clipped
         apply.  The second interval contains painting operations generated
         by individual painting commands, which need to be clipped by the
         domain of the VBT containing this batch. *)
      containsPicture: BOOLEAN;
      (* picture commands are associated with an PictureRep.Completion
         object which keeps a reference count so callers can find out when
         the picture data may be changed.  Batch.Free decrements the count
         of any pictures in the batch.  This flag is TRUE when the Batch
         contains any pictures. *)
    END;

PROCEDURE <A HREF="BatchUtil.m3#ClipSub">ClipSub</A> (READONLY clip   : Rect.T;
                   VAR      batch  : ARRAY OF Word.T;
                            st, len: INTEGER          );
</PRE><BLOCKQUOTE><EM> Like BatchUtil.Clip, but uses clip instead of the batch's clip and
   doesn't affect the clip or clipstate of the batch and affects only the
   painting operations in batch starting with batch[st] and proceeding for
   len words. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="BatchUtil.m3#ClipSubAndTighten">ClipSubAndTighten</A> (READONLY clip        : Rect.T;
                             VAR      batch       : ARRAY OF Word.T;
                                      st, len     : INTEGER;
                             VAR      scrollSource: Rect.T           ):
  Rect.T;
</PRE><BLOCKQUOTE><EM> Like ClipSub, but also returns the join of the clipping rectangles and
   the join of the scroll sources that it computes. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="BatchUtil.m3#TranslateSub">TranslateSub</A> (VAR      btch   : ARRAY OF Word.T;
                                 st, len: INTEGER;
                        READONLY delta  : Point.T          );
</PRE><BLOCKQUOTE><EM> Like <CODE>BatchUtil.Translate</CODE>, but doesn't affect the clip of the batch and
   affects only the painting operations in batch starting with batch[st]
   and proceeding for len words. </EM></BLOCKQUOTE><PRE>

END BatchRep.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
