<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/BatchUtil.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/BatchUtil.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> BatchUtil.def, by Greg Nelson and Mark Manasse. 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> This interface provides operations to clip and translate a batch of
   painting commands.  It is useful to those who are implementing window
   classes with customized painting behavior.
<P>
   Don't apply these procedures to a batch whose contents are concurrently
   being read or written. 

<P><PRE>INTERFACE <interface><A HREF="BatchUtil.m3">BatchUtil</A></interface>;

IMPORT <A HREF="Batch.i3">Batch</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="PaintPrivate.i3">PaintPrivate</A>;

PROCEDURE <A HREF="BatchUtil.m3#GetLength">GetLength</A> (ba: Batch.T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return the number of <CODE>Word.Ts</CODE> in use in <CODE>ba</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="BatchUtil.m3#Copy">Copy</A> (ba: Batch.T): Batch.T;
</PRE><BLOCKQUOTE><EM> Allocate and return a new batch initialized with a copy of <CODE>ba</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> Every entry in a batch has a clipping rectangle; there is also a
   clipping rectangle for the batch as a whole.  The effective clipping
   rectangle for a painting operation is the intersection of its clipping
   rectangle with its batch's clipping rectangle. 

<P><PRE>PROCEDURE <A HREF="BatchUtil.m3#GetClip">GetClip</A> (ba: Batch.T): Rect.T;
</PRE><BLOCKQUOTE><EM> Return <CODE>ba</CODE>'s clipping rectangle. </EM></BLOCKQUOTE><PRE>

TYPE ClipState = {Unclipped, Clipped, Tight};

PROCEDURE <A HREF="BatchUtil.m3#GetClipState">GetClipState</A> (ba: Batch.T): ClipState;
</PRE><BLOCKQUOTE><EM> Return <CODE>ba</CODE>'s clipping state. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>GetClipState(ba)</CODE> is <CODE>Clipped</CODE> then the clipping rectangle of every
   painting operation in <CODE>ba</CODE> is a subset of <CODE>GetClip(ba)</CODE>.  If
   <CODE>GetClipState(ba)</CODE> is <CODE>Tight</CODE> then <CODE>GetClip(ba)</CODE> is equal to the join of
   the clipping rectangles of the painting operations in <CODE>ba</CODE>.  If
   <CODE>GetClipState(ba)</CODE> is <CODE>Unclipped</CODE>, there is no particular relationship
   between <CODE>ba</CODE>'s clipping rectangle and the clipping rectangles of the
   entries in <CODE>ba</CODE>. 

<P><PRE>PROCEDURE <A HREF="BatchUtil.m3#Meet">Meet</A> (ba: Batch.T; READONLY clip: Rect.T);
</PRE><BLOCKQUOTE><EM> Set <CODE>ba</CODE>'s clipping rectangle to <CODE>Rect.Meet(GetClip(ba), clip)</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If the assignment is non-trivial, this will change the clip state of
   <CODE>ba</CODE> to be <CODE>Unclipped</CODE>. 

<P><PRE>PROCEDURE <A HREF="BatchUtil.m3#Clip">Clip</A> (ba: Batch.T);
</PRE><BLOCKQUOTE><EM> Apply <CODE>ba</CODE>'s clipping rectangle to each operation. </EM></BLOCKQUOTE><PRE>
</PRE> That is, if <CODE>GetClipState(ba)</CODE> is <CODE>Unclipped</CODE>, then for each painting
   operation in <CODE>ba</CODE>, <CODE>Clip</CODE> replaces the clipping rectangle of the
   operation with the meet of the rectangle and <CODE>GetClip(ba)</CODE>, and sets the
   clipstate of <CODE>ba</CODE> to <CODE>Clipped</CODE>. 

<P><PRE>PROCEDURE <A HREF="BatchUtil.m3#Tighten">Tighten</A> (ba: Batch.T);
</PRE><BLOCKQUOTE><EM> Achieve <CODE>ba.clipped = Tight</CODE> without changing the effect of <CODE>ba</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> That is, <CODE>Tighten(ba)</CODE> is equivalent to <CODE>Clip(ba)</CODE> followed by assigning
   to <CODE>ba</CODE>'s clipping rectangle the join of the resulting clipping
   rectangles of the entries in <CODE>ba</CODE>. 

<P><PRE>PROCEDURE <A HREF="BatchUtil.m3#Translate">Translate</A> (ba: Batch.T; READONLY delta: Point.T);
</PRE><BLOCKQUOTE><EM> Translate <CODE>ba</CODE> by <CODE>delta</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> That is, for each painting operation in <CODE>ba</CODE>, translate the target of
   the painting operation by <CODE>delta</CODE>.  This always involves translating the
   clipping rectangle of the operation by <CODE>delta</CODE>.  It also adds <CODE>delta</CODE> to
   the <CODE>delta</CODE> components of all textures and to the reference point of
   <CODE>TextComs</CODE>.  It adjusts the <CODE>p1</CODE>, <CODE>p2</CODE>, <CODE>vlo</CODE>, and <CODE>vhi</CODE> fields of
   <CODE>TrapComs</CODE>.  The relative displacement of a scrolling command is not
   affected; that is, both the source and target of the scroll are
   translated by <CODE>delta</CODE>.  The clipping rectangle of the batch is also
   translated. 

<P><PRE>PROCEDURE <A HREF="BatchUtil.m3#ByteSwap">ByteSwap</A> (ba: Batch.T);
</PRE><BLOCKQUOTE><EM> Convert all text painting operations in <CODE>ba</CODE> to have the same byteorder
   as <CODE>PaintPrivate.HostByteOrder</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="BatchUtil.m3#Succ">Succ</A> (ba: Batch.T; cptr: PaintPrivate.CommandPtr):
  PaintPrivate.CommandPtr;
</PRE><BLOCKQUOTE><EM> Return the pointer to the entry in <CODE>ba</CODE> that follows the one pointed to
   by <CODE>cptr</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Succ(ba, NIL)</CODE> returns the first entry in <CODE>ba</CODE>; <CODE>Succ(ba, cptr) = NIL</CODE>
   when <CODE>cptr</CODE> is the last entry in <CODE>ba</CODE>.  To visit each entry in the batch
   <CODE>ba</CODE>, use a loop like this:
<P>
<PRE>
      cptr := BatchUtil.Succ(ba, NIL);
      WHILE cptr # NIL DO
        CASE cptr.command OF ... END;
        cptr := BatchUtil.Succ(ba, cptr)
      END
</PRE>
   The <CODE>PaintPrivate</CODE> interface explains the format of the entries. 

<P><PRE>PROCEDURE <A HREF="BatchUtil.m3#SetPicture">SetPicture</A> (ba: Batch.T);
</PRE><BLOCKQUOTE><EM> mark the batch as containing pictures </EM></BLOCKQUOTE><PRE>

END BatchUtil.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
