<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/BatchUtil.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/BatchUtil.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module>BatchUtil</module> EXPORTS <A HREF="BatchRep.i3"><implements>BatchRep</A></implements>, <A HREF="BatchUtil.i3"><implements>BatchUtil</A></implements>;

IMPORT <A HREF="Batch.i3">Batch</A>, <A HREF="PaintPrivate.i3">PaintPrivate</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../picture/PictureRep.i3">PictureRep</A>;

TYPE PC = PaintPrivate.PaintCommand;

PROCEDURE <A NAME="GetClip"><procedure>GetClip</procedure></A> (ba: Batch.T): Rect.T =
  BEGIN
    RETURN ba.clip
  END GetClip;

PROCEDURE <A NAME="GetClipState"><procedure>GetClipState</procedure></A> (ba: Batch.T): ClipState =
  BEGIN
    RETURN ba.clipped
  END GetClipState;

PROCEDURE <A NAME="GetLength"><procedure>GetLength</procedure></A> (ba: Batch.T): CARDINAL =
  BEGIN
    RETURN (ba.next - ADR(ba.b[0])) DIV ADRSIZE(Word.T)
  END GetLength;

PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A> (ba: Batch.T): Batch.T =
  VAR
    len := GetLength(ba);
    res := Batch.New(len);
  BEGIN
    SUBARRAY(res.b^, 0, len) := SUBARRAY(ba.b^, 0, len);
    res.clip := ba.clip;
    res.clipped := ba.clipped;
    res.scrollSource := ba.scrollSource;
    res.next := ADR(res.b[0]) + (ba.next - ADR(ba.b[0]));
    res.firstSingle := res.next;
    res.containsPicture := ba.containsPicture;
    IF res.containsPicture THEN PictureRep.IncrementBatch(res); END;
    RETURN res
  END Copy;

PROCEDURE <A NAME="Meet"><procedure>Meet</procedure></A> (ba: Batch.T; READONLY clip: Rect.T) =
  BEGIN
    IF NOT Rect.Subset(ba.clip, clip) THEN
      ba.clip := Rect.Meet(ba.clip, clip);
      ba.clipped := ClipState.Unclipped
    END
  END Meet;

&lt;* UNUSED *&gt; PROCEDURE <A NAME="Verify"><procedure>Verify</procedure></A> (ba: Batch.T) =
  VAR
    p         : PaintPrivate.CommandPtr;
    start, end: INTEGER;
  BEGIN
    IF ba = NIL THEN RETURN END;
    start := 0;
    end := (ba.next - ADR(ba.b[0])) DIV ADRSIZE(Word.T);
    WHILE start # end DO
      p := LOOPHOLE(ADR(ba.b[start]), PaintPrivate.CommandPtr);
      INC(start, PaintPrivate.CommandLength(p));
      CASE p.command OF
      | PC.TextCom =&gt;
          WITH pText = LOOPHOLE(p, PaintPrivate.TextPtr) DO
            IF pText.szOfRec &lt; ADRSIZE(PaintPrivate.TextRec) THEN
              Crash()
            END
          END;
      | PC.ExtensionCom =&gt;
          WITH pExtension = LOOPHOLE(p, PaintPrivate.ExtensionPtr) DO
            IF pExtension.szOfRec &lt; ADRSIZE(PaintPrivate.ExtensionRec) THEN
              Crash()
            END
          END;
      ELSE                       (*skip*)
      END
    END
  END Verify;

PROCEDURE <A NAME="Clip"><procedure>Clip</procedure></A> (ba: Batch.T) =
  BEGIN
    IF ba.clipped = ClipState.Unclipped THEN
      ClipSub(ba.clip, ba.b^, 0, GetLength(ba));
      ba.clipped := ClipState.Clipped
    END
  END Clip;

PROCEDURE <A NAME="ClipSub"><procedure>ClipSub</procedure></A> (READONLY clip   : Rect.T;
                   VAR      ba     : ARRAY OF Word.T;
                            st, len: INTEGER          ) =
  VAR
    start, end: INTEGER;
    p         : PaintPrivate.CommandPtr;
    cw                                  := clip.west;
    ce                                  := clip.east;
    cn                                  := clip.north;
    cs                                  := clip.south;
  BEGIN
    start := st;
    end := st + len;
    WHILE start &lt; end DO
      p := LOOPHOLE(ADR(ba[start]), PaintPrivate.CommandPtr);
      INC(start, PaintPrivate.CommandLength(p));
      VAR
        pw := p.clip.west;
        pe := p.clip.east;
        pn := p.clip.north;
        ps := p.clip.south;
      BEGIN
        IF pw &lt; cw OR pe &gt; ce OR pn &lt; cn OR ps &gt; cs THEN
          IF p.command = PC.TextCom THEN
            WITH t = LOOPHOLE(p, PaintPrivate.TextPtr) DO
              t.props :=
                t.props + PaintPrivate.Props{PaintPrivate.Prop.Clipped}
            END
          END;
          IF pw &lt; cw THEN p.clip.west := cw END;
          IF pe &gt; ce THEN p.clip.east := ce END;
          IF pn &lt; cn THEN p.clip.north := cn END;
          IF ps &gt; cs THEN p.clip.south := cs END;
          IF (p.clip.west &gt;= p.clip.east) OR (p.clip.north &gt;= p.clip.south) THEN
            p.clip := Rect.Empty
          END
        END
      END
    END
  END ClipSub;

TYPE RectPtr = UNTRACED REF Rect.T;

PROCEDURE <A NAME="ClipSubAndTighten"><procedure>ClipSubAndTighten</procedure></A> (READONLY    clip        : Rect.T;
                             VAR         ba          : ARRAY OF Word.T;
                                         st, len     : INTEGER;
                             VAR (*out*) scrollSource: Rect.T           ):
  Rect.T =
  VAR
    start, end: INTEGER;
    p         : PaintPrivate.CommandPtr;
    join      : Rect.T;
    firstTime : BOOLEAN;
    clipPtr   : RectPtr;
    joinPtr   : RectPtr;
    clipped   : BOOLEAN;
  BEGIN
    firstTime := TRUE;
    clipPtr := ADR(clip);
    joinPtr := ADR(join);
    scrollSource := Rect.Empty;
    start := st;
    end := st + len;
    WHILE start &lt; end DO
      p := LOOPHOLE(ADR(ba[start]), PaintPrivate.CommandPtr);
      INC(start, PaintPrivate.CommandLength(p));
      IF p.command = PC.TextCom THEN
        WITH pText = LOOPHOLE(p, PaintPrivate.TextPtr) DO
          clipped := FALSE;
          IF p.clip.west &lt; clipPtr.west THEN
            clipped := TRUE;
            p.clip.west := clipPtr.west
          END;
          IF p.clip.east &gt; clipPtr.east THEN
            clipped := TRUE;
            p.clip.east := clipPtr.east
          END;
          IF p.clip.north &lt; clipPtr.north THEN
            clipped := TRUE;
            p.clip.north := clipPtr.north
          END;
          IF p.clip.south &gt; clipPtr.south THEN
            clipped := TRUE;
            p.clip.south := clipPtr.south
          END;
          IF clipped THEN
            pText.props := pText.props +
              PaintPrivate.Props{PaintPrivate.Prop.Clipped}
          END
        END;
      ELSE
        IF p.clip.west &lt; clipPtr.west THEN p.clip.west := clipPtr.west END;
        IF p.clip.east &gt; clipPtr.east THEN p.clip.east := clipPtr.east END;
        IF p.clip.north &lt; clipPtr.north THEN
          p.clip.north := clipPtr.north
        END;
        IF p.clip.south &gt; clipPtr.south THEN
          p.clip.south := clipPtr.south
        END;
      END;
      (* Normalize p.clip; join := Rect.Join(join, p.clip): *)
      IF (p.clip.west &gt;= p.clip.east) OR (p.clip.north &gt;= p.clip.south) THEN
        p.clip := Rect.Empty
      ELSIF firstTime THEN
        join := p.clip;
        firstTime := FALSE
      ELSE
        IF joinPtr.west &gt; p.clip.west THEN joinPtr.west := p.clip.west END;
        IF joinPtr.east &lt; p.clip.east THEN joinPtr.east := p.clip.east END;
        IF joinPtr.north &gt; p.clip.north THEN
          joinPtr.north := p.clip.north
        END;
        IF joinPtr.south &lt; p.clip.south THEN
          joinPtr.south := p.clip.south
        END
      END;
      IF p.command = PC.ScrollCom THEN
        WITH pScroll = LOOPHOLE(p, PaintPrivate.ScrollPtr) DO
          scrollSource :=
            Rect.Join(scrollSource,
                      Rect.Move(pScroll.clip, Point.Minus(pScroll.delta)))
        END
      END
    END;
    IF NOT firstTime THEN RETURN join ELSE RETURN Rect.Empty END
  END ClipSubAndTighten;

PROCEDURE <A NAME="Tighten"><procedure>Tighten</procedure></A> (ba: Batch.T) =
  BEGIN
    IF ba.clipped = ClipState.Unclipped THEN
      ba.clip := ClipSubAndTighten(
                   ba.clip, ba.b^, 0, GetLength(ba), ba.scrollSource)
    ELSIF ba.clipped = ClipState.Clipped THEN
      TightenSub(ba.b^, 0, GetLength(ba), ba.clip)
    END;
    ba.clipped := ClipState.Tight
  END Tighten;

PROCEDURE <A NAME="TightenSub"><procedure>TightenSub</procedure></A> (VAR           btch   : ARRAY OF Word.T;
                                    st, len: INTEGER;
                      VAR (* out *) clip   : Rect.T           ) =
  VAR
    start, end : INTEGER;
    p          : PaintPrivate.CommandPtr;
    clipIsEmpty: BOOLEAN;
  BEGIN
    clipIsEmpty := TRUE;         (* logically *)
    start := st;
    end := st + len;
    WHILE start &lt; end DO
      p := LOOPHOLE(ADR(btch[start]), PaintPrivate.CommandPtr);
      INC(start, PaintPrivate.CommandLength(p));
      WITH r = p.clip DO
        IF r.west &lt; r.east THEN
          IF clipIsEmpty THEN
            clip := p.clip;
            clipIsEmpty := FALSE
          ELSE
            (* join of two non-empty rectangles *)
            IF r.west &lt; clip.west THEN clip.west := r.west END;
            IF r.east &gt; clip.east THEN clip.east := r.east END;
            IF r.north &lt; clip.north THEN clip.north := r.north END;
            IF r.south &gt; clip.south THEN clip.south := r.south END;
          END
        END
      END
    END;
    IF clipIsEmpty THEN clip := Rect.Empty END
  END TightenSub;

PROCEDURE <A NAME="Translate"><procedure>Translate</procedure></A> (ba: Batch.T; READONLY delta: Point.T) =
  BEGIN
    TranslateSub(ba.b^, 0, GetLength(ba), delta);
    ba.clip := Rect.Move(ba.clip, delta);
    ba.scrollSource := Rect.Move(ba.scrollSource, delta)
  END Translate;

PROCEDURE <A NAME="TranslateSub"><procedure>TranslateSub</procedure></A> (VAR      btch   : ARRAY OF Word.T;
                                 st, len: INTEGER;
                        READONLY delta  : Point.T          ) =
  VAR
    start, end: INTEGER;
    p         : PaintPrivate.CommandPtr;
  BEGIN
    start := st;
    end := st + len;
    WHILE start &lt; end DO
      p := LOOPHOLE(ADR(btch[start]), PaintPrivate.CommandPtr);
      INC(start, PaintPrivate.CommandLength(p));
      p.clip := Rect.Move(p.clip, delta);
      CASE p.command OF
        PC.TextureCom, PC.PixmapCom =&gt;
          WITH pTexture = LOOPHOLE(p, PaintPrivate.PixmapPtr) DO
            pTexture.delta := Point.Add(pTexture.delta, delta)
          END
      | PC.TextCom =&gt;
          WITH pText = LOOPHOLE(p, PaintPrivate.TextPtr) DO
            pText.refpt := Point.Add(pText.refpt, delta)
          END
      | PC.TrapCom =&gt;
          WITH pTrap = LOOPHOLE(p, PaintPrivate.TrapPtr) DO
            pTrap.delta := Point.Add(pTrap.delta, delta);
            pTrap.p1 := Point.Add(pTrap.p1, delta);
            pTrap.p2 := Point.Add(pTrap.p2, delta);
          END
      | PC.ExtensionCom =&gt;
          WITH pExtension = LOOPHOLE(p, PaintPrivate.ExtensionPtr) DO
            pExtension.delta := Point.Add(pExtension.delta, delta)
          END
      ELSE
      END
    END
  END TranslateSub;
</PRE> VAR buffer: Wr.T;
<P>
   PROCEDURE Parse(ba: Batch.T): Text.T; CONST RepeatFormat = <CODE>Repeat: w
   %-4d e %-4d n %-4d s %-4d\n</CODE>; TintFormat = <CODE>PaintTint: w %-4d e %-4d n
   %-4d s %-4d\n</CODE>; TextureFormat = <CODE>PaintTexture: w %-4d e %-4d n %-4d s
   %-4d\n</CODE>; TextFormat = <CODE>PaintText: w %-4d e %-4d n %-4d s %-4d\n</CODE>;
   BitmapFormat = <CODE>PaintBitmap: w %-4d e %-4d n %-4d s %-4d\n</CODE>; TrapFormat
   = <CODE>PaintTrap: w %-4d e %-4d n %-4d s %-4d\n</CODE>; ExtensionFormat =
   <CODE>PaintExtension: w %-4d e %-4d n %-4d s %-4d\n</CODE>; ScrollFormat = <CODE>Scroll:
   w %-4d e %-4d n %-4d s %-4d\n</CODE>; VAR start, end: INTEGER; p:
   PaintPrivate.CommandPtr; pTint: PaintPrivate.TintPtr; pTexture:
   PaintPrivate.TexturePtr; pPixmap: PaintPrivate.PixmapPtr; pText:
   PaintPrivate.TextPtr; pScroll: PaintPrivate.ScrollPtr; pTrap:
   PaintPrivate.TrapPtr; pExtension: PaintPrivate.ExtensionPtr; BEGIN start
   := 0; end := (ba.next - ADR(ba.b^[0])) DIV ADRSIZE(Word.T); WHILE start
   # end DO p := ADR(ba.b^[start]); INC(start,
   PaintPrivate.CommandLength(p)); CASE p.command OF RepeatCom: WITH p.clip
   DO PRINTF(buffer, RepeatFormat, west, east, north, south) END; |
   TintCom: pTint := LOOPHOLE(p, PaintPrivate.TintPtr); WITH pTint.clip DO
   PRINTF(buffer, TintFormat, west, east, north, south) END; | TextureCom,
   PixmapCom: pTexture := LOOPHOLE(p, PaintPrivate.PixmapPtr); WITH
   pTexture.clip DO PRINTF(buffer, TextureFormat, west, east, north, south)
   END; | TextCom: pText := LOOPHOLE(p, PaintPrivate.TextPtr); WITH
   pText.clip DO PRINTF(buffer, TextFormat, west, east, north, south) END;
   <PRE>
      ScrollCom: pScroll := LOOPHOLE(p, PaintPrivate.ScrollPtr); WITH
   </PRE>
pScroll.clip DO PRINTF(buffer, ScrollFormat, west, east, north, south)
   END; | TrapCom: pTrap := LOOPHOLE(p, PaintPrivate.TrapPtr); WITH
   pTrap.clip DO PRINTF(buffer, TrapFormat, west, east, north, south) END;
   <PRE>
      ExtensionCom: pExtension := LOOPHOLE(p, PaintPrivate.ExtensionPtr);
   </PRE>
WITH pExtension.clip DO PRINTF(buffer, ExtensionFormat, west, east,
   north, south) END; ELSE ASSERT(FALSE, <CODE>Unimplemented operation</CODE>) END
   END; RETURN Wr.ToText(buffer) END Parse; 

<P><PRE>PROCEDURE <A NAME="ByteSwap"><procedure>ByteSwap</procedure></A> (&lt;*UNUSED*&gt; ba: Batch.T) RAISES {} =
  BEGIN
    Crash();
  END ByteSwap;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (ba: Batch.T; cptr: PaintPrivate.CommandPtr):
  PaintPrivate.CommandPtr =
  BEGIN
    IF cptr = NIL THEN
      RETURN LOOPHOLE(ADR(ba.b[0]), PaintPrivate.CommandPtr)
    END;
    INC(cptr, PaintPrivate.CommandLength(cptr) * ADRSIZE(Word.T));
    IF cptr = ba.next THEN RETURN NIL END;
    RETURN cptr
  END Succ;

PROCEDURE <A NAME="SetPicture"><procedure>SetPicture</procedure></A> (ba: Batch.T) =
  BEGIN
    ba.containsPicture := TRUE;
  END SetPicture;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;*FATAL FatalError*&gt;
  BEGIN
    RAISE FatalError
  END Crash;

BEGIN
END BatchUtil.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
