<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/Cursor.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/Cursor.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>Cursor.T</CODE> is a screen-independent specification of a cursor shape. 
   The call <CODE>VBT.SetCursor(v, cs)</CODE> sets the cursor of <CODE>v</CODE> to
   be <CODE>cs</CODE>. 
<P>
   The locking level is <CODE>LL.sup &lt;= VBT.mu</CODE> for all of the procedures
   in this interface. 

<P><PRE>INTERFACE <interface><A HREF="Cursor.m3">Cursor</A></interface>;

IMPORT <A HREF="Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>;

TYPE T = RECORD cs: INTEGER END; Predefined = [0..2];

CONST
  DontCare = T{0};
  TextPointer = T{1};
  NotReady = T{2};
</PRE> You should set <CODE>Cursor.DontCare</CODE> when you don't care about the cursor
   shape; <CODE>Cursor.TextPointer</CODE> when the cursor is to be used for editing
   text, and <CODE>Cursor.NotReady</CODE> to indicate that the application is not
   receptive to user input.  

<P><PRE>TYPE Raw = RECORD
    plane1, plane2: Pixmap.Raw;
    hotspot: Point.T;
    color1, color2, color3: RGB;
  END;
  BW = {UseBg, UseFg, UseIntensity};
  RGB = RECORD
    r, g, b: REAL;
    gray := -1.0;
    bw := BW.UseIntensity
  END;
</PRE> A <CODE>Raw</CODE> represents a cursor with explicit offset, 
   bitmaps, and colors.    
<P>
   The <CODE>plane1</CODE> and <CODE>plane2</CODE> are depth-1 pixmaps.  They must
   have the same bounding rectangle, and the hotspot must lie
   within the bounding rectangle or on its east or south edge.
   If the hotspot is illegal, it will be moved to the closest
   legal position.
<P>
   The cursor's hotspot is kept on top of the mouse's location on the
   screen.  The cursor's image tracks the mouse relative to the hotspot.
   For example, if the hotspot is (0, 0), the (0, 0) bit of the cursor's
   image will be located over the mouse's location.  The remainder of
   the cursor will appear to the south and east.
<P>
   The color of each pixel in the cursor's image is determined from the
   corresponding bits in <CODE>plane1</CODE> and <CODE>plane2</CODE> (<CODE>p1</CODE> and <CODE>p2</CODE>):
<P>
<PRE>
      p1 = 0, p2 = 0  =&gt; <KBD>transparent</KBD>
      p1 = 0, p2 = 1  =&gt; color1
      p1 = 1, p2 = 0  =&gt; color2
      p1 = 1, p2 = 1  =&gt; color3
</PRE>
   The colors for the cursor are matched as closely as possible to the
   selection of cursor colors that the screentype supports.  If the
   screentype allows only two colors for the cursor, then the pixels that
   would have been <CODE>color3</CODE> will be <CODE>color1</CODE>.  The <CODE>gray</CODE> and <CODE>bw</CODE>
   values control the color on gray-scale and monochrome displays, 
   according to the same rule used in <CODE>PaintOp.FromRGB</CODE>.  
     
<P><PRE>PROCEDURE <A HREF="Cursor.m3#FromRaw">FromRaw</A>(READONLY r: Raw): T;
</PRE><BLOCKQUOTE><EM> Return a cursor that looks like <CODE>r</CODE> on all screens. </EM></BLOCKQUOTE><PRE>
</PRE> If the screentype does not support <CODE>r</CODE>'s colors or size, <CODE>FromRaw</CODE>
   will clip or convert colors as necessary.  On a screentype that does
   not allow user-defined cursors, the cursor returned by <CODE>FromRaw</CODE>
   will behave like <CODE>DontCare</CODE>.  

<P><PRE>PROCEDURE <A HREF="Cursor.m3#FromName">FromName</A>(READONLY names: ARRAY OF TEXT): T;
</PRE><BLOCKQUOTE><EM> Return the first available cursor of those named in the array <CODE>names</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The entries of <CODE>names</CODE> are cursor names as specified in the
   <CODE>ScrnCursor</CODE> interface, possibly containing wild card characters.
   On any particular screentype, <CODE>FromName(names)</CODE> iterates through
   <CODE>names</CODE> in order and returns an arbitrary match from the first name
   that matches anything.  If no name has any matches, it returns
   <CODE>DontCare</CODE>.
<P>
   Standard X screentypes support the cursors named in {\it X Window
   System} by Scheifler et.  al. \cite{XSpec} Appendix B. Therefore, for
   example,
<P>
<PRE>
      FromName(ARRAY OF TEXT{&quot;XC_arrow&quot;})
</PRE>
   returns a cursor that behaves like the X arrow cursor on 
   X screentypes, and like <CODE>DontCare</CODE> on screentypes 
   that have no cursor named <CODE>XC_arrow</CODE>.  

<P><PRE>END Cursor.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
