<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/Cursor.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/Cursor.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="Cursor.i3">Cursor</A></implements></module>;

IMPORT <A HREF="Palette.i3">Palette</A>, <A HREF="PlttFrnds.i3">PlttFrnds</A>, <A HREF="ScrnCursor.i3">ScrnCursor</A>, <A HREF="ScreenType.i3">ScreenType</A>, <A HREF="TrestleComm.i3">TrestleComm</A>, <A HREF="../../../text/src/Text.i3">Text</A>;

PROCEDURE <A NAME="FromRaw"><procedure>FromRaw</procedure></A> (READONLY r: Raw): T =
  VAR rr := r;
  BEGIN
    FixRGB(rr.color1);
    FixRGB(rr.color2);
    FixRGB(rr.color3);
    LOCK PlttFrnds.con DO
      IF PlttFrnds.con.cursors # NIL THEN
        FOR i := 0 TO PlttFrnds.con.nextCursor - 1 DO
          TYPECASE PlttFrnds.con.cursors[i] OF
            NULL =&gt;              (* skip *)
          | Closure (cl) =&gt; IF cl.raw = rr THEN RETURN T{i} END
          ELSE
          END
        END
      END
    END;
    RETURN Palette.FromCursorClosure(NEW(Closure, raw := rr))
  END FromRaw;

PROCEDURE <A NAME="FixRGB"><procedure>FixRGB</procedure></A>(VAR c: RGB) =
</PRE><BLOCKQUOTE><EM> adjust c.gray so that it is in [0..1], and c.bw so 
   that it is not UseIntensity. </EM></BLOCKQUOTE><PRE>
  BEGIN
    IF c.gray &lt; 0.0 THEN
      c.gray := MIN(1.0, MAX(0.0, 0.2390 * c.r + 0.6860 * c.g + 0.0750 * c.b))
    END;
    IF c.bw = BW.UseIntensity THEN
      IF c.r = 0.0 AND c.g = 0.0 AND c.b = 0.0 THEN
        c.bw := BW.UseFg
      ELSE
        c.bw := BW.UseBg
      END
    END
  END FixRGB;

TYPE Closure = Palette.CursorClosure OBJECT
    raw: Raw;
  OVERRIDES
    apply := Apply
  END;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A>(cl: Closure; st: ScreenType.T): ScrnCursor.T =
  BEGIN
    TRY
      RETURN st.cursor.load(cl.raw)
    EXCEPT
      TrestleComm.Failure =&gt; RETURN Palette.ResolveCursor(st, DontCare)
    END
  END Apply;

PROCEDURE <A NAME="FromName"><procedure>FromName</procedure></A> (READONLY names: ARRAY OF TEXT): T =
  VAR tl := NEW(REF ARRAY OF TEXT, NUMBER(names));
  BEGIN
    FOR i := 0 TO LAST(names) DO tl[i] := names[i] END;
    LOCK PlttFrnds.con DO
      IF PlttFrnds.con.cursors # NIL THEN
        FOR i := 0 TO PlttFrnds.con.nextCursor - 1 DO
          TYPECASE PlttFrnds.con.cursors[i] OF
            NULL =&gt;              (* skip *)
          | NameClosure (cl) =&gt;
              IF NUMBER(cl.names^) = NUMBER(tl^) THEN
                VAR match := TRUE;
                BEGIN
                  FOR j := 0 TO LAST(tl^) DO
                    match := match AND Text.Equal(cl.names[j], tl[j])
                  END;
                  IF match THEN RETURN T{i} END
                END
              END
          ELSE
          END
        END
      END
    END;
    RETURN Palette.FromCursorClosure(NEW(NameClosure, names := tl))
  END FromName;

TYPE NameClosure = Palette.CursorClosure OBJECT
    names: REF ARRAY OF TEXT;
  OVERRIDES
    apply := NameApply
  END;

PROCEDURE <A NAME="NameApply"><procedure>NameApply</procedure></A>(cl: NameClosure; st: ScreenType.T): ScrnCursor.T =
  VAR res: ScrnCursor.T;
  BEGIN
    FOR i := FIRST(cl.names^) TO LAST(cl.names^) DO
      TRY
        res := st.cursor.lookup(cl.names[i]);
        IF res # NIL THEN RETURN res END;
      EXCEPT
        TrestleComm.Failure=&gt; (*skip*)
      END
    END;
    RETURN Palette.ResolveCursor(st, DontCare)
  END NameApply;

 BEGIN END Cursor.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
