<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/Font.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/Font.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>Font.T</CODE> is a screen-independent specification of a typeface.  There
   is one predefined <CODE>Font.T</CODE>, which yields the built-in font of the
   screentype.  
<P>
   The locking level is <CODE>LL.sup &lt;= VBT.mu</CODE> for all of the procedures
   in this interface. 

<P><PRE>INTERFACE <interface><A HREF="Font.m3">Font</A></interface>;

TYPE T = RECORD fnt: INTEGER END; Predefined = [0..0];

CONST BuiltIn = T{0};

PROCEDURE <A HREF="Font.m3#FromName">FromName</A>(READONLY names: ARRAY OF TEXT): T;
</PRE><BLOCKQUOTE><EM> Return the first available font of those named in the array <CODE>names</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The entries of <CODE>names</CODE> are font names as specified in the <CODE>ScrnFont</CODE>
   interface, possibly containing wild card characters.  On any
   particular screentype, <CODE>FromName(names)</CODE> iterates through <CODE>names</CODE>
   in order and returns an arbitrary match from the first name that
   matches anything.  If no name has any matches, it returns the
   built-in font.
   <P>
   Standard X screentypes give fonts long ``names'' that encode their
   properties, so with X it is almost always desirable to include
   wild-card characters in the names.  For example,
<P>
<PRE>
      FromName(
       ARRAY OF TEXT{&quot;-*-times-medium-r-*-*-*-10?-*&quot;})
</PRE>
  will return a font that, on an X server containing the standard fonts, 
  is some Times Roman medium-weight unslanted font sized 10 to 10.9 points, 
  and behaves like <CODE>Font.BuiltIn</CODE> on any screentye that doesn't have a font 
  whose name matches the pattern.  

<P><PRE>END Font.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
