<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/Font.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/Font.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="Font.i3">Font</A></implements></module>;

IMPORT <A HREF="Palette.i3">Palette</A>, <A HREF="PlttFrnds.i3">PlttFrnds</A>, <A HREF="ScrnFont.i3">ScrnFont</A>, <A HREF="ScreenType.i3">ScreenType</A>, <A HREF="TrestleComm.i3">TrestleComm</A>, <A HREF="../../../text/src/Text.i3">Text</A>;

TYPE TextList = REF ARRAY OF TEXT;

PROCEDURE <A NAME="FromName"><procedure>FromName</procedure></A> (READONLY names: ARRAY OF TEXT): T =
  VAR tl := NEW(TextList, NUMBER(names));
  BEGIN
    FOR i := 0 TO LAST(names) DO tl[i] := names[i] END;
    LOCK PlttFrnds.con DO
      IF PlttFrnds.con.fonts # NIL THEN
        FOR i := 0 TO PlttFrnds.con.nextFont - 1 DO
          TYPECASE PlttFrnds.con.fonts[i] OF
            NULL =&gt;              (* skip *)
          | Closure (cl) =&gt;
              IF NUMBER(cl.names^) = NUMBER(tl^) THEN
                VAR match := TRUE;
                BEGIN
                  FOR j := 0 TO LAST(tl^) DO
                    match := match AND Text.Equal(cl.names[j], tl[j])
                  END;
                  IF match THEN RETURN T{i} END
                END
              END
          ELSE
          END
        END
      END
    END;
    RETURN Palette.FromFontClosure(NEW(Closure, names := tl))
  END FromName;

TYPE Closure = Palette.FontClosure OBJECT
    names: TextList;
  OVERRIDES
    apply := Apply
  END;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A>(cl: Closure; st: ScreenType.T): ScrnFont.T =
  BEGIN
    FOR i := FIRST(cl.names^) TO LAST(cl.names^) DO
      TRY
        RETURN st.font.lookup(cl.names[i])
      EXCEPT
        TrestleComm.Failure, ScrnFont.Failure =&gt; (*skip*)
      END
    END;
    RETURN Palette.ResolveFont(st, BuiltIn)
  END Apply;

BEGIN END Font.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
