<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/MiscDetail.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/MiscDetail.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="MiscDetail.i3">MiscDetail</A></implements></module>;

VAR mu := NEW(MUTEX);
    tbl := NEW(REF ARRAY OF REFANY, 0);

PROCEDURE <A NAME="FromRef"><procedure>FromRef</procedure></A> (ra: REFANY): INTEGER =
  BEGIN
    IF ra = NIL THEN RETURN -1 END;
    LOCK mu DO
      FOR i := 0 TO LAST(tbl^) DO
        IF tbl[i] = NIL THEN tbl[i] := ra; RETURN i END
      END;
      VAR
        n   := NUMBER(tbl^);
        new := NEW(REF ARRAY OF REFANY, MAX(4, 2 * n));
      BEGIN
        SUBARRAY(new^, 0, n) := tbl^;
        FOR i := n TO LAST(new^) DO new[i] := NIL END;
        new[n] := ra;
        tbl := new;
        RETURN n
      END
    END
  END FromRef;

PROCEDURE <A NAME="ToRef"><procedure>ToRef</procedure></A> (i: INTEGER): REFANY =
  BEGIN
    LOCK mu DO
      IF i &lt; 0 OR i &gt; LAST(tbl^) THEN RETURN NIL END;
      RETURN tbl[i]
    END
  END ToRef;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A>(i: INTEGER) =
  BEGIN
    LOCK mu DO
      IF i &lt; 0 OR i &gt; LAST(tbl^) THEN RETURN END;
      tbl[i] := NIL
    END
  END Delete;

BEGIN
END MiscDetail.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
