<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/PaintOp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/PaintOp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>PaintOp.T</CODE> is a screen-independent painting operation. 
<P>
A painting operation <CODE>op</CODE> takes a source pixel <CODE>s</CODE> and a destination
pixel <CODE>d</CODE> and produces a new value <CODE>op(d, s)</CODE> for the destination pixel.
<P>
A painting operation that ignores the source pixel is called a {\it tint}.  
If <CODE>op</CODE> is a tint, we just write <CODE>op(d)</CODE> instead of <CODE>op(d, s)</CODE>.
If the effect of a tint is to set the destination pixel to
some fixed value independent of its initial value, then the 
tint is said to be {\it opaque}. 
<P>
The locking level is <CODE>LL.sup &lt;= VBT.mu</CODE> for all of the procedures
in this interface. 

<P><PRE>INTERFACE <interface><A HREF="PaintOp.m3">PaintOp</A></interface>;

TYPE
  T = RECORD op:INTEGER END; Predefined = [0..16];

CONST
  Bg = T{0};
  Fg = T{1};
  Transparent = T{2};
  Swap = T{3};

  Copy = T{4};
</PRE> <CODE>Bg</CODE>, <CODE>Fg</CODE>, <CODE>Transparent</CODE>, and <CODE>Swap</CODE> are Trestle's four basic tints.
   <P>
   <CODE>Bg</CODE> sets the destination pixel to the screen's background color;
   <CODE>Fg</CODE> sets it to the screen's foreground color; <CODE>Transparent</CODE> is the
   identity function; <CODE>Swap</CODE> is a self-inverting operation that
   exchanges the foreground and background pixels.  More precisely,
   consider a particular screentype and let <CODE>bgpix</CODE> and <CODE>fgpix</CODE> be the
   foreground and background pixel for that screentype.  Then for any
   pixel <CODE>d</CODE>,
<P>
<PRE>
      Bg(d) = bgpix
      Fg(d) = fgpix
</PRE>
<PRE>
      Transparent(d) = d
</PRE>
<PRE>
      Swap(bgpix) = fgpix
      Swap(fgpix) = bgpix
      Swap(Swap(d)) = d
      Swap(d) # d
</PRE>
The operation <CODE>Copy</CODE> copies source to destination:
<P>
<PRE>
      Copy(d, s) = s
</PRE>
<CODE>Copy</CODE> is not a tint, and should be used only when the source pixels
are of the same screentype as the destination pixels (for example,
with <CODE>VBT.Scroll</CODE>, or when painting a pixmap of the same type as
the screen).  

<P><PRE>CONST
  BgBg = Bg;
  BgFg = T{5};
  BgTransparent = T{6};
  BgSwap = T{7};

  FgFg = Fg;
  FgBg = T{8};
  FgTransparent = T{9};
  FgSwap = T{10};

  TransparentTransparent = Transparent;
  TransparentBg = T{11};
  TransparentFg = T{12};
  TransparentSwap = T{13};

  SwapSwap = Swap;
  SwapBg = T{14};
  SwapFg = T{15};
  SwapTransparent = T{16};
</PRE> The sixteen operations above all have names of the form <CODE>XY</CODE>,
   where <CODE>X</CODE> and <CODE>Y</CODE> are one of the four basic tints.
   They are defined by the rule:
<P>
<PRE>
      XY(dest, source) = 
        IF source = 0 THEN X(dest) ELSE Y(dest) END
</PRE>
   For example, <CODE>BgFg</CODE> can be used to paint a one bit deep source 
   interpreting zeros as background and ones as foreground. 
<P>
   Obviously these sixteen painting operations should be used only with
   one-bit deep sources.  However, not all one-bit deep sources are
   of the same screentype: for example, different screentypes might
   have different rules for representing bitmaps.  To accomodate this
   unfortunate fact of life, we associate with every screentype <CODE>st</CODE>
   another screentype <CODE>st.bits</CODE>, which is the type of bitmap sources
   appropriate for <CODE>st</CODE>. The depth of <CODE>st.bits</CODE> is always one.  If the
   depth of <CODE>st</CODE> is one, then it is possible (but not certain) that
   <CODE>st.bits = st</CODE>. When using one of sixteen operations above on a <CODE>VBT</CODE>
   with screentype <CODE>st</CODE>, the source must have type <CODE>st.bits</CODE>.  You will
   be happy to recall that this will be taken care of automatically
   if you use screen-independent bitmaps and fonts.
   <P>
   Next there is a procedure for generating colored painting operations. 

<P><PRE>TYPE
  Mode = {Stable, Normal, Accurate};
  BW = {UseBg, UseFg, UseIntensity};

PROCEDURE <A HREF="PaintOp.m3#FromRGB">FromRGB</A>(
   r, g, b: REAL;
   mode := Mode.Normal;
   gray := -1.0;
   bw := BW.UseIntensity): T;
</PRE><BLOCKQUOTE><EM> Return a tint that will set a pixel to the color <CODE>(r,g,b)</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The values <CODE>r</CODE>, <CODE>g</CODE>, and <CODE>b</CODE> should be in the range <CODE>0.0</CODE> to <CODE>1.0</CODE>;
   they represent the fractions of red, green, and blue in the
   desired color.
<P>
   The <CODE>gray</CODE> argument controls what the tint will do on a gray-scale
   display.  If <CODE>gray</CODE> is between zero and one, it specifies the
   intensity of the tint.  If <CODE>gray</CODE> is defaulted to <CODE>-1</CODE>, then the
   tint will use the intensity of the color <CODE>(r,g,b)</CODE>.
<P>
   The <CODE>bw</CODE> argument controls what the tint will be on a monochrome
   display.  If <CODE>bw</CODE> is <CODE>UseBg</CODE> or <CODE>UseFg</CODE>, then the tint will be <CODE>Bg</CODE>
   or <CODE>Fg</CODE>, respectively.  If <CODE>bw</CODE> is <CODE>UseIntensity</CODE>, then the tint
   will be <CODE>Fg</CODE> if <CODE>r</CODE>, <CODE>g</CODE>, and <CODE>b</CODE> are all zero (that is, if the color
   is black), and <CODE>Bg</CODE> otherwise.
<P>
   The <CODE>mode</CODE> argument is relevant on color and gray-scale displays.
   When the total number of pixel colors desired by all of the
   applications that are running exceeds the number of available colors,
   then some applications' colors will change (usually in an
   unpleasantly random way).  
   <P>
   To reduce the likelihood that your color will change randomly (at
   the cost of fidelity), set <CODE>mode</CODE> to <CODE>Stable</CODE>.  To increase the
   fidelity of the pixel to the specified intensities (at the cost of
   increased danger of random change), set <CODE>mode</CODE> to <CODE>Accurate</CODE>.  For
   example, an icon window should use stable colors; a color editor
   should use accurate colors.  

<P><PRE>PROCEDURE <A HREF="PaintOp.m3#Pair">Pair</A>(op0, op1: T): T;
</PRE><BLOCKQUOTE><EM> Return an operation <CODE>op</CODE> such that <CODE>op(d,0) = op0(d)</CODE> and
   <CODE>op(d,1) = op1(d)</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> For example, 
<P>
<PRE>
      Pair(FromRGB(1.0,1.0,1.0), FromRGB(1.0,0.0,0.0))
</PRE>
   will paint a bitmap with zeros as white and ones as red. 
   
<P><PRE>PROCEDURE <A HREF="PaintOp.m3#SwapPair">SwapPair</A>(op0, op1: T): T;
</PRE><BLOCKQUOTE><EM> Return an operation that swaps the pixels painted by <CODE>op0</CODE> and <CODE>op1</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>SwapPair</CODE> requires that <CODE>op0</CODE> and <CODE>op1</CODE> be opaque, that is,
   they must set the destination to particular pixels (say, <CODE>pix0</CODE> 
   and <CODE>pix1</CODE>). Then the tint <CODE>op</CODE> returned by <CODE>SwapPair</CODE> satisfies:
<P>
<PRE>
      op(pix0) = pix1
      op(pix1) = pix0
      op(op(p)) = p <KBD>for any pixel</KBD> p
</PRE>
For example, <CODE>Swap = SwapPair(Bg, Fg)</CODE>. 

<P> Sometimes it is handy to collect several related painting 
   operations into a single object: 

<P><PRE>TYPE
  ColorQuad = OBJECT
    bg, fg, bgFg, transparentFg: T
  END;

PROCEDURE <A HREF="PaintOp.m3#MakeColorQuad">MakeColorQuad</A>(bg, fg: T): ColorQuad;
</PRE><BLOCKQUOTE><EM> Return <CODE>ColorQuad{bg,fg,Pair(bg,fg),Pair(Transparent,fg)}</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE
  ColorScheme = ColorQuad OBJECT
    swap, bgTransparent, bgSwap, fgBg, fgTransparent,
      fgSwap, transparentBg, transparentSwap,
      swapBg, swapFg, swapTransparent: T;
  END;

PROCEDURE <A HREF="PaintOp.m3#MakeColorScheme">MakeColorScheme</A>(bg, fg: T): ColorScheme;
</PRE><BLOCKQUOTE><EM> Return the fifteen painting operations other than <CODE>Transparent</CODE> that
    can be made by combining <CODE>bg</CODE>, <CODE>fg</CODE>, and <CODE>Transparent</CODE>, using
    <CODE>SwapPair</CODE> and <CODE>Pair</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> In <CODE>MakeColorQuad</CODE> and <CODE>MakeColorScheme</CODE>, <CODE>bg</CODE> and <CODE>fg</CODE> should be 
   tints. 

<P><PRE>VAR (*CONST*) bgFg: ColorScheme;
</PRE> This ``variable'' is really a constant for <CODE>MakeColorScheme(Bg, Fg)</CODE>. 

<P><PRE>END PaintOp.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
