<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/PaintOp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/PaintOp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="PaintOp.i3">PaintOp</A></implements></module>;

IMPORT <A HREF="Palette.i3">Palette</A>, <A HREF="PlttFrnds.i3">PlttFrnds</A>, <A HREF="VBT.i3">VBT</A>, <A HREF="ScrnPaintOp.i3">ScrnPaintOp</A>, <A HREF="ScreenType.i3">ScreenType</A>, <A HREF="ScrnColorMap.i3">ScrnColorMap</A>,
  <A HREF="TrestleComm.i3">TrestleComm</A>;

TYPE RGBClosure = Palette.OpClosure OBJECT
    rgb: ScrnColorMap.RGB;
    mode: Mode;
    gray: REAL;
    bw: BW
  OVERRIDES
    apply := RGBApply
  END;

PROCEDURE <A NAME="FromRGB"><procedure>FromRGB</procedure></A> (r, g, b: REAL;
                   mode            := Mode.Normal;
                   gray            := -1.0;
                   bw              := BW.UseIntensity): T =
  VAR rgb := ScrnColorMap.RGB{r, g, b};
  BEGIN
    IF gray &lt; 0.0 THEN
      gray := MIN(1.0, MAX(0.0, 0.2390 * r + 0.6860 * g + 0.0750 * b))
    END;
    IF bw = BW.UseIntensity THEN
      IF r = 0.0 AND g = 0.0 AND b = 0.0 THEN
        bw := BW.UseFg
      ELSE
        bw := BW.UseBg
      END
    END;
    LOCK PlttFrnds.con DO
      IF PlttFrnds.con.ops # NIL THEN
        FOR i := 0 TO PlttFrnds.con.nextOp - 1 DO
          TYPECASE PlttFrnds.con.ops[i] OF
            NULL =&gt;              (* skip *)
          | RGBClosure (op) =&gt;
              IF op.rgb = rgb AND op.mode = mode AND op.gray = gray
                   AND op.bw = bw THEN
                RETURN T{i}
              END
          ELSE
          END
        END
      END
    END;
    RETURN Palette.FromOpClosure(NEW(RGBClosure, rgb := rgb, mode := mode,
                                     gray := gray, bw := bw))
  END FromRGB;

PROCEDURE <A NAME="RGBApply"><procedure>RGBApply</procedure></A>(cl: RGBClosure; st: VBT.ScreenType): ScrnPaintOp.T =
&lt;*FATAL ScrnPaintOp.Failure*&gt;
  BEGIN
    TRY
      IF st.cmap # NIL AND st.depth # 1 THEN
        VAR rgb := cl.rgb; gray := cl.gray; pix: ScrnColorMap.Pixel; BEGIN
          IF NOT st.color THEN
            rgb := ScrnColorMap.RGB{gray, gray, gray}
          END;
          TRY
            pix := st.cmap.standard().fromRGB(rgb, cl.mode)
          EXCEPT
            ScrnColorMap.Failure =&gt;
              TRY
                pix := st.cmap.standard().fromRGB(rgb, Mode.Normal)
              EXCEPT
                ScrnColorMap.Failure =&gt;
		  IF cl.bw = BW.UseBg THEN
                    RETURN Palette.ResolveOp(st, Bg)
		  ELSE
		    RETURN Palette.ResolveOp(st, Fg)
		  END
              END
          END;
          RETURN st.op.opaque(pix)
        END
      ELSE
        IF cl.bw = BW.UseBg THEN
          RETURN Palette.ResolveOp(st, Bg)
        ELSE
          RETURN Palette.ResolveOp(st, Fg)
        END
      END
    EXCEPT
      TrestleComm.Failure =&gt; RETURN Palette.ResolveOp(st, Fg)
    END;
  END RGBApply;

TYPE
  PairClosure = Palette.OpClosure OBJECT
    op0, op1: T
  OVERRIDES
    apply := ApplyPair
  END;

PROCEDURE <A NAME="Pair"><procedure>Pair</procedure></A> (op0, op1: T): T =
  BEGIN
    LOCK PlttFrnds.con DO
      IF PlttFrnds.con.ops # NIL THEN
        FOR i := 0 TO PlttFrnds.con.nextOp - 1 DO
          TYPECASE PlttFrnds.con.ops[i] OF
            NULL =&gt;              (* skip *)
          | PairClosure (cl) =&gt;
              IF cl.op0 = op0 AND cl.op1 = op1 THEN RETURN T{i} END
          ELSE
          END
        END
      END
    END;
    RETURN Palette.FromOpClosure(NEW(PairClosure, op0 := op0, op1 := op1))
  END Pair;

PROCEDURE <A NAME="ApplyPair"><procedure>ApplyPair</procedure></A>(cl: PairClosure; st: VBT.ScreenType): ScrnPaintOp.T =
  VAR sop0 := Palette.ResolveOp(st, cl.op0);
    sop1 := Palette.ResolveOp(st, cl.op1);
  BEGIN
    TRY
      RETURN st.op.bgfg(sop0, sop1)
    EXCEPT
      ScrnPaintOp.Failure, TrestleComm.Failure =&gt;
        RETURN Palette.ResolveOp(st, Transparent)
    END
  END ApplyPair;

TYPE SwapClosure = Palette.OpClosure OBJECT
    fg, bg: T;
  OVERRIDES
    apply := ApplySwap
  END;

PROCEDURE <A NAME="ApplySwap"><procedure>ApplySwap</procedure></A>(cl: SwapClosure; st: VBT.ScreenType): ScrnPaintOp.T =
  VAR
    fg := Palette.ResolveOp(st, cl.fg).pix;
    bg := Palette.ResolveOp(st, cl.bg).pix;
  BEGIN
    IF fg = -1 OR bg = -1 OR bg = fg THEN
      RETURN Palette.ResolveOp(st, Transparent)
    ELSE
      TRY
        RETURN st.op.swap(bg, fg)
      EXCEPT
        ScrnPaintOp.Failure, TrestleComm.Failure =&gt;
          RETURN Palette.ResolveOp(st, Transparent)
      END
    END
  END ApplySwap;

PROCEDURE <A NAME="SwapPair"><procedure>SwapPair</procedure></A>(bg, fg: T): T =
  BEGIN
    LOCK PlttFrnds.con DO
      IF PlttFrnds.con.ops # NIL THEN
        FOR i := 0 TO PlttFrnds.con.nextOp - 1 DO
          TYPECASE PlttFrnds.con.ops[i] OF
            NULL =&gt;              (* skip *)
          | SwapClosure (cl) =&gt;
              IF cl.fg = fg AND cl.bg = bg THEN RETURN T{i} END
          ELSE
          END
        END
      END
    END;
    RETURN Palette.FromOpClosure(NEW(SwapClosure, fg := fg, bg := bg));
  END SwapPair;

PROCEDURE <A NAME="MakeColorScheme"><procedure>MakeColorScheme</procedure></A>(bg, fg: T): ColorScheme RAISES {} =
  VAR res:= NEW(ColorScheme); BEGIN
    res.bg := bg;
    res.fg := fg;
    res.bgFg := Pair(bg, fg);
    res.transparentFg := Pair(Transparent, fg);
    res.swap := SwapPair(bg, fg);
    res.bgTransparent := Pair(bg, Transparent);
    res.bgSwap := Pair(bg, res.swap);
    res.fgBg := Pair(fg, bg);
    res.fgTransparent := Pair(fg, Transparent);
    res.fgSwap := Pair(fg, res.swap);
    res.transparentBg := Pair(Transparent, bg);
    res.transparentSwap := Pair(Transparent, res.swap);
    res.swapBg := Pair(res.swap, bg);
    res.swapFg := Pair(res.swap, fg);
    res.swapTransparent := Pair(res.swap, Transparent);
    RETURN res
  END MakeColorScheme;

PROCEDURE <A NAME="MakeColorQuad"><procedure>MakeColorQuad</procedure></A>(bg, fg: T): ColorQuad RAISES {} =
  VAR res:= NEW(ColorQuad); BEGIN
    res.bg := bg;
    res.fg := fg;
    res.bgFg := Pair(bg, fg);
    res.transparentFg := Pair(Transparent, fg);
    RETURN res
  END MakeColorQuad;

BEGIN
  bgFg := NEW(ColorScheme, bgFg := BgFg, bg := Bg, fg := Fg,
    transparentFg := TransparentFg, swap:= Swap, bgTransparent :=
    BgTransparent, bgSwap := BgSwap, fgBg := FgBg, fgTransparent :=
    FgTransparent, fgSwap := FgSwap, transparentBg := TransparentBg,
    transparentSwap := TransparentSwap, swapBg := SwapBg, swapFg :=
    SwapFg, swapTransparent := SwapTransparent)
END PaintOp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
