<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/PaintPrivate.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/PaintPrivate.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> PaintPrivate.def, by msm &amp; cgn, Wed May  6 16:57:44 1987 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> This interface defines the layout of entries
   in paint batches. 

<P><PRE>INTERFACE <interface><A HREF="PaintPrivate.m3">PaintPrivate</A></interface>;

IMPORT <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Trapezoid.i3">Trapezoid</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

TYPE
  PaintOp = INTEGER;
  Pixmap = INTEGER;
  Font = INTEGER;
</PRE> In a paint batch, <CODE>PaintOps</CODE>, <CODE>Pixmaps</CODE>, and <CODE>Fonts</CODE> are represented
   by integers in a screentype-dependent way.  During rescreening an
   old batch might find its way to a screen of the wrong type, causing
   garbage to be painted; but the garbage will be painted over with 
   the correct pixels promptly.  
  
<P><PRE>TYPE
  PaintCommand = {RepeatCom, TintCom, TextureCom,
    PixmapCom, ScrollCom, TrapCom, TextCom,
    ExtensionCom};
  PackedCommand = PaintCommand;
  FixedSzCommand =
    [PaintCommand.RepeatCom..PaintCommand.TrapCom];
  ByteOrder = {MSBFirst, LSBFirst};
  PackedByteOrder = ByteOrder;

VAR (*CONST*)
  HostByteOrder: ByteOrder;
</PRE> There are eight types of entries; each of which begins with a word 
   containing a <CODE>PaintCommand</CODE> that indicates which type of entry it is.
<P>
   Entries of type <CODE>TintCom</CODE>, <CODE>TextureCom</CODE>, <CODE>PixmapCom</CODE>, <CODE>ScrollCom</CODE>, 
   <CODE>TrapCom</CODE>, and <CODE>TextCom</CODE> are used to implement the <CODE>VBT</CODE> operations
   <CODE>PaintTint</CODE>, <CODE>PaintTexture</CODE>, <CODE>PaintPixmap</CODE>, <CODE>Scroll</CODE>, <CODE>PaintTrapezoid</CODE>,
   and <CODE>PaintText/PaintSub</CODE>.
<P>
   A <CODE>RepeatCom</CODE> entry in a batch indicates that the preceding entry
   is to be re-executed with its clipping rectangle changed to that
   of the <CODE>RepeatCom</CODE> entry.  For example, these are used for
   implementing <CODE>PolyTint</CODE>, <CODE>PolyTexture</CODE>, and <CODE>PaintRegion</CODE>.  There
   are some restrictions on where <CODE>RepeatCom</CODE> entries can occur.
<P>
   <CODE>ExtensionCom</CODE> entries can be used to implement additional painting
   operations beyond those that are built into Trestle. 
<P>
   Some of the entries are fixed size; that is, the size of the entry
   is determined by their type.  The following array gives the sizes
   of the fixed-size commands: 
   
<P><PRE>CONST
  WS = BYTESIZE(Word.T);
  ComSize =
    ARRAY FixedSzCommand OF INTEGER
    {(BYTESIZE(CommandRec) + WS-1) DIV WS,
     (BYTESIZE(TintRec) + WS-1) DIV WS,
     (BYTESIZE(PixmapRec) + WS-1) DIV WS,
     (BYTESIZE(PixmapRec) + WS-1) DIV WS,
     (BYTESIZE(ScrollRec) + WS-1) DIV WS,
     (BYTESIZE(TrapRec) + WS-1) DIV WS};
</PRE> <CODE>ComSize[c]</CODE> equals the size in <CODE>Word.T</CODE>s of a paint batch entry for
   the command <CODE>c</CODE>. 
     
<P><PRE>TYPE
  CommandRec =
    RECORD command: PackedCommand; clip: Rect.T END;
  CommandPtr = UNTRACED REF CommandRec;
  RepeatPtr = CommandPtr;

  (* We define a &quot;Rec&quot; and a &quot;Ptr&quot; type for each kind of batch entry.

     Every batch entry is a ``pseudo-subtype'' of a &quot;Command&quot;, in the
     sense that its record type has &quot;CommandRec&quot; as a prefix.

     A repeat command has no other fields besides the command identifier
     itself and the clipping rectangle.  Hence a &quot;RepeatPtr&quot; is simply
     a pointer to a &quot;CommandRec&quot;.

     All of the batch entries that are not repeat commands contain
     a &quot;PaintOp&quot;.  They are all pseudo-subtypes of the following
     &quot;Rec&quot; and &quot;Ptr&quot; types: *)

  PaintRec = RECORD
    command: PackedCommand;
    clip: Rect.T;
    op: PaintOp
  END;
  PaintPtr = UNTRACED REF PaintRec;
</PRE> The following four entry types correspond to <CODE>PaintTint</CODE>, <CODE>PaintPixmap</CODE>,
   <CODE>Scroll</CODE>, and <CODE>PaintTrapezoid</CODE> operations.  
   
<P>  <PRE>TintRec = RECORD
    command: PackedCommand;
    clip: Rect.T;
    op: PaintOp
  END;
  TintPtr = UNTRACED REF TintRec;

  PixmapRec = RECORD
    command: PackedCommand;
    clip: Rect.T;
    op: PaintOp;
    delta: Point.T;
    pm: Pixmap
  END;
  PixmapPtr = UNTRACED REF PixmapRec;
  TexturePtr = PixmapPtr;

  ScrollRec = RECORD
    command: PackedCommand;
    clip: Rect.T;
    op: PaintOp;
    delta: Point.T;
  END;
  ScrollPtr = UNTRACED REF ScrollRec;
</PRE> It is illegal for a <CODE>ScrollRec</CODE> to be directly followed in a batch
   by a <CODE>Repeat</CODE> command. 

<P>  <PRE>TrapRec = RECORD
    command: PackedCommand;
    clip: Rect.T;
    op: PaintOp;
    delta: Point.T;
    pm: Pixmap;
    p1, p2: Point.T;
    m1, m2: Trapezoid.Rational;
  END;
  TrapPtr = UNTRACED REF TrapRec;
</PRE> If <CODE>tr</CODE> is a <CODE>TrapRec</CODE>, then <CODE>tr.p1</CODE> and <CODE>tr.p2</CODE> are points that
   are on the extensions of the west and east edges of the trapezoid,
   and <CODE>tr.m1</CODE> and <CODE>tr.m2</CODE> are the slopes of the west and east edges.
   The slopes are given as <CODE>(delta v) / (delta h)</CODE>.  A zero denominator
   represents an infinite slope; i.e., a vertical edge.  A zero
   numerator is illegal.  
       
<P> The entries that are not fixed-size are pseudo-subtypes of
   <CODE>VarSzRec</CODE>, which contains a <CODE>size</CODE> field with the number of
   <CODE>Word.T</CODE>'s in the entire entry.  
 
<P>  <PRE>VarSzRec = RECORD
    command: PackedCommand;
    clip: Rect.T;
    op: PaintOp;
    szOfRec: INTEGER;
  END;
  VarSzPtr = UNTRACED REF VarSzRec;
</PRE> <CODE>PaintText</CODE> and <CODE>PaintSub</CODE> operations result in the following entry 
   type, in which <CODE>command</CODE> will equal <CODE>TextCom</CODE>: 

<P><PRE>TYPE Prop = {Clipped, FontSub};
     Props = SET OF Prop;

  TextRec = RECORD
    command: PackedCommand;
    clip: Rect.T;
    op: PaintOp;
    szOfRec: INTEGER;
    byteOrder: PackedByteOrder;
    props: Props;
    refpt: Point.T;
    fnt: Font;
    txtsz, dlsz: INTEGER;
</PRE><P>
<PRE>
      (* dl: ARRAY [0..dlsz-1] OF VBT.Displacement 
 
<PRE>| (* chars: ARRAY [0..txtsz-1] OF CHAR *)
*)

  END;
  TextPtr = UNTRACED REF TextRec;
</PRE> In a <CODE>TextRec</CODE>, <CODE>Prop.Clipped</CODE> must be in <CODE>props</CODE> if the bounding box of
   <CODE>Text.FromChars(chars)</CODE> painted at <CODE>refpt</CODE> in the font <CODE>fnt</CODE> is not a
   subset of <CODE>clip</CODE>. A <CODE>TextRec</CODE> can be directly followed in a batch by a
   <CODE>Repeat</CODE> only if <CODE>Prop.Clipped</CODE> is present. <CODE>Prop.FontSub</CODE> is in <CODE>props</CODE>
   implies that the bounding box that must be cleared before painting is not
   the natural bounding box for the font.  The <CODE>dl</CODE> and <CODE>chars</CODE> fields are
   declared in comments since Modula-3 does not allow a record to contain a
   variable-sized array; they must be accessed using address arithmetic. The
   <CODE>chars</CODE> field will be padded out so that the <CODE>TextRec</CODE> ends on a word
   boundary. 

<P> The <CODE>byteOrder</CODE> field defines the byteorder of the characters.  (Since
   paint batches can be transported across address spaces and merged,
   the byte order could be different for different records in a paint
   batch.) 
   
<P>  <PRE>ExtensionRec = RECORD
    command: PackedCommand;
    clip: Rect.T;
    op: PaintOp;
    szOfRec: INTEGER;
    delta: Point.T;
    pm: Pixmap;
    fnt: Font;
    subCommand: INTEGER;
</PRE><P>
<PRE>
      (* extensionData: ARRAY OF CHAR 

<PRE>*)

  END;
  ExtensionPtr = UNTRACED REF ExtensionRec;
</PRE> An <CODE>ExtensionRec</CODE> can be used to implement painting operations that
   exploit rendering primitives that may be available on some particular
   implementation.  Extension commands get a <CODE>PaintOp</CODE>, a <CODE>delta</CODE>, a <CODE>pm</CODE>,
   and a <CODE>fnt</CODE> ``for free''; they can also put whatever data they need
   into the rest of the extension data part of the record.  The field
   <CODE>szOfRec</CODE> is the number of <CODE>Word.Ts</CODE> in the extension record,
   including the extension data.  When an <CODE>ExtensionRec</CODE> is translated,
   it's <CODE>clip</CODE> and <CODE>delta</CODE> fields are translated automatically; its
   extension data is unaffected.  

<P><PRE>PROCEDURE <A HREF="PaintPrivate.m3#CommandLength">CommandLength</A>(p: CommandPtr): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the length in words of the command entry <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>

END PaintPrivate.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
