<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/Palette.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/Palette.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           

<P><PRE>&lt;*PRAGMA LL*&gt;
</PRE> The <CODE>Palette</CODE> interface allows you to implement your own
   screen-independent resources by registering a closure to
   produce an appropriate screen-dependent resource for any given 
   screentype.  

<P><PRE>INTERFACE <interface><A HREF="Palette.m3">Palette</A></interface>;

IMPORT <A HREF="VBT.i3">VBT</A>, <A HREF="PaintOp.i3">PaintOp</A>, <A HREF="Cursor.i3">Cursor</A>, <A HREF="Pixmap.i3">Pixmap</A>, <A HREF="Font.i3">Font</A>,
  <A HREF="ScrnPaintOp.i3">ScrnPaintOp</A>, <A HREF="ScrnCursor.i3">ScrnCursor</A>, <A HREF="ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="ScrnFont.i3">ScrnFont</A>;
</PRE> Translating a screen-independent resource into its screen-dependent
   form is called {\it resolving} the resource.  Here are the closure 
   types for resolving resources: 

<P><PRE>TYPE
  OpClosure = OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    apply(st: VBT.ScreenType): ScrnPaintOp.T;
  END;

  CursorClosure = OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    apply(st: VBT.ScreenType): ScrnCursor.T;
  END;

  PixmapClosure = OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    apply(st: VBT.ScreenType): ScrnPixmap.T;
  END;

  FontClosure = OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    apply(st: VBT.ScreenType): ScrnFont.T;
  END;
</PRE> When an <CODE>apply</CODE> method is called, <CODE>st # NIL</CODE>.
  If the method returns <CODE>NIL</CODE>, then some default screen-dependent
  resource will be used; for example, the built-in font or the
  transparent painting operation.
<P>
  The following procedures produce screen-independent resources
  from closures: 
   
<P><PRE>PROCEDURE <A HREF="Palette.m3#FromOpClosure">FromOpClosure</A>(cl: OpClosure): PaintOp.T;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>PaintOp.T</CODE> that behaves like <CODE>cl.apply(st)</CODE> on <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Palette.m3#FromCursorClosure">FromCursorClosure</A>
  (cl: CursorClosure): Cursor.T; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>Cursor.T</CODE> that behaves like <CODE>cl.apply(st)</CODE> on <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Palette.m3#FromPixmapClosure">FromPixmapClosure</A>
  (cl: PixmapClosure): Pixmap.T; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>Pixmap.T</CODE> that behaves like <CODE>cl.apply(st)</CODE> on <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Palette.m3#FromFontClosure">FromFontClosure</A>(cl: FontClosure): Font.T;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>Font.T</CODE> that behaves like <CODE>cl.apply(st)</CODE> on <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If your apply method that resolves a resource needs to resolve some
   other resource, you should use one of the following procedures to
   do so.  In all cases, <CODE>st</CODE> must be non-<CODE>NIL</CODE>. 
   
<P><PRE>PROCEDURE <A HREF="Palette.m3#ResolveOp">ResolveOp</A>(st: VBT.ScreenType; op: PaintOp.T)
  : ScrnPaintOp.T;
</PRE><BLOCKQUOTE><EM> Resolve <CODE>op</CODE> for <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Palette.m3#ResolveCursor">ResolveCursor</A>(st: VBT.ScreenType;
  cursor: Cursor.T): ScrnCursor.T;
</PRE><BLOCKQUOTE><EM> Resolve <CODE>cursor</CODE> for <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Palette.m3#ResolvePixmap">ResolvePixmap</A>(st: VBT.ScreenType;
  pixmap: Pixmap.T): ScrnPixmap.T;
</PRE><BLOCKQUOTE><EM> Resolve <CODE>pixmap</CODE> for <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Palette.m3#ResolveFont">ResolveFont</A>(st: VBT.ScreenType; font: Font.T)
  : ScrnFont.T;
</PRE><BLOCKQUOTE><EM> Resolve <CODE>font</CODE> for <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If you create a cycle of screen-independent resources each of which 
   tries to resolve the next resource in the cycle, then the program 
   will deadlock. 
<P>
   To implement screen-independent resources, every screentype includes
   a {\it palette}, which is a table of screen-dependent resources
   appropriate for that screentype.  Most clients don't need to worry
   about the palette, but if you are implementing a <CODE>VBT</CODE> class that
   translates to some other window system---like X or Microsoft
   Windows---here is the procedure for building the palette in the
   screentype for a top-level window: \index{palette}

<P><PRE>PROCEDURE <A HREF="Palette.m3#Init">Init</A>(st: VBT.ScreenType);
&lt;* LL.sup = VBT.mu.v *&gt;
</PRE><BLOCKQUOTE><EM> Initialize <CODE>st</CODE>'s palette, if it is not already initialized,
   by resolving all screen-independent resources for <CODE>st</CODE> and
   storing the results.  </EM></BLOCKQUOTE><PRE>

END Palette.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
