<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/Pixmap.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/Pixmap.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>Pixmap.T</CODE> is a screen-independent specification of a pixmap.  
   Many procedures interpret <CODE>Pixmap.Ts</CODE> as textures, by tiling the
   plane with translated copies of the pixmap. There are three
   predefined pixmaps:
<P>
   The locking level is <CODE>LL.sup &lt;= VBT.mu</CODE> for all of the procedures
   in this interface. 

<P><PRE>INTERFACE <interface><A HREF="Pixmap.m3">Pixmap</A></interface>;

TYPE T = RECORD pm: INTEGER END; Predefined = [0..2];

CONST
  Solid = T{0};
  Empty = T{1};
  Gray = T{2};
</PRE> <CODE>Solid</CODE> represents a pixmap of all ones. 
   <CODE>Empty</CODE> represents a pixmap of all zeros. 
   <CODE>Gray</CODE> represents a checkerboard of ones and zeros. 
   <P>
   The domains of these pixmaps may vary from screentype to
   screentype, but they will always be non-empty.
   <P>
   When used on a screentype <CODE>st</CODE>, they will have type <CODE>st.bits</CODE>
   (see the <CODE>PaintOp</CODE> interface). 

<P><PRE>TYPE <A HREF="ScrnPixmap.m3#Raw">Raw</A> &lt;: ROOT;
</PRE> A <CODE>Pixmap.Raw</CODE> represents a pixmap as a packed array of
   pixels.  The <CODE>ScrnPixmap</CODE> interface reveals the representation. 

<P><PRE>PROCEDURE <A HREF="Pixmap.m3#FromBitmap">FromBitmap</A>(bits: Raw): T;
</PRE><BLOCKQUOTE><EM> Return a pixmap that looks like <CODE>bits</CODE> on all screens. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>FromBitmap</CODE> causes a checked runtime error if the depth of 
   <CODE>bits</CODE> is not one.  On a screentype <CODE>st</CODE>, it will have type
   <CODE>st.bits</CODE>. 

<P><PRE>END Pixmap.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
