<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/Pixmap.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/Pixmap.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="Pixmap.i3">Pixmap</A></implements></module>;

IMPORT <A HREF="Palette.i3">Palette</A>, <A HREF="PlttFrnds.i3">PlttFrnds</A>, <A HREF="ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="ScreenType.i3">ScreenType</A>, <A HREF="TrestleComm.i3">TrestleComm</A>;

PROCEDURE <A NAME="FromBitmap"><procedure>FromBitmap</procedure></A> (bits: Raw): T =
  BEGIN
    IF bits.depth # 1 THEN Crash() END;
    LOCK PlttFrnds.con DO
      IF PlttFrnds.con.pixmaps # NIL THEN
        FOR i := 0 TO PlttFrnds.con.nextPixmap - 1 DO
          TYPECASE PlttFrnds.con.pixmaps[i] OF
            NULL =&gt;
          | Closure (cl) =&gt; IF cl.bits = bits THEN RETURN T{i} END
          ELSE
          END
        END
      END
    END;
    RETURN Palette.FromPixmapClosure(NEW(Closure, bits := bits))
  END FromBitmap;

TYPE Closure = Palette.PixmapClosure OBJECT
    bits: Raw;
  OVERRIDES
    apply := Apply
  END;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A>(cl: Closure; st: ScreenType.T): ScrnPixmap.T =
  BEGIN
    TRY
      RETURN st.pixmap.load(cl.bits)
    EXCEPT
      TrestleComm.Failure =&gt; RETURN Palette.ResolvePixmap(st, Solid)
    END
  END Apply;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;*FATAL FatalError*&gt;
  BEGIN
    RAISE FatalError
  END Crash;

BEGIN END Pixmap.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
