<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/RingBuffer.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/RingBuffer.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

GENERIC MODULE <genericModule><A HREF="RingBuffer.i3">RingBuffer</A></genericModule>(Elem);

CONST NormalQSize = Elem.QueueSize;

&lt;*INLINE*&gt; PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A>(READONLY rb: T): BOOLEAN =
  BEGIN RETURN rb.lo = rb.hi END IsEmpty;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A>(VAR rb: T; READONLY e: Elem.T) =
  BEGIN
    IF rb.buff = NIL THEN
       rb.buff := NEW(REF ARRAY OF Elem.T, NormalQSize)
    END;
    rb.buff[rb.hi] := e;
    INC(rb.hi);
    WITH n = NUMBER(rb.buff^) DO
      IF rb.hi = n THEN rb.hi := 0 END;
      IF rb.hi = rb.lo THEN
        WITH new = NEW(REF ARRAY OF Elem.T, 2 * n) DO
          FOR i := rb.lo TO n - 1 DO
            new[i] := rb.buff[i]
          END;
          FOR i := 0 TO rb.hi-1 DO
            new[i+n] := rb.buff[i]
          END;
          INC(rb.hi, n);
          rb.buff := new
        END
      END
    END
  END Insert;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A>(VAR rb: T): Elem.T RAISES {Exhausted} =
  VAR res: Elem.T;
  BEGIN
    IF rb.lo = rb.hi THEN RAISE Exhausted END;
    res := rb.buff[rb.lo];
    WITH n = NUMBER(rb.buff^) DO
      INC(rb.lo);
      IF rb.lo = n THEN rb.lo := 0 END;
      IF (rb.lo = rb.hi) AND (n &gt; NormalQSize) THEN rb := Empty END
    END;
    RETURN res
  END Remove;

PROCEDURE <A NAME="Peek"><procedure>Peek</procedure></A>(VAR rb: T): Elem.T RAISES {Exhausted} =
  BEGIN
    IF rb.lo = rb.hi THEN RAISE Exhausted END;
    RETURN rb.buff[rb.lo];
  END Peek;

BEGIN END RingBuffer.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
