<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/ScreenPaint.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/ScreenPaint.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE INTERFACE <interface>ScreenPaint</interface>;
</PRE> The following painting procedures are like the corresponding 
   procedures in VBT, except that (1) they use screen-dependent 
   resources rather than screen-independent resources, and (2) it is 
   an unchecked runtime error to call them without locking the VBT. 
<P>
   If the pixmap or paintop supplied for an operation is not suitable 
   for the VBT's screentype, the effect is undefined, but limited to 
   the clipping region.  The NIL source represents a bitmap of solid 
   1's. 
   <P>
   In all cases, LL = v. 

<P><PRE>IMPORT <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="ScrnPaintOp.i3">ScrnPaintOp</A>, <A HREF="ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="ScrnFont.i3">ScrnFont</A>,
<A HREF="VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Path.i3">Path</A>, <A HREF="../../../geometry/src/Trapezoid.i3">Trapezoid</A>;

PROCEDURE PaintTexture(
    v: VBT.T;
    READONLY clip: Rect.T;
    op: ScrnPaintOp.T;
    src: ScrnPixmap.T := NIL;
    READONLY delta: Point.T := Point.Origin);

PROCEDURE PaintTint(
    v: VBT.T;
    READONLY clip: Rect.T;
    op: ScrnPaintOp.T);
</PRE><BLOCKQUOTE><EM> Like PaintTexture with a source of depth 1 that is all 1's. </EM></BLOCKQUOTE><PRE>

PROCEDURE PolyTint(
    v: VBT.T;
    READONLY clp: ARRAY OF Rect.T;
    op: ScrnPaintOp.T);

PROCEDURE PolyTexture(
    v: VBT.T;
    READONLY clp: ARRAY OF Rect.T;
    op: ScrnPaintOp.T;
    src: ScrnPixmap.T := NIL;
    READONLY delta: Point.T := Point.Origin);

PROCEDURE PaintRegion(
    v: VBT.T;
    READONLY rgn: Region.T;
    op: ScrnPaintOp.T;
    src: ScrnPixmap.T := NIL;
    READONLY delta: Point.T := Point.Origin);

PROCEDURE PaintPixmap(
    v: VBT.T;
    READONLY clip: Rect.T;
    op: ScrnPaintOp.T;
    src: ScrnPixmap.T;
    READONLY delta: Point.T);

PROCEDURE PaintText(
    v: VBT.T;
    READONLY clip: Rect.T;
    READONLY pt: Point.T;
    fnt: ScrnFont.T;
    t: TEXT;
    op: ScrnPaintOp.T;
    dl: VBT.DisplacementList := NIL);

PROCEDURE PaintSub(
    v: VBT.T;
    READONLY clip: Rect.T;
    READONLY pt: Point.T;
    fnt: ScrnFont.T;
    READONLY chars: ARRAY OF CHAR;
    op: ScrnPaintOp.T;
    dl: VBT.DisplacementList := NIL);

PROCEDURE PaintPatch(
    v: VBT.T;
    READONLY clip: Rect.T;
    hl, hr, vlo, vhi, start: INTEGER;
    READONLY deltaArray: ARRAY OF VBT.DeltaPair;
    op: ScrnPaintOp.T;
    src: ScrnPixmap.T := NIL;
    READONLY delta: Point.T := Point.Origin);

PROCEDURE Scroll(
    v: VBT.T;
    READONLY clip: Rect.T;
    READONLY delta: Point.T;
    op: ScrnPaintOp.T);

PROCEDURE Fill(
    v: VBT.T;
    READONLY clip: Rect.T;
    path: Path.T;
    wind: VBT.WindingCondition;
    op: ScrnPaintOp.T;
    src: ScrnPixmap.T := NIL;
    READONLY delta: Point.T := Point.Origin);

PROCEDURE Stroke(
    v: VBT.T;
    READONLY clip: Rect.T;
    path: Path.T;
    width: INTEGER := 1;
    end := VBT.EndStyle.RoundEnd;
    join := VBT.JoinStyle.RoundJoin;
    op: ScrnPaintOp.T;
    src: ScrnPixmap.T := NIL;
    READONLY delta: Point.T := Point.Origin);

PROCEDURE PaintTrapezoid(
    v: VBT.T;
    READONLY clip: Rect.T;
    READONLY trap: Trapezoid.T;
    op: ScrnPaintOp.T;
    src: ScrnPixmap.T := NIL;
    READONLY delta: Point.T := Point.Origin);

END ScreenPaint.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
