<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/ScreenType.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/ScreenType.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>ScreenType.T</CODE> represents a class of screens that have a common
   pixel depth, a common set of operations on the pixels, and common
   repositories for cursors, pixmaps, and fonts.  
   <P>
   When the screentype of a <CODE>VBT</CODE> changes, any screen-dependent
   resources for the old screentype become useless.  The application
   must use the new screentype's {\it oracles} to look up resources
   that are valid for the new screentype.  This is all handled
   automatically if you use screen-independent resources that are
   predefined or defined by somebody else.  But you will need to use
   this interface if you are implementing your own screen-independent
   resources.  

<P><PRE>INTERFACE <interface><A HREF="ScreenType.m3">ScreenType</A></interface>;

IMPORT <A HREF="ScrnCursor.i3">ScrnCursor</A>, <A HREF="VBT.i3">VBT</A>, <A HREF="ScrnColorMap.i3">ScrnColorMap</A>, <A HREF="ScrnFont.i3">ScrnFont</A>,
  <A HREF="ScrnPaintOp.i3">ScrnPaintOp</A>, <A HREF="ScrnPixmap.i3">ScrnPixmap</A>;

TYPE T = VBT.ScreenType;

REVEAL VBT.ScreenType &lt;: Public;

TYPE
  Public = VBT.ScreenTypePublic OBJECT (*CONST*)
    bg, fg: ScrnPaintOp.Pixel;
    bits: T;
    op: ScrnPaintOp.Oracle;
    cursor: ScrnCursor.Oracle;
    pixmap: ScrnPixmap.Oracle;
    font: ScrnFont.Oracle;
    cmap: ScrnColorMap.Oracle;
  END;
</PRE> For a screentype <CODE>st</CODE>, the values <CODE>st.bg</CODE> and <CODE>st.fg</CODE> are the pixel
   values that represent the user's default background and foreground
   colors on <CODE>st</CODE>. If the screen is color-mapped, these are appropriate
   for the default colormap.  For applications doing simple painting,
   <CODE>bg</CODE> is logical white and <CODE>fg</CODE> is logical black.  Depending on the
   screen and user preferences, the actual colors that the user sees
   might be different.
<P>
   The screentype <CODE>st.bits</CODE> is the screentype for 1-bit deep pixmap
   sources for painting on screens of type <CODE>st</CODE>. It is guaranteed that
   <CODE>st.bits.bits=st.bits</CODE>, <CODE>st.bits.fg=1</CODE>, and <CODE>st.bits.bg=0</CODE>.
<P>
   The oracles <CODE>st.op</CODE>, <CODE>st.font</CODE>, <CODE>st.cursor</CODE>, and <CODE>st.pixmap</CODE>
   contains methods that provide screen-dependent resources appropriate
   for <CODE>st</CODE>---for example, <CODE>st.font</CODE> has a method that will look up 
   fonts by name.
<P>
   If <CODE>st.cmap # NIL</CODE>, <CODE>st</CODE> is a color-mapped screen, which means that
   the color of a pixel is determined by looking up its value in a
   table.  The color map can be either readonly or writable. 

<P><PRE>END ScreenType.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
