<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/ScrnColorMap.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/ScrnColorMap.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>ScrnColorMap.T</CODE> is a handle on a colormap that is valid for some
   particular screentype, called the {\it owner} of the handle. Some
   handles have names; others are anonymous.  A named handle is valid
   forever.  The colormap referenced by an anonymous handle will be
   garbage-collected when all handles to it have been dropped. 
<P>
   Every colormap has a {\it depth}; the pixel values defined by the
   color map are in the range <CODE>[0..(2^depth)-1]</CODE>.  Every color-mapped
   screentype defines a set of {\it preferred} colors that cover the
   spectrum reasonably densely.  Some preferred colors are designated
   as {\it stable}.
   <P>
   Clients can allocate pixels out of a color map as read-only shared
   entries or as writable exclusive entries.  The implementation
   maintains reference counts on the read-only entries so that an entry
   can be freed when it is no longer allocated to any client. 

<P><PRE>INTERFACE <interface><A HREF="ScrnColorMap.m3">ScrnColorMap</A></interface>;

IMPORT <A HREF="TrestleComm.i3">TrestleComm</A>;
</PRE> \subsubsection{Obtaining handles from the oracle} 

<P><PRE>TYPE
  Oracle = Private OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      standard(): T RAISES {TrestleComm.Failure};
      new(name: TEXT := NIL; preLoaded := TRUE): T
        RAISES {TrestleComm.Failure, Failure};
      lookup(name: TEXT): T
        RAISES {TrestleComm.Failure};
      list(pat: TEXT; maxResults: CARDINAL := 1)
        : REF ARRAY OF TEXT RAISES {TrestleComm.Failure}
    END;
  <A HREF="ScrnColorMap.m3#Private">Private</A> &lt;: ROOT;

EXCEPTION Failure;
</PRE> Every color-mapped screentype <CODE>st</CODE> contains a field <CODE>st.cmap</CODE> of
   type <CODE>Oracle</CODE>, which hands out colormaps owned by <CODE>st</CODE>:
<P>
   The method call 
<P>
<PRE>
      st.cmap.standard()
</PRE>
   returns the default colormap owned by <CODE>st</CODE>. This is the colormap
   that a top-level window will initially have when it is rescreened
   to <CODE>st</CODE>. Initially, the stable colors are allocated read-only with
   a reference count of one.
    <P>
   The method call 
   <P>
<PRE>
      st.cmap.new(name, preLoaded)
</PRE>
   creates and returns a new colormap owned by <CODE>st</CODE> with the given name.
   If <CODE>preLoaded</CODE> is true, the stable colors are initially allocated
   read-only; otherwise nothing is allocated initially.
<P>
   The method call 
   <P>
<PRE>
      st.cmap.lookup(name)
</PRE>
   returns the colormap owned by <CODE>st</CODE> with the given name, or <CODE>NIL</CODE>
   if no colormap has this name.
   <P>
   The method call 
   <P>
<PRE>
      st.cmap.list(pat, maxResults)
</PRE>
   returns the names of colormaps owned by <CODE>st</CODE> that match the pattern
   <CODE>pat</CODE>.  The list of results may be truncated to length <CODE>maxResults</CODE>.
   A <CODE>*</CODE> matches any number of characters and a <CODE>?</CODE> matches any single
   character. 
   
<P> \subsubsection{The handle object} 
   
<P><PRE>TYPE
  <A HREF="ScrnColorMap.m3#T">T</A> &lt;: Public;
  Public = OBJECT (*CONST*)
      depth: INTEGER;
      readOnly: BOOLEAN;
      ramp: Ramp;
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      fromRGB(rgb: RGB; mode := Mode.Normal): Pixel
        RAISES {Failure, TrestleComm.Failure};
      read(VAR res: ARRAY OF Entry)
        RAISES {TrestleComm.Failure};
      write(READONLY new: ARRAY OF Entry)
        RAISES {Failure, TrestleComm.Failure};
      new(dim: CARDINAL): Cube RAISES
        {Failure, TrestleComm.Failure};
      free(READONLY cb: Cube)
        RAISES {TrestleComm.Failure};
    END;
  Mode = {Stable, Normal, Accurate};
  Ramp = RECORD
    base: INTEGER;
    last, mult: ARRAY Primary OF INTEGER;
  END;
  Primary = {Red, Green, Blue};
  Cube = RECORD lo, hi: Pixel END;
  Pixel = INTEGER;
  RGB = RECORD r, g, b: REAL END;
  Entry = RECORD pix: Pixel; rgb: RGB END;
</PRE> The field <CODE>cm.depth</CODE> is the depth of <CODE>cm</CODE>, and <CODE>cm.readOnly</CODE> is
   <CODE>TRUE</CODE> if <CODE>cm</CODE> cannot be written.  The field <CODE>cm.ramp</CODE> defines
   a three dimensional lattice of colors preallocated in <CODE>cm</CODE>,
   as follows.
<P>
   If <CODE>cm.ramp.base</CODE> is <CODE>-1</CODE>, the lattice of preallocated colors is empty.
<P>
   If <CODE>cm.ramp.base</CODE> is not <CODE>-1</CODE>, then the pixel value
<P>
<PRE>
      base + r*mult[Red] + g*mult[Green] + b*mult[Blue]
</PRE>
   represents the color <CODE>(r/last[Red], g/last[Green], b/last[Blue])</CODE>, for <CODE>r</CODE>
   in the range <CODE>[0..last[Red]]</CODE>, <CODE>g</CODE> in the range <CODE>[0..last[Green]]</CODE>, and
   <CODE>b</CODE> in the range <CODE>[0..last[Blue]]</CODE>.  
    <P>
   \medskip An <CODE>RGB</CODE> represents the color with the given blend of red,
   green, and blue.  Each of the numbers is in the range <CODE>[0.0..1.0]</CODE>;
   thus the triple <CODE>(0.0, 0.0, 0.0)</CODE> specifies black.  In case of a gray scale
   display, only the <CODE>r</CODE> component is relevant.
   <P>
   The method call 
   <P>
<PRE>
      cm.fromRGB(rgb, mode)
</PRE>
   extends the read-only portion of <CODE>cm</CODE> with a new entry whose value
   is near <CODE>rgb</CODE> and returns the pixel of the new entry.  If the
   read-only portion of <CODE>cm</CODE> already contains an entry whose value is
   near <CODE>rgb</CODE>, that entry's pixel is returned.  The <CODE>mode</CODE> argument
   controls how near the new entry's value will be to <CODE>rgb</CODE>, as follows.
   If <CODE>mode</CODE> is <CODE>Stable</CODE>, the new entry's color is the nearest stable
   color to <CODE>rgb</CODE>.  If <CODE>mode</CODE> is <CODE>Normal</CODE>, the new entry's color is
   the nearest preferred color to <CODE>rgb</CODE>.  If <CODE>mode</CODE> is <CODE>Accurate</CODE>, the
   new entry's color is the nearest color to <CODE>rgb</CODE> that the hardware
   supports.  The method raises <CODE>Failure</CODE> if a new entry is
   required but the colormap is full.
<P>
   For each entry <CODE>e</CODE> in the array <CODE>res</CODE>, the method call 
   <P>
<PRE>
      cm.read(res)
</PRE>
   sets <CODE>e.rgb</CODE> to the color in <CODE>cm</CODE> of the pixel <CODE>e.pixel</CODE>. 
<P>
   The method call 
   <P>
<PRE>
      cm.write(new)
</PRE>
   changes the value of <CODE>cm</CODE> at <CODE>p</CODE> to be <CODE>rgb</CODE>, for each pair <CODE>(p, rgb)</CODE>
   in the array <CODE>new</CODE>, assuming all these pixels are writable.  Otherwise
   the method raises <CODE>Failure</CODE>.  The array <CODE>new</CODE> must be sorted.
   <P>
   The method call 
   <P>
<PRE>
      cm.new(dim)
</PRE>
   extends the writable portion of <CODE>cm</CODE> with a set of $2^{<CODE>dim</CODE>}$ new
   entries whose pixels form a cube, and returns the cube.  The method
   raises <CODE>Failure</CODE> if the free entries of the colormap do not contain
   a cube of the given dimension.
<P>
   A <CODE>Cube</CODE> <CODE>cb</CODE> represents a set of pixels by the following rule:
   a pixel <CODE>p</CODE> is in <CODE>cb</CODE> if <CODE>Word.And(lo, pix) = lo</CODE> and 
   <CODE>Word.Or(hi, pix) = hi</CODE>. 
<P>
   The method call <CODE>cm.free(cb)</CODE> deallocates from the writable portion
   of <CODE>cm</CODE> each entry whose pixel is in the cube <CODE>cb</CODE>, assuming all
   of these pixels are allocated. 

<P><PRE>END ScrnColorMap.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
