<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/ScrnCursor.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/ScrnCursor.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           

<P><PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>ScrnCursor.T</CODE> is a handle on a cursor shape that is valid for some
   particular screentype, called the {\it owner} of the handle.  Some
   handles have names; others are anonymous.  A named handle is valid
   forever.  The cursor referenced by an anonymous handle will be
   garbage-collected when all handles to it have been dropped.  

<P><PRE>INTERFACE <interface><A HREF="ScrnCursor.m3">ScrnCursor</A></interface>;

IMPORT <A HREF="TrestleComm.i3">TrestleComm</A>, <A HREF="Cursor.i3">Cursor</A>;

EXCEPTION Failure;

VAR DontCare: T;

TYPE Raw = Cursor.Raw;
</PRE> See the <CODE>Cursor</CODE> interface for the raw representation of a cursor 
   shape as a pair of bitmaps, color information, and hotspot offset.
<P>
\subsubsection{Obtaining handles from the oracle} 

<P><PRE>TYPE
  Oracle = Private OBJECT (*CONST*)
    width, height: INTEGER;
  METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    load(READONLY r: Raw; nm: TEXT := NIL): T
      RAISES {TrestleComm.Failure};
    list(pat: TEXT; maxResults: CARDINAL := 1)
      : REF ARRAY OF TEXT
      RAISES {TrestleComm.Failure};
    lookup(name: TEXT): T RAISES {TrestleComm.Failure};
    builtIn(cs: Cursor.Predefined): T;
  END;
  <A HREF="ScrnCursor.m3#Private">Private</A> &lt;: ROOT;
</PRE> For a screentype <CODE>st</CODE>, the field <CODE>st.cursor</CODE> is an <CODE>Oracle</CODE> that
   produces cursors owned by <CODE>st</CODE>:
<P>
   The integers <CODE>st.cursor.width</CODE> and <CODE>st.cursor.height</CODE> are the 
   dimensions in pixels of the largest cursor image that the screentype <CODE>st</CODE> 
   supports. Larger images will be cropped; smaller images will be padded.
   <P>
   The method call 
<P>
<PRE>
      st.cursor.load(r, nm)
</PRE>
   allocates and returns a cursor handle <CODE>c</CODE> owned by <CODE>st</CODE> whose
   contents are equal to <CODE>r</CODE>.  If <CODE>nm # NIL</CODE>, <CODE>c</CODE> receives the name
   <CODE>nm</CODE>, and any cursor handle owned by <CODE>st</CODE> that previously had the
   name <CODE>nm</CODE> becomes anonymous.
<P>
   The method call 
<P>
<PRE>
      st.cursor.list(pat, maxResults)
</PRE>
   returns the names of all cursors owned by <CODE>st</CODE> that match the pattern
   <CODE>pat</CODE>.  The list of results may be truncated to length <CODE>maxResults</CODE>.
   A <CODE>*</CODE> matches any number of characters and a <CODE>?</CODE> matches a single
   character.
<P>
   The method call 
   <P>
<PRE>
      st.cursor.lookup(name)
</PRE>
   return the cursor handle owned by <CODE>st</CODE> with the given name, or <CODE>NIL</CODE>
   if no cursor has this name.
<P>
   The method call
<P>
<PRE>
      st.cursor.builtIn(cs)
</PRE>
   returns the screen-dependent cursor valid for <CODE>st</CODE> that corresponds
   to the predefined screen-independent cursor <CODE>Cursor.T{cs}</CODE> .
   <P>
   The locking level for all methods is <CODE>LL.sup &lt;= VBT.mu</CODE>. 

<P> \subsubsection{The handle object} 

<P><PRE>TYPE
  <A HREF="ScrnCursor.m3#T">T</A> &lt;: Public;
  Public = OBJECT (*CONST*)
    id: INTEGER
  METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    localize(): Raw
      RAISES {TrestleComm.Failure, Failure};
    unload() RAISES {TrestleComm.Failure};
  END;
</PRE> If <CODE>cs</CODE> is a <CODE>ScrnCursor.T</CODE>, then <CODE>cs.id</CODE> is an identifier whose
    interpretation depends on the screentype that owns <CODE>cs</CODE>.  The method
    call <CODE>cs.localize()</CODE> returns a raw cursor equal to the one on which
    <CODE>cs</CODE> is a handle, and the method call <CODE>cs.unload()</CODE> causes <CODE>cs</CODE>
    to become anonymous.  

<P><PRE>END ScrnCursor.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
