<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/ScrnFont.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/ScrnFont.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>ScrnFont.T</CODE> is a handle on a typeface that is valid for some
   particular screentype, called the {\it owner} of the handle.  All 
   handles have names, which are highly conventionalized strings
   encoding the size, style, and other properties of the typeface. 
   
<P><PRE>INTERFACE <interface><A HREF="ScrnFont.m3">ScrnFont</A></interface>;

IMPORT <A HREF="ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="TrestleComm.i3">TrestleComm</A>, <A HREF="Font.i3">Font</A>, <A HREF="../../../fingerprint/src/Fingerprint.i3">Fingerprint</A>;

EXCEPTION Failure;
</PRE> \subsubsection{Obtaining handles from the oracle} 

<P><PRE>TYPE
  Oracle = Private OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      list(pat: TEXT; maxResults := 1):
        REF ARRAY OF TEXT RAISES {TrestleComm.Failure};
      match(
        family: TEXT;
        pointSize: INTEGER := 120;
        slant: Slant := Slant.Roman;
        maxResults: CARDINAL := 1;
        weightName: TEXT := AnyMatch;
        version: TEXT := &quot;&quot;;
        foundry: TEXT := AnyMatch;
        width: TEXT := AnyMatch;
        pixelsize: INTEGER := AnyValue;
        hres, vres: INTEGER := ScreenTypeResolution;
        spacing: Spacing := Spacing.Any;
        averageWidth: INTEGER := AnyValue;
        charsetRegistry: TEXT := &quot;ISO8859&quot;;
        charsetEncoding: TEXT := &quot;1&quot;)
      : REF ARRAY OF TEXT RAISES {TrestleComm.Failure};
      lookup(name: TEXT): T
        RAISES {Failure, TrestleComm.Failure};
      builtIn(f: Font.Predefined): T;
    END;
    <A HREF="ScrnFont.m3#Private">Private</A> &lt;: ROOT;
</PRE> For a screentype <CODE>st</CODE>, the field <CODE>st.font</CODE> is an <CODE>Oracle</CODE> that
   produces font handles owned by <CODE>st</CODE>.
<P>
   The method call
<P>
<PRE>
      st.font.list(pat, maxResults)
</PRE>
   returns the names of all fonts owned by <CODE>st</CODE> that match the pattern
   <CODE>pat</CODE>.  The list of results may be truncated to length <CODE>maxResults</CODE>.
   A <CODE>*</CODE> matches any number of characters and a <CODE>?</CODE> matches a single
   character.
<P>
   The arguments to the <CODE>match</CODE> method specify various font attributes,
   as explained below.  The method call 
   <P>
<PRE>
      st.font.match(...)
</PRE>
   returns the names of all font handles owned by <CODE>st</CODE> that match the
   specifications.  The list of results may be truncated to the length
   <CODE>maxResults</CODE>.  If no fonts match the specifications, the result will
   be either <CODE>NIL</CODE> or an empty array.  Passing <CODE>AnyMatch</CODE> for a text
   attribute, or <CODE>AnyValue</CODE> for an integer attribute, allows any value
   for that attribute.  For text attributes, partial text matches are
   also possible: a <CODE>*</CODE> matches any number of characters and <CODE>?</CODE> matches
   a single character.
<P>
   The method call 
   <P>
<PRE>
      st.font.lookup(name)
</PRE>
   returns the font handle owned by <CODE>st</CODE> with the given name.  Generally
   <CODE>name</CODE> should be one of the names returned by the <CODE>list</CODE> or
   <CODE>match</CODE> method.
<P>
   The method call 
   <P>
<PRE>
      st.font.builtIn(f)
</PRE>
   returns the screen-dependent font valid for <CODE>st</CODE> that corresponds
   to the predefined screen-independent font <CODE>Font.T{f}</CODE>.
   <P>
   The locking level for all methods is <CODE>LL.sup &lt;= VBT.mu</CODE>. 

<P> \subsubsection{Font attributes} 

<P> The arguments to a font oracle list method specify font attributes
   whose full specifications are the ``X Logical Font Description
   Conventions Version 1.3'', an MIT X Consortium Standard which can
   be found in Part IV of {\it X Window System} by Scheifler and Gettys
   \cite{XSpec}.  Here they are described in brief.
<P>
   The argument <CODE>family</CODE> specifies the family of the typeface.  To find
   out what fonts your X server has, run the <CODE>xlsfonts</CODE> program.  Most
   servers support the families <CODE>Courier</CODE>, <CODE>Helvetica</CODE>, and <CODE>Times</CODE>, 
   among others.
<P>
   The argument <CODE>pointsize</CODE> is ten times the font's size in 
   points; e.g., 120 for a standard 12-point font.
<P>
   The argument <CODE>slant</CODE> is an element of the following enumeration 
   type: 

<P><PRE>TYPE
  Slant = {Roman, Italic, Oblique, ReverseItalic,
    ReverseOblique, Other, Any};
</PRE> whose elements have the following interpretations:
<P>
\medskip\nobulletitem
<CODE>Roman</CODE>: Upright letters in a roman style.
<P>
\medskip\nobulletitem
<CODE>Italic</CODE>: Clockwise slanted letters in an italic style.
<P>
\medskip\nobulletitem
<CODE>Oblique</CODE>: Clockwise slanted letters in a roman style.
<P>
\medskip\nobulletitem
<CODE>ReverseItalic</CODE>:  Counter clockwise slanted letters in an italic style.
<P>
\medskip\nobulletitem
<CODE>ReverseOblique</CODE>: Counter clockwise slanted letters in a roman style.
<P>
\medskip\nobulletitem
<CODE>Other</CODE>: None of the above
<P>
\medskip\nobulletitem
<CODE>Any</CODE>: Any of the above (including <CODE>Other</CODE>).  
<P>
\medskip
<P>
The argument <CODE>weightName</CODE> is the foundry's name for the font's weight;
e.g.,  <CODE>Bold</CODE>, <CODE>DemiBold</CODE>, or <CODE>Medium</CODE>. 
       <P>
The argument <CODE>version</CODE> specifies the version of the {\it X Logical
Font Description Conventions} that describes the format of a font's
name.  If the argument is omitted, Version 1.3 is assumed.  (Version
1.3 is the only version as these words are written.)
   <P>
The argument <CODE>foundry</CODE> specifies the X registered name for the font's
foundry, e.g., <CODE>Adobe</CODE>, <CODE>B&amp;H</CODE>, <CODE>Bitstream</CODE>, <CODE>DEC</CODE>.
<P>
The argument <CODE>width</CODE> specifies the foundry's name for the font's width; e.g., <CODE>Normal</CODE> or <CODE>Condensed</CODE>.
       <P>
The argument <CODE>pixelsize</CODE> specifies the size of the font in pixels.
The size in points depends on the vertical resolution of the device:
A pixelsize of 20 could represent a 20-point font at 75 pixels per
inch or a 10-point font at 150 pixels per inch.
<P>
The arguments <CODE>hres</CODE> and <CODE>vres</CODE> specify the horizontal and vertical
screen resolution for which the font is designed, in pixels per inch.
<P>
The argument <CODE>spacing</CODE> is an element of the following enumeration:


<P><PRE>TYPE Spacing =
  {Proportional, Monospaced, CharCell, Any};
</PRE> whose elements have the following meaning:
<P>
\medskip\nobulletitem <CODE>Proportional</CODE>: Character widths vary.
<P>
\medskip\nobulletitem <CODE>Monospaced</CODE>: Character widths are constant.
<P>
\medskip\nobulletitem <CODE>CharCell</CODE>: Font is self-clearing, as defined in
the <CODE>VBT</CODE> interface.
<P>
\medskip\nobulletitem <CODE>Any</CODE>: Any of the above.
<P>
\medskip The argument <CODE>averageWidth</CODE> specifies the un-weighted
arithmetic mean of the widths of all glyphs in the font, measured in
tenths of a pixel.
<P>
The arguments <CODE>charsetRegistry</CODE> and <CODE>charsetEncoding</CODE> are the X names of the 
font's character set and encoding scheme;  e.g., <CODE>ISO8859</CODE> and <CODE>1</CODE> for
ISO Latin-1 fonts.  See Appendix G of \cite{XSpec}. 

<P><PRE>CONST
  AnyMatch = &quot;*&quot;;
  AnyValue = -1;
  ScreenTypeResolution = -2;
</PRE> Passing <CODE>AnyMatch</CODE> as an argument to the <CODE>list</CODE> method matches any
   text value for the corresponding attribute, and <CODE>AnyValue</CODE> matches
   any integer value.  Passing <CODE>ScreenTypeResolution</CODE> for <CODE>hres</CODE> or
   <CODE>vres</CODE> matches fonts whose horizontal and vertical resolutions agree
   with the screentype that owns the font.  

<P> \subsubsection{Registering fonts} 
  
<P> Some screentypes allow the client to register fonts.  The client registers
   the font's strike (bits) and metrics (description) with the <CODE>StrikeOracle</CODE>.
   The name of the font is implied by the attributes in the metrics, so
   the <CODE>list</CODE> and <CODE>lookup</CODE> methods will find client-registered fonts.  

<P><PRE>TYPE
  StrikeOracle = Oracle OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      load(strike: Strike; metrics: Metrics): T
        RAISES {Failure, TrestleComm.Failure};
    END;
</PRE> The method call <CODE>st.font.load(strike, metrics)</CODE> creates a font
   owned by <CODE>st</CODE> with the given strike and metrics and returns a handle
   to it.
   <P>
   The <CODE>metrics</CODE> argument must define all of the initial fields of the
   font metrics record: <CODE>family</CODE>, <CODE>pointSize</CODE>, ..., <CODE>isAscii</CODE>, and
   <CODE>defaultChar</CODE>.  The values <CODE>minBounds</CODE> and <CODE>maxBounds</CODE> must be provided
   if <CODE>charMetrics</CODE> is <CODE>NIL</CODE>; otherwise if <CODE>printWidth</CODE> is <CODE>AnyValue</CODE>, the
   <CODE>load</CODE> method will compute them from <CODE>charMetrics</CODE>.  If any of
   the remaining fields have the value <CODE>AnyValue</CODE>, the <CODE>load</CODE> method
   will compute them. 
         
<P> \subsubsection{The handle object}  

<P><PRE>TYPE
  <A HREF="ScrnFont.m3#T">T</A> &lt;: Public;
  Public = OBJECT (*CONST*)
    id: INTEGER;
    metrics: Metrics
  END;

TYPE StrikeFont = T OBJECT
  METHODS &lt;* LL.sup &lt;= VBT.mu *&gt;
    strike(): Strike RAISES {TrestleComm.Failure}
  END;

TYPE Strike = OBJECT
  METHODS &lt;* LL.sup &lt;= VBT.mu *&gt;
    glyph(ch: INTEGER): ScrnPixmap.T;
  END;
</PRE> If <CODE>f</CODE> is a <CODE>ScrnFont.T</CODE>, then <CODE>f.id</CODE> is an identifier whose
   interpretation depends on the screentype that owns <CODE>f</CODE> and
   <CODE>f.metrics</CODE> are the metrics for <CODE>f</CODE>.  If in addition <CODE>f</CODE> is a
   <CODE>StrikeFont</CODE>, then <CODE>f.strike()</CODE> returns <CODE>f</CODE>'s strike.  The screentype
   of the strike's pixmaps will be the screentype that owns <CODE>f</CODE>.
<P>
   If <CODE>str</CODE> is a <CODE>Strike</CODE>, then <CODE>str.glyph(ch)</CODE> is the pixmap for
   the character <CODE>ch</CODE>.  This will be empty except for characters in
   the range <CODE>[m.firstChar..m.lastChar]</CODE>, where <CODE>m</CODE> is the metrics (see
   below) for the font of which <CODE>str</CODE> is the strike.  
   
<P><PRE>PROCEDURE <A HREF="ScrnFont.m3#BoundingBox">BoundingBox</A>(txt: TEXT; fnt: T): Rect.T;
&lt;* LL arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return the smallest rectangle that contains the bounding boxes
   of the characters of <CODE>txt</CODE> if <CODE>txt</CODE> were painted in the font <CODE>fnt</CODE> with
   <CODE>txt</CODE>'s reference point at the origin. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ScrnFont.m3#BoundingBoxSub">BoundingBoxSub</A>(
  READONLY txt: ARRAY OF CHAR;
  fnt: T): Rect.T;
&lt;* LL arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Like <CODE>BoundingBox</CODE> but takes an array instead of a <CODE>TEXT</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ScrnFont.m3#BoundingBoxSubValid">BoundingBoxSubValid</A>(
  READONLY txt: ARRAY OF CHAR;
  fnt: T; VAR (*OUT*) valid: BOOLEAN): Rect.T;
&lt;* LL arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Like <CODE>BoundingBoxSub</CODE> but indicates if all characters in <CODE>txt</CODE>
   are valid.  <CODE>valid</CODE> may be set to <CODE>FALSE</CODE> even if all characters
   are valid, if the text wasn't checked. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ScrnFont.m3#TextWidth">TextWidth</A>(txt: TEXT; fnt: T): INTEGER;
&lt;* LL arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return the sum of the printing widths of the characters in <CODE>txt</CODE>
   in the font <CODE>fnt</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{The raw representation} 

<P><PRE>TYPE
  CharMetric = RECORD
    printWidth: INTEGER;
    boundingBox: Rect.T;
  END;
  CharMetrics = REF ARRAY OF CharMetric;
</PRE> The <CODE>printWidth</CODE> of a character is the displacement to the next
   character's reference point.
<P>
   The <CODE>boundingBox</CODE> of a character is the smallest rectangle with sides
   parallel to the axes that contains the glyph of the character placed
   with its reference point at (0,0).  

<P><PRE>TYPE
  Metrics = OBJECT (*CONST*)
    family: TEXT;
    pointSize: INTEGER;
    slant: Slant;
    weightName: TEXT;
    version: TEXT;
    foundry: TEXT;
    width: TEXT;
    pixelsize: INTEGER;
    hres, vres: INTEGER;
    spacing: Spacing;
    averageWidth: INTEGER;
    charsetRegistry: TEXT;
    charsetEncoding: TEXT;
    firstChar, lastChar: INTEGER;
    charMetrics: CharMetrics;
    selfClearing: BOOLEAN;
    rightKerning, leftKerning: BOOLEAN;
    isAscii: BOOLEAN;
    defaultChar: INTEGER;
    minBounds, maxBounds: CharMetric;
    ascent, descent := 0;
    fprint := Fingerprint.Zero;
  METHODS &lt;* LL arbitrary *&gt;
    intProp(name: TEXT; ch: INTEGER := -1): INTEGER
      RAISES {Failure};
    textProp(name: TEXT; ch: INTEGER := -1): TEXT
      RAISES {Failure};
  END;
</PRE> The fields from <CODE>family</CODE> to <CODE>charSetEncoding</CODE> in the <CODE>Metrics</CODE> object
   specify the attributes that were defined for the <CODE>lookup</CODE> method.
   A value of <CODE>*</CODE> or <CODE>Any</CODE> in one of these fields means that the
   corresponding attribute is unknown.
   <P>
   The integers <CODE>firstChar</CODE> and <CODE>lastChar</CODE> are the indices of the 
   first and last characters defined in the font. 
   <P>
   The array <CODE>charMetrics</CODE> specifies the metrics of the
   individual characters.  The metrics for character <CODE>ch</CODE> 
   are in <CODE>charMetrics[ch-firstChar]</CODE>.  If all characters have 
   the same <CODE>printWidth</CODE> and <CODE>boundingBox</CODE>, then these values
   are stored in <CODE>minBounds</CODE> and <CODE>maxBounds</CODE> and the <CODE>charMetrics</CODE> 
   field is <CODE>NIL</CODE>. 
       <P>
   The flag <CODE>selfClearing</CODE> indicates whether the font is self-clearing,
   as defined in the <CODE>VBT</CODE> interface, and the two kerning flags indicate
   the present of right and left kerning in the font.
       <P>
   The flag <CODE>isAscii</CODE> indicates that character codes 32-126 (base 10)
   have their normal ASCII meanings.
       <P>
   The integer <CODE>defaultChar</CODE> is the code for the recommended character
   to display in the place of a character that isn't defined for the
   font.
    <P>
   The rectangles <CODE>minBounds.boundingBox</CODE> and <CODE>maxBounds.boundingBox</CODE>
   contain the meet and join, respectively, of the bounding boxes of
   all characters in the font when they are positioned with their
   reference points at (0, 0). The values <CODE>minBounds.printWidth</CODE> and
   <CODE>maxBounds.printWidth</CODE> are the minimum and maximum printing widths
   for all characters in the font.
<P>
   The method call <CODE>m.intProp(nm)</CODE> returns the integer value of the
   font attribute named <CODE>nm</CODE>, or raises <CODE>Failure</CODE> if this attribute is
   not defined for <CODE>m</CODE>.  The method call <CODE>m.intProp(nm, ORD(ch))</CODE>
   returns the integer value of the font attribute named <CODE>nm</CODE> for the
   character <CODE>ch</CODE>, or raises <CODE>Failure</CODE> if this attribute is not defined
   for <CODE>(m, ch)</CODE>.  The <CODE>textProp</CODE> method is similar.
<P>
   The set of attributes returned by the metrics methods depend on the
   font.  Fonts that are owned by X screentypes support the attributes
   defined in Part IV of {\it X Window System} ({\it op. cit.}); we
   recommend that other fonts support them too.  (To read an X font
   attribute whose type is an X atom, use the <CODE>textProp</CODE> method, which
   returns the name of the atom.)
<P>
   The fprint field, if non-zero, holds a fingerprint for the metrics,
   which can be used to quickly determine if two Metrics are the same.
<P>
   The ascent and descent fields contain the recommended spacing in pixels
   above and below the baseline; the sum is the recommended base-line skip.


<P><PRE>END ScrnFont.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
