<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/ScrnPaintOp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/ScrnPaintOp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

INTERFACE <interface><A HREF="ScrnPaintOp.m3">ScrnPaintOp</A></interface>;

IMPORT <A HREF="TrestleComm.i3">TrestleComm</A>, <A HREF="PaintOp.i3">PaintOp</A>;
</PRE> A <CODE>ScrnPaintOp.T</CODE> is a painting operation that is valid for
   some particular screentype.
<P>
   If <CODE>op</CODE> is a <CODE>ScrnPaintOp.T</CODE> valid for screentype <CODE>st</CODE>, then <CODE>op</CODE>
   maps a source pixel <CODE>s</CODE> and destination pixel <CODE>d</CODE> to a result pixel
   <CODE>op(d, s)</CODE>.  It will be used in a painting operation that sets <CODE>d
   := op(d, s)</CODE>.  Both <CODE>d</CODE> and <CODE>op(d, s)</CODE> have type <CODE>st</CODE>, and <CODE>s</CODE> either
   has type <CODE>st</CODE> or <CODE>st.bits</CODE>.  (The type <CODE>st.bits</CODE> is the screentype
   for one-bit deep sources that can be used with <CODE>st</CODE>.) For example,
   in a copy operation, <CODE>s</CODE> has type <CODE>st</CODE>, while in painting a bitmap,
   <CODE>s</CODE> has type <CODE>st.bits</CODE>.
   <P>
   A <CODE>ScrnPaintOp.Oracle</CODE> is meaningful only as the <CODE>op</CODE> field of some 
   screentype <CODE>st</CODE>.  It provides methods to generate <CODE>ScreenPaintOp.T</CODE>s
   that are valid for <CODE>st</CODE>. 
   <P>
   A {\it tint} is a paintop that is independent of <CODE>s</CODE>.  If <CODE>op</CODE> is
   a tint, we write <CODE>op(d)</CODE> instead of <CODE>op(d, s)</CODE>.  (Even in the case
   of a tint, the type of <CODE>s</CODE> must be <CODE>st.bits</CODE>; otherwise the result
   of applying the tint is undefined.)  

<P> \subsubsection{Obtaining handles from the oracle}  

<P><PRE>TYPE
  Pixel = INTEGER;
  Oracle = Private OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      opaque(pix: Pixel): T
        RAISES {Failure, TrestleComm.Failure};
      bgfg(bg, fg: T): T
        RAISES {Failure, TrestleComm.Failure};
      swap(p,q: Pixel): T
        RAISES {Failure, TrestleComm.Failure};
      transparent(): T
        RAISES {Failure, TrestleComm.Failure};
      copy(): T
        RAISES {Failure, TrestleComm.Failure};
      builtIn(op: PaintOp.Predefined): T;
    END;
    <A HREF="ScrnPaintOp.m3#Private">Private</A> &lt;: ROOT;

EXCEPTION Failure;
</PRE> For a screentype <CODE>st</CODE>, the field <CODE>st.op</CODE> is an <CODE>Oracle</CODE> whose methods
   satisfy the following specifications:
   <P>
   The method call 
<P>
<PRE>
      op := st.op.opaque(pix)
</PRE>
   sets <CODE>op</CODE> to a tint such that <CODE>op(p) = pix</CODE> for any <CODE>p</CODE>. The method call
   <P>
<PRE>
      op := st.op.bgfg(bg, fg)
</PRE>
   sets <CODE>op</CODE> to a tint such that <CODE>op(p, 0) = bg(p)</CODE> and <CODE>op(p, 1)
   = fg(p)</CODE>, for any <CODE>p</CODE>, if <CODE>bg</CODE> and <CODE>fg</CODE> are tints. The method call 
<P>
<PRE>
      op := st.op.swap(p, q)
</PRE>
   sets <CODE>op</CODE> to a tint such that <CODE>op(p)=q</CODE>, <CODE>op(q)=p</CODE>, and for any
   <CODE>x</CODE>, <CODE>op(op(x))=x</CODE>. The method call
<P>
<PRE>
      op := st.op.transparent()
</PRE>
   sets <CODE>op</CODE> to a tint such that <CODE>op(p) = p</CODE> for any <CODE>p</CODE>. The method call 
<P>
<PRE>
      op := st.op.copy()
</PRE>
   sets <CODE>op</CODE> to a painting operation such that <CODE>op(p, q) = q</CODE> for any
   <CODE>p</CODE> and <CODE>q</CODE>. The method call 
<P>
<PRE>
      st.op.builtIn(op)
</PRE>
   returns the operation valid for <CODE>st</CODE> that corresponds to the
   predefined screen-independent operation <CODE>PaintOp.T{op}</CODE>.
<P>
   The exception <CODE>Failure</CODE> is raised if the screentype cannot provide the 
   requested painting operation. For all the methods, <CODE>LL.sup &lt;= VBT.mu</CODE>. 
      
<P><PRE>TYPE
  PlaneWiseOracle = Oracle OBJECT
    METHODS &lt;* LL.sup &lt;= VBT.mu *&gt;
      planewise(
          READONLY mask: ARRAY OF BOOLEAN;
          op1, op2: T): T
        RAISES {Failure, TrestleComm.Failure};
  END;
</PRE> If a screentype's <CODE>op</CODE> oracle is a <CODE>PlaneWiseOracle</CODE> (which you can
   test with <CODE>TYPECASE</CODE>), then you can use its <CODE>planewise</CODE> method to
   define painting operations by their effects on each bit position
   of the destination pixel.  Let <CODE>p[i]</CODE> denote bit <CODE>i</CODE> of pixel <CODE>p</CODE>.
   Assuming <CODE>NUMBER(mask) = st.depth</CODE>, the method call
<P>
<PRE>
      op := st.op.planewise(mask, bitOps)
</PRE>
sets <CODE>op</CODE> so that for <CODE>d</CODE> and <CODE>s</CODE> of screentype <CODE>st</CODE> and <CODE>i</CODE> in
<CODE>[0..st.depth-1]</CODE>, 
<P>
<PRE>
      IF mask[i] THEN
         op(d, s)[i] = op1(d[i], s[i])
      ELSE
         op(d, s)[i] = op2(d[i], s[i])
      END
</PRE>
The method may raise <CODE>Failure</CODE> if it does not support a particular 
combination of <CODE>op1</CODE>, <CODE>op2</CODE>, and <CODE>mask</CODE>.
<P>
The convenience procedure <CODE>ConstructPlanewiseOp</CODE> can be used to construct a painting operation from an array of boolean functions represented by the
enumeration by <CODE>BitOp</CODE>: 

<P><PRE>TYPE
  BitOp = {
    Zero,           (* 0 *)
    And,            (* dest AND src *)
    NotAnd,         (* (NOT dest) AND src *)
    Src,            (* src *)
    AndNot,         (* dest and (NOT src) *)
    Dest,           (* dest *)
    Xor,            (* dest XOR src *)
    Or,             (* dest OR src *)
    Nor,            (* (NOT dest) AND (NOT src) *)
    Equal,          (* dest XOR (NOT src) *)
    Invert,         (* NOT dest *)
    NotOr,          (* (NOT dest) OR src *)
    NotSrc,         (* NOT src *)
    OrNot,          (* dest OR (NOT src) *)
    Nand,           (* (NOT dest) OR (NOT src) *)
    One};           (* 1 *)

PROCEDURE <A HREF="ScrnPaintOp.m3#ConstructPlanewiseOp">ConstructPlanewiseOp</A>(
  pwo: PlaneWiseOracle;
  READONLY bitOps: ARRAY OF BitOp): T
RAISES {Failure, TrestleComm.Failure};
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the painting operation that applies <CODE>bitOp[i]</CODE> to plane <CODE>i</CODE> of
   the source and destination. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>NUMBER(bitOps) = st.depth</CODE> then <CODE>ConstructPlanewiseOp</CODE> uses <CODE>pwo</CODE> to
construct and return an operation <CODE>op</CODE> such that for <CODE>s</CODE> and
<CODE>d</CODE> of screentype <CODE>st</CODE> and <CODE>i</CODE> in <CODE>[0 .. st.depth-1]</CODE>, 
<P>
<PRE>
       op(d, s)[i] = bitOps[i](d[i], s[i])
</PRE>
The procedure may raise <CODE>Failure</CODE> if the screentype does not support
a particular array <CODE>bitOps</CODE>. 

<P> \subsubsection{The handle object} 

<P><PRE>TYPE
  <A HREF="ScrnPaintOp.m3#T">T</A> &lt;: Public;
  Public = OBJECT id: INTEGER; pix: Pixel := -1 END;
</PRE> If <CODE>p</CODE> is a <CODE>T</CODE>, then <CODE>p.id</CODE> is an identifier whose interpretation
   depends on the screentype.  If <CODE>p</CODE> was created by a call
   <CODE>st.op.opaque(pix)</CODE>, then <CODE>p.pix = pix</CODE>; otherwise <CODE>p.pix = -1</CODE>. 

<P><PRE>END ScrnPaintOp.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
