<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/ScrnPaintOp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/ScrnPaintOp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="ScrnPaintOp.i3">ScrnPaintOp</A></implements></module>;

IMPORT <A HREF="TrestleComm.i3">TrestleComm</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

REVEAL <A NAME="T">T</A> = Public BRANDED OBJECT END; <A NAME="Private">Private</A> = BRANDED OBJECT END;

PROCEDURE <A NAME="ConstructPlanewiseOp"><procedure>ConstructPlanewiseOp</procedure></A>(
  pwo: PlaneWiseOracle;
  READONLY bitOps: ARRAY OF BitOp): T
RAISES {Failure, TrestleComm.Failure} =
  VAR
    res := pwo.transparent(); temp: T;
    mask := ARRAY [0..31] OF BOOLEAN {FALSE, ..};
    allones := Word.Minus(Word.Shift(1, NUMBER(bitOps)), 1);
    zero := pwo.opaque(0);
    one := pwo.opaque(allones);
    trans := res;
    swap := pwo.swap(0,allones);
  BEGIN
    FOR i := 0 TO LAST(bitOps) DO
      CASE bitOps[i] OF
        BitOp.Zero =&gt; temp := zero
      | BitOp.And =&gt; temp := pwo.bgfg(zero, trans)
      | BitOp.NotAnd =&gt; temp := pwo.bgfg(zero,swap)
      | BitOp.Src =&gt; temp := pwo.bgfg(zero,one)
      | BitOp.AndNot =&gt; temp := pwo.bgfg(trans, zero)
      | BitOp.Dest =&gt;  temp := trans
      | BitOp.Xor =&gt; temp := pwo.bgfg(trans, swap)
      | BitOp.Or =&gt; temp := pwo.bgfg(trans,one)
      | BitOp.Nor =&gt; temp := pwo.bgfg(swap, zero)
      | BitOp.Equal =&gt; temp := pwo.bgfg(swap, trans)
      | BitOp.Invert =&gt; temp := swap
      | BitOp.NotOr =&gt; temp := pwo.bgfg(swap,one)
      | BitOp.NotSrc =&gt; temp := pwo.bgfg(one,zero)
      | BitOp.OrNot =&gt; temp := pwo.bgfg(one,trans)
      | BitOp.Nand =&gt; temp := pwo.bgfg(one,swap)
      | BitOp.One =&gt; temp := one
      END;
      IF res = trans THEN
        res := temp
      ELSIF temp # trans THEN
        res := pwo.planewise(SUBARRAY(mask, 0, NUMBER(bitOps)), res, temp)
      END;
      mask[i] := TRUE
    END;
    RETURN res
  END ConstructPlanewiseOp;

BEGIN END ScrnPaintOp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
