<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/ScrnPixmap.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/ScrnPixmap.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>ScrnPixmap.T</CODE> is a handle on a rectangular array of pixels that
   is valid for use on a particular screentype, called the {\it owner}
   of the handle.  Some handles have names; others are anonymous.  A
   named handle is valid forever; the pixmap referenced by an anonymous
   handle will be garbage-collected when all handles to it have been
   dropped.  
   
<P><PRE>INTERFACE <interface><A HREF="ScrnPixmap.m3">ScrnPixmap</A></interface>;

IMPORT <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="TrestleComm.i3">TrestleComm</A>, <A HREF="Pixmap.i3">Pixmap</A>, <A HREF="#x1">BasicCtypes</A>;

EXCEPTION Failure;

TYPE Raw = Pixmap.Raw;
</PRE> The raw representation of a pixmap is revealed at the end of this 
   interface. 
<P>
\subsubsection{Obtaining handles from the oracle} 

<P><PRE>TYPE
  Oracle = Private OBJECT
  METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    load(READONLY r: Raw; nm: TEXT := NIL): T
      RAISES {TrestleComm.Failure};
    list(pat: TEXT; maxResults: CARDINAL := 1)
      : REF ARRAY OF TEXT RAISES {TrestleComm.Failure};
    lookup(name: TEXT): T RAISES {TrestleComm.Failure};
    builtIn(pm: Pixmap.Predefined): T;
  END;
  <A HREF="ScrnPixmap.m3#Private">Private</A> &lt;: ROOT;
</PRE> For a screentype <CODE>st</CODE>, the field <CODE>st.pixmap</CODE> is an <CODE>Oracle</CODE> that 
   produces pixmaps owned by <CODE>st</CODE>.
<P>
   The method call <CODE>st.pixmap.load(r, nm)</CODE> allocates and returns
   a pixmap handle <CODE>p</CODE> owned by <CODE>st</CODE> whose contents are equal to <CODE>r</CODE>.  The
   depth of <CODE>r</CODE> must either be <CODE>1</CODE> or <CODE>st.depth</CODE>, otherwise there is
   a checked runtime error.  If <CODE>nm # NIL</CODE>, <CODE>p</CODE> receives the name <CODE>nm</CODE>,
   and any pixmap handle owned by <CODE>st</CODE> that previously had the name
   <CODE>nm</CODE> becomes anonymous.
<P>
   The method call <CODE>st.pixmap.list(pat, maxResults)</CODE> returns the names
   of all pixmaps owned by <CODE>st</CODE> that match the pattern <CODE>pat</CODE>.  The list
   of results may be truncated to length <CODE>maxResults</CODE>.  A <CODE>*</CODE> matches
   any number of characters and a <CODE>?</CODE> matches any single character.
<P>
   The method call <CODE>st.pixmap.lookup(name)</CODE> return the pixmap with the
   given name, or <CODE>NIL</CODE> if no pixmap has this name.
<P>
   The method call <CODE>st.pixmap.builtIn(pm)</CODE> returns the screen-dependent
   pixmap valid for <CODE>st</CODE> that corresponds to the predefined
   screen-independent <CODE>Pixmap.T{pm}</CODE>.
   <P>
   The locking level for all methods is <CODE>LL.sup &lt;= VBT.mu</CODE>. 

<P> \subsubsection{The handle object} 

<P><PRE>TYPE
  <A HREF="ScrnPixmap.m3#T">T</A> &lt;: Public;
  Public = OBJECT (*CONST*)
    id: INTEGER;
    depth: INTEGER;
    bounds: Rect.T
  METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    localize(READONLY rect: Rect.T): Raw
      RAISES {TrestleComm.Failure};
    unload() RAISES {TrestleComm.Failure};
    free() RAISES {TrestleComm.Failure}
  END;
</PRE> If <CODE>pm</CODE> is a <CODE>ScrnPixmap.T</CODE>, then <CODE>pm.id</CODE> is an identifier whose
   interpretation depends on the screentype that owns <CODE>pm</CODE>.  The field
   <CODE>pm.depth</CODE> is the number of bits in each pixel of <CODE>pm</CODE>, and
   <CODE>pm.bounds</CODE> is the rectangular extent of <CODE>pm</CODE>.
    <P>
   The method call <CODE>pm.localize(rect)</CODE> returns a raw pixmap equal to
   a rectangualr subpixmap of the one on which <CODE>pm</CODE> is a handle.  The
   bounds of the raw pixmap returned by <CODE>localize</CODE> is <CODE>Rect.Meet(rect,
   pm.bounds)</CODE>.
    <P>
   The method call <CODE>pm.unload()</CODE> causes <CODE>pm</CODE> to become anonymous.
<P>
   Pixmaps consume large amounts of memory.  The method call <CODE>pm.free()</CODE>
   releases the memory associated with the pixmap.  You must make sure
   that all <CODE>VBT</CODE>s using <CODE>pm</CODE> have finished painting before you
   free it. After a call to <CODE>free</CODE>, the pixmap bounds and contents
   are arbitrary. 

<P> \subsubsection{The raw representation}
<P>
   A raw pixmap allows the client to directly locate and modify the
   bits of the pixmap.  The following procedure produces a new raw
   pixmap: 
      
<P><PRE>PROCEDURE <A HREF="ScrnPixmap.m3#NewRaw">NewRaw</A>(dpth: INTEGER;
  READONLY bnds: Rect.T): Raw;
&lt;* LL arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Allocate and return a raw pixmap with the given depth and bounds. </EM></BLOCKQUOTE><PRE>
</PRE> The initial contents of the pixmap returned by <CODE>NewRaw</CODE> are undefined.
<P>
   Here is the representation of a raw pixmap: 

<P><PRE>REVEAL Pixmap.Raw &lt;: Raw_Public;

TYPE
  Raw_Public = OBJECT
    depth: INTEGER;
    bounds: Rect.T;
    pixels: REF ARRAY OF PixWord;
    offset: INTEGER;
    bitsPerPixel: INTEGER;
    wordsPerRow: INTEGER;
    pixelOrder: ByteOrder;
    westRounded: INTEGER;
  METHODS
    get(READONLY pt: Point.T): Pixel;
    set(READONLY pt: Point.T; pix: Pixel);
    sub(READONLY rect: Rect.T): Raw;
  END;

  PixWord = BasicCtypes.unsigned_int;
  Pixel = Word.T;
  ByteOrder = {MSBFirst, LSBFirst};
</PRE> The methods provide the easiest way to operate on a raw pixmap, and
   we will explain them first.  Let <CODE>pm</CODE> be a <CODE>ScrnPixmap.Raw</CODE>, then:
<P>
   The method call 
<P>
<PRE>
      pm.get(pt)
</PRE>
   returns the pixel value at the point <CODE>pt</CODE> in the pixmap.  The result
   is undefined if <CODE>pt</CODE> is not in <CODE>pm.bounds</CODE>.
<P>
   The method call 
<P>
<PRE>
      pm.set(pt, pix)
</PRE>
   sets the pixel value at the point <CODE>pt</CODE> of the pixmap <CODE>pm</CODE> to the
   value <CODE>pix</CODE>.  It is a noop if <CODE>pt</CODE> is not in <CODE>pm.bounds</CODE>.
<P>
   The method call 
   <P>
<PRE>
      pm.sub(rect)
</PRE>
   returns a pixmap whose bounds are <CODE>Rect.Meet(rect, pm.bounds)</CODE> and
   whose contents are shared with <CODE>pm</CODE>'s.
<P>
   It is also possible to bypass the methods and access the
   data in the raw pixmap directly. Here is the specification
   for the internal layout of pixels in a raw pixmap:
   <P>
   A value <CODE>pm</CODE> of type <CODE>Pixmap.Raw</CODE> is a rectangular subregion of a
   larger rectangular pixmap, which we shall call the {\it surround}.
   The surround is a word-aligned pixmap, stored in raster-scan order
   by rows.  Pixels do not cross word boundaries.  More precisely, the
   westmost pixel in each row of the surround is always a pixel whose
   <CODE>h</CODE>-coordinate is a multiple of <CODE>pixelsPerWord</CODE> (which is equal to
   <CODE>BITSIZE(PixWord) DIV pm.bitsPerPixel</CODE>).  The eastmost pixel in each row
   of the surround is always a pixel whose <CODE>h</CODE>-coordinate modulo
   <CODE>pixelsPerWord</CODE> is congruent to <CODE>pixelsPerWord-1</CODE>.  Hence, the number
   of pixels in each row of the surround is a multiple of
   <CODE>pixelsPerWord</CODE>.  The value <CODE>pm.wordsPerRow</CODE> is the number of words
   that are needed to store one row of the surround.
<P>
   The value <CODE>pm.bitsPerPixel</CODE> might be greater than <CODE>pm.depth</CODE>; for
   example, a twelve-bit deep pixmap might be stored with 
   sixteen bits per pixel.
<P>
   The pixels of the surround are stored in the array <CODE>pm.pixels</CODE>.  Each
   row is represented in <CODE>pm.wordsPerRow</CODE> adjacent words; the first
   of these words stores the westmost <CODE>pixelsPerWord</CODE> pixels of the
   row, the following word stores the adjacent <CODE>pixelsPerWord</CODE> pixels,
   and so on until the last word, which stores the eastmost
   <CODE>pixelsPerWord</CODE> pixels.
<P>
   The order in which pixels are packed into words is indicated by
   <CODE>pm.pixelOrder</CODE>.  In this discussion, bit <CODE>0</CODE> is the least
   significant bit and bit <CODE>BITSIZE(PixWord) - 1</CODE> is the most significant bit
   of a word.
<P>
   If <CODE>pm.pixelOrder = LSBFirst</CODE>, the bits of the pixels are as follows
   (where <CODE>bpp</CODE> is <CODE>pm.bitsPerPixel</CODE>):
<P>
<PRE>
      <KBD>pixel </KBD>0<KBD>:  bits</KBD> 0..bpp-1
      <KBD>pixel </KBD>1<KBD>:  bits</KBD> bpp..2*bpp-1
      ...
      <KBD>pixel </KBD>i<KBD>:  bits</KBD> i*bpp..(i+1)*bpp-1
   </PRE>
   If <CODE>pm.pixelOrder = MSBFirst</CODE>, the pixels are stored in reverse order, 
   so that pixel <CODE>i</CODE> occupies the same bits as pixel <CODE>pixelsPerWord-i-1</CODE>
   occupies for <CODE>LSBFirst</CODE>.
<P>
   A <CODE>Word.Extract</CODE> of the bits indicated above, from the correct word,
   gives the pixel's value.  If the word size does not contain an
   integral number of pixels, the unused bits in the word have
   undefined values.
   <P>
   The pixmap <CODE>pm</CODE> itself is a rectangular region selected from the surround;
   the value <CODE>pm.bounds</CODE>, of type <CODE>Rect.T</CODE>, specifies the domain of <CODE>pm</CODE>.  The
   value <CODE>pm.offset</CODE> specifies where in <CODE>pm.pixels</CODE> the words containing the
   pixels of <CODE>pm</CODE> can be found.  In particular, the northwestern-most bit of
   <CODE>pm</CODE>, the bit with coordinates
<P>
<PRE>
      h = pm.bounds.west <KBD>and</KBD> v = pm.bounds.north,
</PRE>
   is stored in word <CODE>pm.pixels[pm.offset]</CODE>.  The pixel is the 
   <CODE>(pm.bounds.west MOD pixelsPerWord)</CODE>'th pixel of the word.  
   Its bits can be found by the earlier formulas.
<P>
   The general formula for the word containing the pixel with position 
   <CODE>h, v</CODE> is
<P>
<PRE>
      pm.pixels[
       (v - pm.bounds.north) * pm.wordsPerRow + 
       (h - pm.westRounded) DIV pixelsPerWord) + pm.offset].
</PRE>
   Here is another useful formula.  The surround rectangle must be at
   least wide enough to contain the subrectangle <CODE>pm.bounds</CODE>, even after
   we have rounded the west edge of <CODE>pm.bounds</CODE> westward to the next word
   boundary and rounded the east edge of <CODE>pm.bounds</CODE> eastward to the next
   word boundary.  As a result, we have the inequality:
<P>
<PRE>
       pm.wordsPerRow &gt;= 
         ((pm.bounds.east - 1) DIV pixelsPerWord) - 
         (pm.bounds.west DIV pixelsPerWord) + 1
</PRE>
<P>
Finally, the value <CODE>pm.westRounded</CODE> is provided for convenience; it
is equal to
<P>
<PRE>
      bounds.west - (bounds.west MOD pixelsPerWord),
</PRE>
that is, the western boundary moved west to the nearest word boundary.


<P><PRE>END ScrnPixmap.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface BasicCtypes is in:
</A><UL>
<LI><A HREF="../../../C/src/32BITS/BasicCtypes.i3#0TOP0">C/src/32BITS/BasicCtypes.i3</A>
<LI><A HREF="../../../C/src/64BITS/BasicCtypes.i3#0TOP0">C/src/64BITS/BasicCtypes.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
