<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/Trestle.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/Trestle.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Trestle.def, by gnelson and msm. 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> The <CODE>Trestle</CODE> interface provides routines for connecting to window
   systems; installing, decorating, and moving top-level windows, and 
   performing related operations.  

<P><PRE>INTERFACE <interface><A HREF="../trestle/Trestle.m3">Trestle</A></interface>;

IMPORT <A HREF="VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="TrestleComm.i3">TrestleComm</A>;

TYPE
  <A HREF="../trestle/Trestle.m3#T">T</A> &lt;: ROOT;
</PRE> A <CODE>Trestle.T</CODE> identifies an instance of a window system.  All the 
   routines in this interface that take a <CODE>Trestle.T</CODE> accept the value <CODE>NIL</CODE>,
   which represents the default window system obtained by calling
   <CODE>Connect(NIL)</CODE>. 

<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#Install">Install</A>(
    v: VBT.T;
    applName: TEXT := NIL;
    inst: TEXT := NIL;
    windowTitle: TEXT := NIL;
    iconTitle: TEXT := NIL;
    bgColorR: REAL := -1.0;
    bgColorG: REAL := -1.0;
    bgColorB: REAL := -1.0;
    iconWindow: VBT.T := NIL;
    trsl: T := NIL)
  RAISES {TrestleComm.Failure}; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Initiate the installation of <CODE>v</CODE> as a decorated top-level window of the
   window system <CODE>trsl</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Install</CODE> may return before the installation is complete.  <CODE>Install</CODE>
   is a checked runtime error if <CODE>v</CODE> is not detached, or if <CODE>v</CODE> is in
   the process of being installed.  The position of the window
   on the screen depends on the window manager.
<P>
   The text <CODE>applName</CODE> is the application name; it defaults to the
   application name from the process environment.
<P>
   The text <CODE>inst</CODE> distinguishes windows with the same application name. 
   For example, a text editor might use the full path name of the 
   file being edited as the instance. The default is the value of 
   the environment variable <CODE>WINSTANCE</CODE>.
<P>
   Trestle does not require that the pair <CODE>(applName, inst)</CODE> be unique, but
   session management tools will work more smoothly if it is.
<P>
   The text <CODE>windowTitle</CODE> will be placed in the window's title bar when
   the window is not iconic.  It defaults to the concatenation of
   <CODE>applName</CODE>, a space, and <CODE>inst</CODE>, or just to <CODE>applName</CODE> if <CODE>inst</CODE>
   is <CODE>NIL</CODE>.
<P>
   The icon for the window will contain the text <CODE>iconTitle</CODE> together
   with <CODE>iconWindow</CODE> (if it is not <CODE>NIL</CODE>).  For example, <CODE>iconWindow</CODE>
   might be a small <CODE>BitmapVBT</CODE>.  Some window managers ignore
   <CODE>iconWindow</CODE>.  The default for <CODE>iconTitle</CODE> is <CODE>inst</CODE>, or 
   <CODE>applName</CODE> if <CODE>inst</CODE> is <CODE>NIL</CODE>.
<P>
   The triple <CODE>bgColorR</CODE>, <CODE>bgColorG</CODE>, <CODE>bgColorB</CODE> specify the red, green,
   and blue components of the background color for the window and icon
   titles.  If they are defaulted, the window manager's default
   background color will be used; if they are not defaulted they should
   be between <CODE>0.0</CODE> and <CODE>1.0</CODE>.  Some window managers ignore the
   background color.
<P>
   An installed window's maximum, minimum, and preferred size will be
   reported to the window manager, initially and whenever they change.
   However, a <CODE>StableVBT</CODE> filter is inserted above each installed
   window, so that a new preferred size will not be reported if the
   window's current size satisfies the new max and min constraints.
   Use <CODE>StableVBT.Disable</CODE> to force a new preferred size.
<P>
   It is a checked runtime error if either <CODE>v</CODE> or <CODE>iconWindow</CODE> is 
   already installed.
<P>
   Installing a window inserts one or more filters above it, including
   a <CODE>HighlightVBT</CODE>, a <CODE>StableVBT</CODE>, and filters that make
   screen-independent resources work.  

<P>
<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#AwaitDelete">AwaitDelete</A>(v: VBT.T); &lt;* LL = {} *&gt;
</PRE><BLOCKQUOTE><EM> Wait until <CODE>v</CODE> is deleted or disconnected from whatever window system it
   is installed on.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>AwaitDelete</CODE> will not return until after the <CODE>Deleted</CODE> or
   <CODE>Disconnected</CODE> code has been delivered and processed by the window.
   It is a noop if <CODE>v</CODE> is already deleted or is not installed.  

<P>
<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#Delete">Delete</A>(v: VBT.T); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Delete <CODE>v</CODE> from wherever it is installed.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Delete</CODE> automatically releases any selections owned by <CODE>v</CODE> or any of
   <CODE>v</CODE>'s descendants.  Before <CODE>Delete(v)</CODE> returns, lost codes will be
   delivered for any such selections.  If <CODE>v</CODE> owned the mouse focus,
   <CODE>v</CODE> will also receive a synthesized mouse transition of type
   <CODE>LastUp</CODE>.  Then <CODE>v</CODE> will receive a <CODE>Deleted</CODE> code, and finally
   <CODE>Delete</CODE> will return.  At this point <CODE>v</CODE> is disconnected and can
   be re-installed.  

<P>
<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#Decorate">Decorate</A>(
    v: VBT.T;
    instance: TEXT := NIL;
    windowTitle: TEXT := NIL;
    iconTitle: TEXT := NIL;
    bgColorR: REAL := -1.0;
    bgColorG: REAL := -1.0;
    bgColorB: REAL := -1.0;
    applName: TEXT := NIL;
    iconWindow: VBT.T := NIL)
  RAISES {TrestleComm.Failure}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the decorations of <CODE>v</CODE> to the given values </EM></BLOCKQUOTE><PRE>
</PRE> Any parameter that is defaulted will not be changed, unless v has
   been <CODE>Attached</CODE> since it was last decorated, in which case the
   default value is computed as in <CODE>Install</CODE>.  <CODE>Decorate</CODE> is a noop
   if <CODE>v</CODE> is not an attached window, or if <CODE>v</CODE> is installed without
   decorations.  

<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#GetDecoration">GetDecoration</A>(v: VBT.T;
  VAR instance, windowTitle, iconTitle, applName: TEXT;
  VAR bgColorR, bgColorG, bgColorB: REAL;
  VAR iconWindow: VBT.T): BOOLEAN; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> If <CODE>v</CODE> is decorated, fetch <CODE>v</CODE>'s decorations, and return <CODE>TRUE</CODE>.  
  Otherwise, return <CODE>FALSE</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Window placement} 

<P>
<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#Attach">Attach</A>(v: VBT.T; trsl: T := NIL)
  RAISES {TrestleComm.Failure}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Attach <CODE>v</CODE> to the window system <CODE>trsl</CODE>, leaving it invisible. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Attach</CODE> is like <CODE>Install</CODE>, except (1) the locking level is
   different, (2) the attachment is completed before <CODE>Attach</CODE> returns,
   (3) the window becomes undecorated, and (4) the window remains
   invisible until you call <CODE>Overlap</CODE>, <CODE>Iconize</CODE>, or <CODE>MoveNear</CODE>.  Before
   calling one of these, most clients will want to call <CODE>Decorate</CODE>. 

<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#Overlap">Overlap</A>(
    v: VBT.T;
    id: ScreenID;
    READONLY nw: Point.T)
  RAISES {TrestleComm.Failure}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Move the northwest corner of <CODE>v</CODE> to the point <CODE>nw</CODE> on the screen <CODE>id</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>v</CODE> is undecorated, this produces a window with no title bar or
   border, and the user will probably not be able to move, iconize or
   delete the window; this is a bad idea unless you're implementing
   pop-up or pull-down menus.  If <CODE>id</CODE> is out-of-range for this Trestle
   instance, the window will appear on the default screen. 

<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#Iconize">Iconize</A>(v: VBT.T)
  RAISES {TrestleComm.Failure}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Make the window <CODE>v</CODE> become iconic. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../trestle/Trestle.m3#MoveNear">MoveNear</A>(v, w: VBT.T)
  RAISES {TrestleComm.Failure}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Move the window <CODE>v</CODE> to be near the window <CODE>w</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> The exact effect of <CODE>MoveNear</CODE> depends on the window manager.  
   If <CODE>w</CODE> is <CODE>NIL</CODE> or is not installed where <CODE>v</CODE> is, then
   <CODE>MoveNear</CODE> will attempt to bring <CODE>v</CODE> to the attention of the user;
   in particular, if <CODE>v</CODE> is an overlapping window, <CODE>v</CODE> will be brought
   to the top; if <CODE>v</CODE> is an icon, it will be deiconized; if <CODE>v</CODE> is
   in the invisible state produced by <CODE>Attach</CODE>, it will be opened in some 
   visible place.  
   <P>
   <CODE>Overlap</CODE>, <CODE>Iconize</CODE>, and <CODE>MoveNear</CODE> are all no-ops if <CODE>v</CODE> is not
   installed.  The effects of <CODE>Iconize</CODE> and <CODE>MoveNear</CODE> are undefined
   for undecorated windows.  

<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#InstallOffscreen">InstallOffscreen</A>(
    v: VBT.T;
    width, height: CARDINAL;
    preferredScreenType: VBT.ScreenType)
  RAISES {TrestleComm.Failure}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Give <CODE>v</CODE> a domain with the given dimensions in the off-screen memory
   of the window system to which it is attached.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>InstallOffscreen</CODE> rescreens <CODE>v</CODE> to <CODE>preferredScreenType</CODE>, or
   something as much like it as supported for off-screen windows.  The
   window <CODE>v</CODE> must be in the floating state produced by <CODE>Attach</CODE>.  The
   usual purpose is to paint on <CODE>v</CODE> and then use <CODE>VBT.Capture</CODE> to
   retrieve the contents of its screen as a pixmap.  You should delete
   <CODE>v</CODE> when you are done with it.  Until <CODE>v</CODE> is deleted, you should
   not pass it to <CODE>Overlap</CODE>, <CODE>Iconize</CODE>, <CODE>MoveNear</CODE> or <CODE>InstallOffscreen</CODE>. 

<P>  \subsection{Enumerating and positioning screens} 

<P> A window system may have multiple screens.  Each screen is
   identified by an integer.  

<P><PRE>TYPE ScreenID = INTEGER;

CONST NoScreen: ScreenID = -1;

TYPE ScreenOfRec = RECORD
  id: ScreenID;
  q: Point.T;
  trsl: T;
  dom: Rect.T
END;

PROCEDURE <A HREF="../trestle/Trestle.m3#ScreenOf">ScreenOf</A>(
  v: VBT.T; READONLY p: Point.T)
  : ScreenOfRec; &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Return information about where <CODE>v</CODE> is installed. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>v</CODE> is an installed window, or a child of an installed window,
    then after <CODE>res := ScreenOf(v, p)</CODE> we have 
<P>
\medskip\bulletitem <CODE>res.id</CODE> is the <CODE>ID</CODE> of the screen currently
containing <CODE>v</CODE>;
   <P>
\medskip\bulletitem <CODE>res.q</CODE> is the point in screen coordinates that
 corresponds to the point <CODE>p</CODE> in window coordinates;
<P>
\medskip\bulletitem <CODE>res.trsl</CODE> is the window system on which <CODE>v</CODE> is
installed; and
   <P>
\medskip\bulletitem
<CODE>res.dom</CODE> is the domain of the screen <CODE>res.id</CODE>.  
<P>
\medskip The point <CODE>p</CODE> need not be in the domain of <CODE>v</CODE>.  If <CODE>v</CODE> is
not installed, then <CODE>res.trsl</CODE> will be <CODE>NIL</CODE>, <CODE>res.id</CODE> will be
<CODE>NoScreen</CODE>, and the other fields will be arbitrary.  If the window
manager is moving <CODE>v</CODE> between screens when <CODE>ScreenOf</CODE> is called, then
<CODE>res.id</CODE> will be <CODE>NoScreen</CODE> and <CODE>res.dom</CODE> and <CODE>res.q</CODE> will be arbitrary.


<P><PRE>TYPE
  Screen = RECORD
    id: ScreenID;
    dom: Rect.T;
    delta: Point.T;
    type: VBT.ScreenType
  END;
  ScreenArray = REF ARRAY OF Screen;

PROCEDURE <A HREF="../trestle/Trestle.m3#GetScreens">GetScreens</A>(trsl: T := NIL): ScreenArray
  RAISES {TrestleComm.Failure}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return an array of descriptors of the screens of the window system
   <CODE>trsl</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> For each <CODE>Screen</CODE> <CODE>s</CODE> in the returned array, the rectangle <CODE>s.dom</CODE>
   is the domain of the <CODE>VBT</CODE> at the root of the screen.  The screens
   all lie in a global coordinate system, within which the user moves
   the cursor.  The point <CODE>p</CODE> in screen coordinates corresponds to the
   point <CODE>p+s.delta</CODE> in global coordinates.  (Some window systems don't
   support this; in which case <CODE>s.delta</CODE> will be set to <CODE>Point.Origin</CODE>
   for all screens.)  The value <CODE>s.type</CODE> is the screentype of the screen's
   root <CODE>VBT</CODE>.  <CODE>GetScreens</CODE> returns <CODE>NIL</CODE> if the window system has
   no screens.  

<P> \subsection{Reading pixels from a screen} 

<P>
<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#Capture">Capture</A>(
    id: ScreenID;
    READONLY clip: Rect.T;
    VAR (* out *) br: Region.T;
    trsl: T := NIL)
    : ScrnPixmap.T
  RAISES {TrestleComm.Failure};
  &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Read the contents of <CODE>clip</CODE> from screen <CODE>id</CODE> of <CODE>trsl</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Capture(id, clip, br, trsl)</CODE> is like <CODE>VBT.Capture(r, clip, br)</CODE>, 
   where <CODE>r</CODE> is the <CODE>VBT</CODE> at the root of screen <CODE>id</CODE> of the window 
   system <CODE>trsl</CODE>.  

<P> \subsection{Checking on recent input activity} 

<P>
<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#AllCeded">AllCeded</A>(trsl: T := NIL): BOOLEAN
    RAISES {TrestleComm.Failure}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return whether there is pending input from <CODE>trsl</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If a program calls <CODE>AllCeded(t)</CODE> and <CODE>TRUE</CODE> is returned, then there
   are no mouse clicks or keystrokes on their way to any top-level
   windows installed by the program on <CODE>t</CODE>.  For example, when the VT100
   terminal emulator has observed a key-down and waited for half a
   second and observed no key-up and concludes that it should go into
   auto-repeat mode, it verifies that <CODE>AllCeded</CODE> returns <CODE>TRUE</CODE> to make
   sure that the up transition is not on its way, to avoid erroneously
   entering auto-repeat mode.  

<P>
<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#TickTime">TickTime</A>(trsl: T := NIL): INTEGER;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the number of microseconds per <CODE>VBT.TimeStamp</CODE>, in events
   reported to <CODE>VBTs</CODE> connected to the window system <CODE>trsl</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Connecting to a window system} 

<P>
<P><PRE>PROCEDURE <A HREF="../trestle/Trestle.m3#Connect">Connect</A>(inst: TEXT := NIL): T
  RAISES {TrestleComm.Failure}; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Connect to the window system named <CODE>inst</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> In general, the format and interpretation of <CODE>inst</CODE> are
   implementation-dependent.  Here are the rules when using an 
   X server:
   <P>
   If <CODE>inst</CODE> is <CODE>NIL</CODE>, it defaults to the value of the environment
   variable <CODE>DISPLAY</CODE>, unless this variable is undefined, in which
   case it defaults to <CODE>:0</CODE>.
   <P>
   The syntax of <CODE>inst</CODE> should be: 
<P>
<PRE>
      &lt;machine name&gt;(&quot;:&quot; | &quot;::&quot;)&lt;number&gt;(&quot;&quot; | &quot;.&quot; &lt;number&gt;)
</PRE>
   where <CODE>&lt;machine name&gt;</CODE> is an arbitrary string of characters (possibly
   empty) and <CODE>&lt;number&gt;</CODE> is a non-negative decimal integer.  It denotes
   an X server according to the rules on page 27 of the second edition
   of {\it X Window System}, by Scheifler et.  al., Digital Press, 1990
   \cite{XSpec}.
<P>
   For example, <CODE>nemesia:0</CODE> denotes the first window system on the
   machine <CODE>nemesia</CODE>, and <CODE>:0</CODE> denotes the first window system on
   the machine calling <CODE>Connect</CODE>.
<P>
   The exception is raised if the designated window system doesn't
   exist or cannot be connected to. 
   
<P><PRE>END Trestle.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
