<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/vbt/TrestleClass.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/vbt/TrestleClass.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

INTERFACE <interface><A HREF="TrestleClass.m3">TrestleClass</A></interface>;

IMPORT <A HREF="Trestle.i3">Trestle</A>, <A HREF="VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="ScrnColorMap.i3">ScrnColorMap</A>,
  <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
FROM <A HREF="TrestleComm.i3">TrestleComm</A> IMPORT Failure;
FROM <A HREF="Trestle.i3">Trestle</A> IMPORT ScreenID;

REVEAL Trestle.T &lt;: Public;

VAR connectMu: MUTEX;  &lt;* LL = VBT.mu + epsilon *&gt;
 closeMu: MUTEX; &lt;* LL maximal *&gt;

TYPE
  <A HREF="../trestle/Trestle.m3#RootVBT">RootVBT</A> &lt;: VBT.Split;
  Public = RootVBT OBJECT
    closed := FALSE &lt;* LL = closedMu *&gt;
  METHODS
    attach(v: VBT.T) RAISES {Failure};
    (* tr.attach(v) attaches v to tr, leaving v invisible. *)
    (* It must make v a descendant of tr even if it raises Failure *)
    (* v must be attached for the rest of the methods *)
    decorate(v: VBT.T; old, new: Decoration) RAISES {Failure};
    (* new is on v's prop list. *)
    iconize(v: VBT.T) RAISES {Failure};
    overlap(v: VBT.T; id: ScreenID; READONLY nw: Point.T)
      RAISES {Failure};
    moveNear(v, w: VBT.T) RAISES {Failure};
    installOffscreen(v: VBT.T; width, height: CARDINAL;
      preferredScreenType: VBT.ScreenType) RAISES {Failure};
    setColorMap(v: VBT.T; cm: ScrnColorMap.T);
    getScreens(): Trestle.ScreenArray RAISES {Failure};
    captureScreen(
      id: ScreenID;
      READONLY clip: Rect.T;
      VAR (* out *) br: Region.T)
      : ScrnPixmap.T
    RAISES {Failure};
    allCeded(): BOOLEAN RAISES {Failure};
    tickTime(): INTEGER;
    swap(v, w: VBT.T) RAISES {Failure};
    getName(v: VBT.T): TEXT RAISES {Failure};
    setScreens(sa: Trestle.ScreenArray) RAISES {Failure};
    nameList(nm: TEXT): REF ARRAY OF TEXT RAISES {Failure};
    moveNearByName(v: VBT.T; nm: TEXT)  RAISES {Failure};
    swapByName(v: VBT.T; nm: TEXT) RAISES {Failure};
    deleteByName(nm: TEXT) RAISES {Failure};
    takeOver(id: ScreenID; v: VBT.T) RAISES {Failure};
    (* Initially v is attached *)
    restore(id: ScreenID; v: VBT.T) RAISES {Failure};
    takeOverMouse(id: ScreenID; v: VBT.T) RAISES {Failure};
    releaseMouse(id: ScreenID; v: VBT.T) RAISES {Failure};
    setHighlight(
      id: ScreenID;
      READONLY r: Rect.T;
      border: CARDINAL)
      RAISES {Failure};
    addParent(prnt: VBT.T; id: ScreenID) RAISES {Failure};
    remParent(prnt: VBT.T; id: ScreenID) RAISES {Failure};
    warpCursor(id: ScreenID; READONLY pt: Point.T) RAISES {Failure};
    (* getConfig(id: ScreenID; p: Trestle.ConfigClosure)
      RAISES {Failure};
    setConfig(id: ScreenID; c: Trestle.Config) RAISES {Failure}; *)
    lastCeded(): VBT.TimeStamp RAISES {Failure};
    (* getParameters(): Trestle.Parameters RAISES {Failure};
    setParameters(p: Trestle.Parameters) RAISES {Failure}; *)
    (* the following methods are to support telepointing on shared windows;
       all have LL = VBT.mu.  For trestleId, the default display name is
       returned when v = NIL; otherwise a specific displayname for the
       display and screen where v appears is returned. *)
    trestleId(v: VBT.T := NIL): TEXT;
    windowId(v: VBT.T): TEXT;
    updateBuddies(v: VBT.T; READONLY trsls, ids: ARRAY OF TEXT);
    delete(ch: VBT.T); (* default in a T calls Split.Delete(t, ch) *)
  END;

TYPE Decoration = BRANDED REF RECORD
    inst, windowTitle, iconTitle, applName: TEXT;
    bgColorR, bgColorG, bgColorB: REAL;
    iconWindow: VBT.T
  END;

TYPE
  InstallRef = REF RECORD
                     installCount                   := 0;
                     c           : Thread.Condition
                   END;
  (* There is one of these on the property set of every installed
     VBT, with installCount &gt; 0. *)
</PRE> Each different <CODE>type</CODE> of Trestle.T (e.g., an XClient.T)
   registers a ConnectClosure; these are tried in turn by
   Trestle.Connect. 

<P><PRE>TYPE ConnectClosure =
  OBJECT METHODS
    &lt;* LL.sup &lt;= TrestleClass.connectMu *&gt;
    apply(inst: TEXT; localOnly: BOOLEAN; VAR (*OUT*) t: Trestle.T): BOOLEAN
  END;
</PRE><BLOCKQUOTE><EM> If cc is a ConnectClosure, cc.apply(inst, localOnly, t) is like t
   := Trestle.Connect(inst, localOnly); RETURN TRUE, provided that inst
   and localOnly are acceptable to cc; otherwise it is equivalent to
   t := NIL; RETURN FALSE.  When cc.apply is called, LL.sup &lt;=
   TrestleClass.connectMu.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TrestleClass.m3#RegisterConnectClosure">RegisterConnectClosure</A>(cc: ConnectClosure);
</PRE><BLOCKQUOTE><EM> Add cc to the list of ConnectClosures that will be tried
   by Connect. LL.sup &lt; VBT.mu </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TrestleClass.m3#Connect">Connect</A>(
    inst: TEXT := NIL;
    localOnly: BOOLEAN := FALSE)
    : Trestle.T
  RAISES {Failure}; &lt;* LL.sup &lt;= TrestleClass.connectMu *&gt;
  (* Implements Trestle.Connect. *)

END TrestleClass.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
